/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.potioncore;

import com.tmtravlr.potioncore.ConfigLoader;
import com.tmtravlr.potioncore.PotionCore;
import com.tmtravlr.potioncore.PotionCoreAttributes;
import com.tmtravlr.potioncore.PotionCoreHelper;
import com.tmtravlr.potioncore.potion.PotionAntidote;
import com.tmtravlr.potioncore.potion.PotionArchery;
import com.tmtravlr.potioncore.potion.PotionBless;
import com.tmtravlr.potioncore.potion.PotionBrokenArmor;
import com.tmtravlr.potioncore.potion.PotionChance;
import com.tmtravlr.potioncore.potion.PotionClimb;
import com.tmtravlr.potioncore.potion.PotionCorePotion;
import com.tmtravlr.potioncore.potion.PotionCure;
import com.tmtravlr.potioncore.potion.PotionCurse;
import com.tmtravlr.potioncore.potion.PotionDiamondSkin;
import com.tmtravlr.potioncore.potion.PotionDisorganization;
import com.tmtravlr.potioncore.potion.PotionDispel;
import com.tmtravlr.potioncore.potion.PotionDrown;
import com.tmtravlr.potioncore.potion.PotionExplosion;
import com.tmtravlr.potioncore.potion.PotionExplosionSelf;
import com.tmtravlr.potioncore.potion.PotionExtension;
import com.tmtravlr.potioncore.potion.PotionFire;
import com.tmtravlr.potioncore.potion.PotionFlight;
import com.tmtravlr.potioncore.potion.PotionInvert;
import com.tmtravlr.potioncore.potion.PotionIronSkin;
import com.tmtravlr.potioncore.potion.PotionKlutz;
import com.tmtravlr.potioncore.potion.PotionLaunch;
import com.tmtravlr.potioncore.potion.PotionLightning;
import com.tmtravlr.potioncore.potion.PotionLove;
import com.tmtravlr.potioncore.potion.PotionMagicFocus;
import com.tmtravlr.potioncore.potion.PotionMagicInhibition;
import com.tmtravlr.potioncore.potion.PotionMagicShield;
import com.tmtravlr.potioncore.potion.PotionPerplexity;
import com.tmtravlr.potioncore.potion.PotionPotionSickness;
import com.tmtravlr.potioncore.potion.PotionPurity;
import com.tmtravlr.potioncore.potion.PotionReach;
import com.tmtravlr.potioncore.potion.PotionRecoil;
import com.tmtravlr.potioncore.potion.PotionRepair;
import com.tmtravlr.potioncore.potion.PotionRevival;
import com.tmtravlr.potioncore.potion.PotionRust;
import com.tmtravlr.potioncore.potion.PotionSlowfall;
import com.tmtravlr.potioncore.potion.PotionSolidCore;
import com.tmtravlr.potioncore.potion.PotionStepup;
import com.tmtravlr.potioncore.potion.PotionTeleport;
import com.tmtravlr.potioncore.potion.PotionTeleportSpawn;
import com.tmtravlr.potioncore.potion.PotionTeleportSurface;
import com.tmtravlr.potioncore.potion.PotionVulnerable;
import com.tmtravlr.potioncore.potion.PotionWeight;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionHealth;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PotionCoreEffects {
    public static final HashMap<String, PotionCorePotion> POTIONS = new HashMap();
    public static final ArrayList<Potion> GOOD_EFFECTS = new ArrayList();
    public static final ArrayList<Potion> BAD_EFFECTS = new ArrayList();
    public static final HashMap<Potion, Potion> OPPOSITE_EFFECTS = new HashMap();

    public static void loadPotionEffects(IForgeRegistry<Potion> registry) {
        MobEffects.field_76429_m.func_111184_a(PotionCoreAttributes.DAMAGE_RESISTANCE, "f26465f4-bdf0-4014-99ae-2d52c22953e0", 0.2, 1);
        MobEffects.field_76422_e.func_111184_a(PotionCoreAttributes.DIG_SPEED, "00b4c426-2fae-46dd-a3f1-708c95beb21c", 0.2, 1);
        if (ConfigLoader.fixSaturation) {
            Potion fixedSaturation = (Potion)new PotionHealth(false, 16262179){

                public void func_180793_a(@Nullable Entity source, @Nullable Entity indirectSource, EntityLivingBase entityLivingBaseIn, int amplifier, double health) {
                    amplifier = (int)(health * (double)amplifier);
                    this.func_76394_a(entityLivingBaseIn, amplifier);
                }
            }.func_76390_b("effect.saturation").func_188413_j().setRegistryName(new ResourceLocation("minecraft:saturation"));
            registry.register((IForgeRegistryEntry)fixedSaturation);
            PotionCoreEffects.replaceVanillaSaturation(fixedSaturation);
        }
        if (ConfigLoader.controllableJumpBoost) {
            MobEffects.field_76430_j.func_111184_a(PotionCoreAttributes.JUMP_HEIGHT, "3f9ee864-485e-4ce8-9226-a0a4dbc50b0f", (double)PotionCoreHelper.vanillaJumpBoostModifier, 0);
        } else {
            MobEffects.field_76430_j.func_111184_a(PotionCoreAttributes.JUMP_HEIGHT, "3f9ee864-485e-4ce8-9226-a0a4dbc50b0f", 1.0, 0);
        }
        for (PotionCorePotion potion : POTIONS.values()) {
            if (!potion.isEnabled()) continue;
            potion.registerPotionAttributeModifiers();
            registry.register((IForgeRegistryEntry)potion);
        }
    }

    public static void loadGoodBadEffects() {
        for (ResourceLocation potionName : Potion.field_188414_b.func_148742_b()) {
            Potion potion;
            if (ConfigLoader.chanceBlacklist.contains(potionName.toString()) || (potion = (Potion)Potion.field_188414_b.func_82594_a((Object)potionName)) == null) continue;
            if (potion.func_76398_f()) {
                BAD_EFFECTS.add(potion);
                continue;
            }
            GOOD_EFFECTS.add(potion);
        }
    }

    public static void loadInversions() {
        PotionCoreEffects.loadInversion(MobEffects.field_76440_q, MobEffects.field_76439_r);
        PotionCoreEffects.loadInversion(MobEffects.field_76420_g, MobEffects.field_76437_t);
        PotionCoreEffects.loadInversion(MobEffects.field_76422_e, MobEffects.field_76419_f);
        PotionCoreEffects.loadInversion(MobEffects.field_76426_n, PotionFire.INSTANCE);
        PotionCoreEffects.loadInversion(MobEffects.field_76433_i, MobEffects.field_76432_h);
        PotionCoreEffects.loadInversion(MobEffects.field_76438_s, MobEffects.field_76443_y);
        PotionCoreEffects.loadInversion(MobEffects.field_76430_j, PotionWeight.INSTANCE);
        PotionCoreEffects.loadInversion(MobEffects.field_76421_d, MobEffects.field_76424_c);
        PotionCoreEffects.loadInversion(MobEffects.field_76436_u, PotionAntidote.INSTANCE);
        PotionCoreEffects.loadInversion(MobEffects.field_76428_l, MobEffects.field_82731_v);
        PotionCoreEffects.loadInversion(MobEffects.field_76429_m, PotionVulnerable.INSTANCE);
        PotionCoreEffects.loadInversion(MobEffects.field_76427_o, PotionDrown.INSTANCE);
        PotionCoreEffects.loadInversion(PotionArchery.INSTANCE, PotionKlutz.INSTANCE);
        PotionCoreEffects.loadInversion(PotionBless.INSTANCE, PotionCurse.INSTANCE);
        PotionCoreEffects.loadInversion(PotionCure.INSTANCE, PotionDispel.INSTANCE);
        PotionCoreEffects.loadInversion(MobEffects.field_188424_y, PotionSlowfall.INSTANCE);
        PotionCoreEffects.loadInversion(PotionRepair.INSTANCE, PotionRust.INSTANCE);
        PotionCoreEffects.loadInversion(PotionMagicFocus.INSTANCE, PotionMagicInhibition.INSTANCE);
    }

    private static void loadInversion(Potion potion1, Potion potion2) {
        if (potion1 != null && potion2 != null) {
            OPPOSITE_EFFECTS.put(potion1, potion2);
            OPPOSITE_EFFECTS.put(potion2, potion1);
        }
    }

    private static void replaceVanillaSaturation(Potion fixedSaturation) {
        Exception caught = null;
        Potion saturation = MobEffects.field_76443_y;
        try {
            Class<MobEffects> mobEffectsClass = MobEffects.class;
            String[] fieldNames = new String[]{"field_76443_y", "SATURATION"};
            Field f = null;
            for (String fieldName : fieldNames) {
                try {
                    f = mobEffectsClass.getDeclaredField(fieldName);
                    f.setAccessible(true);
                    Field modifiersField = Field.class.getDeclaredField("modifiers");
                    modifiersField.setAccessible(true);
                    modifiersField.setInt(f, f.getModifiers() & 0xFFFFFFEF);
                    f.set(null, fixedSaturation);
                    return;
                }
                catch (Exception e) {
                    caught = e;
                }
            }
        }
        catch (Exception e) {
            caught = e;
        }
        PotionCore.logger.warn("Unable to fix saturation", (Throwable)caught);
    }

    static {
        POTIONS.put("fire", PotionFire.INSTANCE);
        POTIONS.put("lightning", PotionLightning.INSTANCE);
        POTIONS.put("explode", PotionExplosion.INSTANCE);
        POTIONS.put("burst", PotionExplosionSelf.INSTANCE);
        POTIONS.put("weight", PotionWeight.INSTANCE);
        POTIONS.put("recoil", PotionRecoil.INSTANCE);
        POTIONS.put("drown", PotionDrown.INSTANCE);
        POTIONS.put("archery", PotionArchery.INSTANCE);
        POTIONS.put("klutz", PotionKlutz.INSTANCE);
        POTIONS.put("vulnerable", PotionVulnerable.INSTANCE);
        POTIONS.put("antidote", PotionAntidote.INSTANCE);
        POTIONS.put("purity", PotionPurity.INSTANCE);
        POTIONS.put("cure", PotionCure.INSTANCE);
        POTIONS.put("dispel", PotionDispel.INSTANCE);
        POTIONS.put("slow_fall", PotionSlowfall.INSTANCE);
        POTIONS.put("solid_core", PotionSolidCore.INSTANCE);
        POTIONS.put("launch", PotionLaunch.INSTANCE);
        POTIONS.put("climb", PotionClimb.INSTANCE);
        POTIONS.put("love", PotionLove.INSTANCE);
        POTIONS.put("step_up", PotionStepup.INSTANCE);
        POTIONS.put("perplexity", PotionPerplexity.INSTANCE);
        POTIONS.put("disorganization", PotionDisorganization.INSTANCE);
        POTIONS.put("repair", PotionRepair.INSTANCE);
        POTIONS.put("rust", PotionRust.INSTANCE);
        POTIONS.put("extension", PotionExtension.INSTANCE);
        POTIONS.put("chance", PotionChance.INSTANCE);
        POTIONS.put("bless", PotionBless.INSTANCE);
        POTIONS.put("curse", PotionCurse.INSTANCE);
        POTIONS.put("flight", PotionFlight.INSTANCE);
        POTIONS.put("teleport", PotionTeleport.INSTANCE);
        POTIONS.put("teleport_surface", PotionTeleportSurface.INSTANCE);
        POTIONS.put("teleport_spawn", PotionTeleportSpawn.INSTANCE);
        POTIONS.put("invert", PotionInvert.INSTANCE);
        POTIONS.put("revival", PotionRevival.INSTANCE);
        POTIONS.put("reach", PotionReach.INSTANCE);
        POTIONS.put("magic_focus", PotionMagicFocus.INSTANCE);
        POTIONS.put("magic_inhibition", PotionMagicInhibition.INSTANCE);
        POTIONS.put("magic_shield", PotionMagicShield.INSTANCE);
        POTIONS.put("iron_skin", PotionIronSkin.INSTANCE);
        POTIONS.put("broken_armor", PotionBrokenArmor.INSTANCE);
        POTIONS.put("diamond_skin", PotionDiamondSkin.INSTANCE);
        POTIONS.put("potion_sickness", PotionPotionSickness.INSTANCE);
    }
}

