/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.extraalchemy.recipes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.PotionType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import zabi.minecraft.extraalchemy.ExtraAlchemy;
import zabi.minecraft.extraalchemy.ModConfig;
import zabi.minecraft.extraalchemy.items.ItemPotionRing;
import zabi.minecraft.extraalchemy.items.ModItems;
import zabi.minecraft.extraalchemy.lib.Log;
import zabi.minecraft.extraalchemy.potion.PotionReference;
import zabi.minecraft.extraalchemy.potion.PotionTypeBase;
import zabi.minecraft.extraalchemy.recipes.GsonRecipe;
import zabi.minecraft.extraalchemy.recipes.brew.RecipeManager;
import zabi.minecraft.extraalchemy.recipes.crafting.QuickVialRecipeHandler;
import zabi.minecraft.extraalchemy.recipes.crafting.SplitPotionRecipeHandler;
import zabi.minecraft.extraalchemy.recipes.crafting.StickyPotionRecipeHandler;

@Mod.EventBusSubscriber
public class Recipes {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static int customRecipes = 0;

    public static void registerRecipes() {
        Recipes.loadCustomRecipes();
        if (ModConfig.potions.p_fuse) {
            RecipeManager.registerRecipeWithVariant(PotionTypes.field_185233_e, new ItemStack(Items.field_151154_bQ), PotionReference.INSTANCE.TYPE_FUSE_NORMAL, PotionReference.INSTANCE.TYPE_FUSE_QUICK, PotionReference.INSTANCE.TYPE_FUSE_STRONG);
        }
        if (ModConfig.potions.p_magnetism) {
            RecipeManager.registerRecipeWithVariant(PotionTypes.field_185233_e, new ItemStack(Items.field_151042_j), PotionReference.INSTANCE.TYPE_MAGNETISM_NORMAL, PotionReference.INSTANCE.TYPE_MAGNETISM_LONG, PotionReference.INSTANCE.TYPE_MAGNETISM_STRONG);
        }
        if (ModConfig.potions.p_piper) {
            RecipeManager.registerRecipeWithVariant(PotionTypes.field_185233_e, new ItemStack(Items.field_151015_O), PotionReference.INSTANCE.TYPE_PIPER_NORMAL, PotionReference.INSTANCE.TYPE_PIPER_LONG, PotionReference.INSTANCE.TYPE_PIPER_STRONG);
        }
        if (ModConfig.potions.p_photosynthesis) {
            RecipeManager.registerRecipeWithVariant(PotionTypes.field_185233_e, new ItemStack(Items.field_185163_cU), PotionReference.INSTANCE.TYPE_PHOTOSYNTHESIS_NORMAL, PotionReference.INSTANCE.TYPE_PHOTOSYNTHESIS_LONG, PotionReference.INSTANCE.TYPE_PHOTOSYNTHESIS_STRONG);
        }
        if (ModConfig.potions.p_reincarnation) {
            RecipeManager.registerRecipeWithVariant(PotionTypes.field_185233_e, new ItemStack(Items.field_151116_aA), PotionReference.INSTANCE.TYPE_REINCARNATION_NORMAL, PotionReference.INSTANCE.TYPE_REINCARNATION_LONG, PotionReference.INSTANCE.TYPE_REINCARNATION_STRONG);
        }
        if (ModConfig.potions.p_dislocation) {
            RecipeManager.registerRecipeWithVariant(PotionTypes.field_185231_c, new ItemStack(Items.field_185161_cS), PotionReference.INSTANCE.TYPE_DISLOCATION_NORMAL, PotionReference.INSTANCE.TYPE_DISLOCATION_LONG, PotionReference.INSTANCE.TYPE_DISLOCATION_STRONG);
        }
        if (ModConfig.potions.p_combustion) {
            RecipeManager.registerRecipeWithVariant(PotionTypes.field_185231_c, new ItemStack(Item.func_150898_a((Block)Blocks.field_150402_ci)), PotionReference.INSTANCE.TYPE_COMBUSTION_NORMAL, PotionReference.INSTANCE.TYPE_COMBUSTION_LONG, PotionReference.INSTANCE.TYPE_COMBUSTION_STRONG);
        }
        if (ModConfig.potions.p_learning) {
            RecipeManager.registerRecipeWithVariant(PotionTypes.field_185232_d, new ItemStack(Item.func_150898_a((Block)Blocks.field_150368_y)), PotionReference.INSTANCE.TYPE_LEARNING_NORMAL, PotionReference.INSTANCE.TYPE_LEARNING_LONG, PotionReference.INSTANCE.TYPE_LEARNING_STRONG);
        }
        if (ModConfig.potions.p_gravity) {
            RecipeManager.registerRecipeWithVariant(PotionTypes.field_185232_d, new ItemStack(Items.field_151130_bT), PotionReference.INSTANCE.TYPE_GRAVITY_NORMAL, PotionReference.INSTANCE.TYPE_GRAVITY_LONG, PotionReference.INSTANCE.TYPE_GRAVITY_STRONG);
        }
        if (ModConfig.potions.p_crumbling) {
            RecipeManager.registerRecipeWithVariant(PotionTypes.field_185232_d, new ItemStack(Items.field_151145_ak), PotionReference.INSTANCE.TYPE_CRUMBLING_NORMAL, PotionReference.INSTANCE.TYPE_CRUMBLING_LONG, PotionReference.INSTANCE.TYPE_CRUMBLING_STRONG);
        }
        if (ModConfig.potions.p_recall) {
            RecipeManager.registerRecipeWithVariant(PotionTypes.field_185247_s, new ItemStack(Items.field_151061_bv), PotionReference.INSTANCE.TYPE_RECALL_NORMAL, PotionReference.INSTANCE.TYPE_RECALL_LONG, PotionReference.INSTANCE.TYPE_RECALL_STRONG);
        }
        if (ModConfig.potions.p_sinking) {
            RecipeManager.registerRecipeWithVariant(PotionTypes.field_185248_t, new ItemStack(Items.field_151119_aD), PotionReference.INSTANCE.TYPE_SINKING_NORMAL, PotionReference.INSTANCE.TYPE_SINKING_LONG, PotionReference.INSTANCE.TYPE_SINKING_STRONG);
        }
        if (ModConfig.potions.p_pacifism) {
            RecipeManager.registerRecipeWithVariant(PotionTypes.field_185253_y, new ItemStack(Items.field_151153_ao), PotionReference.INSTANCE.TYPE_PACIFISM_NORMAL, PotionReference.INSTANCE.TYPE_PACIFISM_LONG, PotionReference.INSTANCE.TYPE_PACIFISM_STRONG);
        }
        if (ModConfig.potions.p_hurry) {
            RecipeManager.registerRecipeWithVariant(PotionReference.INSTANCE.TYPE_CHARGED2, new ItemStack(Items.field_151106_aX), PotionReference.INSTANCE.TYPE_HURRY_NORMAL, PotionReference.INSTANCE.TYPE_HURRY_LONG, PotionReference.INSTANCE.TYPE_HURRY_STRONG);
        }
        if (ModConfig.potions.p_leech) {
            RecipeManager.registerRecipeWithVariant(PotionTypes.field_185252_x, new ItemStack(Items.field_151060_bw), PotionReference.INSTANCE.TYPE_LEECH_NORMAL, PotionReference.INSTANCE.TYPE_LEECH_LONG, PotionReference.INSTANCE.TYPE_LEECH_STRONG);
        }
        if (ModConfig.potions.p_sails) {
            RecipeManager.registerRecipeWithVariant(PotionTypes.field_185244_p, new ItemStack(Items.field_151115_aP), PotionReference.INSTANCE.TYPE_SAILS_NORMAL, PotionReference.INSTANCE.TYPE_SAILS_LONG, PotionReference.INSTANCE.TYPE_SAILS_STRONG);
        }
        if (ModConfig.potions.p_beheading) {
            RecipeManager.registerRecipeWithVariant(PotionReference.INSTANCE.TYPE_CHARGED2, new ItemStack(Items.field_151078_bh), PotionReference.INSTANCE.TYPE_BEHEADING_NORMAL, PotionReference.INSTANCE.TYPE_BEHEADING_LONG, PotionReference.INSTANCE.TYPE_BEHEADING_STRONG);
        }
        if (ModConfig.potions.p_pain) {
            RecipeManager.registerRecipeWithVariant(PotionTypes.field_185226_I, new ItemStack(Items.field_191525_da), PotionReference.INSTANCE.TYPE_PAIN_NORMAL, PotionReference.INSTANCE.TYPE_PAIN_LONG, PotionReference.INSTANCE.TYPE_PAIN_STRONG);
        }
        if (ModConfig.potions.p_push) {
            RecipeManager.registerRecipeWithVariant(PotionReference.INSTANCE.TYPE_PULL_NORMAL, new ItemStack(Items.field_151071_bq), PotionReference.INSTANCE.TYPE_PUSH_NORMAL, PotionReference.INSTANCE.TYPE_PUSH_LONG, PotionReference.INSTANCE.TYPE_PUSH_STRONG);
        }
        if (ModConfig.potions.p_pull) {
            RecipeManager.registerRecipeWithVariant(PotionTypes.field_185243_o, new ItemStack(Items.field_151074_bl), PotionReference.INSTANCE.TYPE_PULL_NORMAL, PotionReference.INSTANCE.TYPE_PULL_LONG, PotionReference.INSTANCE.TYPE_PULL_STRONG);
        }
        if (ModConfig.potions.p_concentration) {
            RecipeManager.registerRecipe(PotionTypes.field_185233_e, (PotionType)PotionReference.INSTANCE.TYPE_CONCENTRATION, Items.field_151110_aK);
        }
        if (ModConfig.potions.p_freezing) {
            RecipeManager.registerRecipe(PotionTypes.field_185233_e, (PotionType)PotionReference.INSTANCE.TYPE_FREEZING, Items.field_151126_ay);
        }
        if (ModConfig.potions.p_return) {
            RecipeManager.registerRecipe(PotionTypes.field_185233_e, (PotionType)PotionReference.INSTANCE.TYPE_RETURN, Items.field_179562_cC);
        }
        if (ModConfig.potions.p_cheatDeath) {
            RecipeManager.registerRecipe((PotionType)PotionReference.INSTANCE.TYPE_CHARGED2, (PotionType)PotionReference.INSTANCE.TYPE_CHEAT_DEATH, Items.field_151153_ao);
        }
        if (ModConfig.potions.p_dispel) {
            RecipeManager.registerRecipe((PotionType)PotionReference.INSTANCE.TYPE_LEARNING_STRONG, (PotionType)PotionReference.INSTANCE.TYPE_DISPEL, Items.field_151170_bI);
        }
        if (ModConfig.potions.p_charged_level2) {
            RecipeManager.registerRecipe((PotionType)PotionReference.INSTANCE.TYPE_CHARGED, (PotionType)PotionReference.INSTANCE.TYPE_CHARGED2, Items.field_179563_cD);
        }
        if (ModConfig.potions.p_charged_level1) {
            RecipeManager.registerRecipe(PotionTypes.field_185232_d, (PotionType)PotionReference.INSTANCE.TYPE_CHARGED, Items.field_151043_k);
        }
        if (ModConfig.options.breakingPotions) {
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("extraalchemy", "vial"), null, (ItemStack)new ItemStack(ModItems.vial_break, 3), (Object[])new Object[]{" F ", "G G", " G ", Character.valueOf('G'), "blockGlass", Character.valueOf('F'), Items.field_151145_ak});
        }
        if (ModConfig.options.enable_potion_bag) {
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("extraalchemy", "recipe_potion_bag"), null, (ItemStack)new ItemStack(ModItems.potion_bag), (Object[])new Object[]{" V ", "LWL", "LLL", Character.valueOf('V'), Items.field_151069_bo, Character.valueOf('W'), "chestWood", Character.valueOf('L'), "leather"});
        }
        if (ModConfig.options.enablePotionRings) {
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("extraalchemy", "empty_ring"), null, (ItemStack)new ItemStack(ModItems.empty_ring), (Object[])new Object[]{"NIN", "IBI", "NIN", Character.valueOf('I'), Items.field_151043_k, Character.valueOf('N'), Items.field_151074_bl, Character.valueOf('B'), Items.field_151069_bo});
            ItemPotionRing.addRecipes();
        }
    }

    private static void loadCustomRecipes() {
        if (ExtraAlchemy.recipesDirectory.mkdir()) {
            try {
                Recipes.generateExampleRecipe();
            }
            catch (IOException e) {
                Log.e("Cannot generate example file");
                e.printStackTrace();
            }
        } else if (!ExtraAlchemy.recipesDirectory.isDirectory()) {
            Log.e("Cannot access custom potion folder");
            return;
        }
        for (File json : ExtraAlchemy.recipesDirectory.listFiles()) {
            if (!json.isFile() || !json.getName().endsWith(".json")) continue;
            Recipes.readJson(json);
        }
        Log.i("Generated " + customRecipes + " custom recipes");
    }

    private static void generateExampleRecipe() throws IOException {
        GsonRecipe example = new GsonRecipe();
        example.name = "normal_potion";
        example.ingredient = "minecraft:rotten_flesh";
        example.durationSeconds = 120;
        example.level = 0;
        example.effect = "minecraft:unluck";
        example.autoGenerateLongVersion = true;
        example.autoGenerateStrongVersion = true;
        example.durationLongVersion = 240;
        example.durationStrongVersion = 60;
        Recipes.writeFile("example_normal_potion", example);
        example.name = "instant_with_meta";
        example.ingredient = "minecraft:dye@2";
        example.durationSeconds = 0;
        example.level = 0;
        example.basePotionType = "minecraft:harming";
        example.effect = "minecraft:instant_damage";
        example.autoGenerateLongVersion = false;
        example.autoGenerateStrongVersion = true;
        example.durationLongVersion = 0;
        example.durationStrongVersion = 0;
        Recipes.writeFile("example_instant_effect_ingredient_metadata", example);
        example.name = "any_meta";
        example.ingredient = "minecraft:wool";
        example.durationSeconds = 0;
        example.level = 0;
        example.basePotionType = "minecraft:thick";
        example.effect = "minecraft:poison";
        example.autoGenerateLongVersion = false;
        example.autoGenerateStrongVersion = true;
        example.durationLongVersion = 0;
        example.durationStrongVersion = 0;
        Recipes.writeFile("example_any_metadata", example);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(String filename, GsonRecipe recipe) throws IOException {
        File destination = new File(ExtraAlchemy.recipesDirectory, filename + ".json_disabled");
        try (FileWriter writer = null;){
            writer = new FileWriter(destination);
            writer.write(gson.toJson((Object)recipe));
        }
    }

    private static void readJson(File json) {
        try {
            GsonRecipe recipe = (GsonRecipe)gson.fromJson((Reader)new FileReader(json), GsonRecipe.class);
            if (recipe.check()) {
                ResourceLocation typeName = new ResourceLocation(recipe.name);
                PotionType type = null;
                if (ForgeRegistries.POTION_TYPES.containsKey(typeName)) {
                    type = (PotionType)ForgeRegistries.POTION_TYPES.getValue(typeName);
                } else {
                    type = recipe.generateType().setArtificial(true);
                    ForgeRegistries.POTION_TYPES.register((IForgeRegistryEntry)type);
                }
                RecipeManager.registerRecipe(recipe.getBase(), type, recipe.getIngredient());
                Log.d("Registered custom potion recipe: " + type.getRegistryName());
                ++customRecipes;
                if (recipe.autoGenerateLongVersion) {
                    PotionTypeBase longType = recipe.generateTypeLong().setArtificial(true);
                    ForgeRegistries.POTION_TYPES.register((IForgeRegistryEntry)longType);
                    RecipeManager.registerRecipe(type, (PotionType)longType, RecipeManager.redstone);
                    Log.d("Registered custom potion recipe: " + longType.getRegistryName());
                    ++customRecipes;
                }
                if (recipe.autoGenerateStrongVersion) {
                    PotionTypeBase strongType = recipe.generateTypeStrong().setArtificial(true);
                    ForgeRegistries.POTION_TYPES.register((IForgeRegistryEntry)strongType);
                    RecipeManager.registerRecipe(type, (PotionType)strongType, RecipeManager.glowstone);
                    Log.d("Registered custom potion recipe: " + strongType.getRegistryName());
                    ++customRecipes;
                }
            } else {
                Log.w("Json recipe contains errors: " + json.getAbsolutePath());
            }
        }
        catch (JsonIOException | JsonSyntaxException | FileNotFoundException e) {
            Log.e("Cannot read custom potion recipe from file " + json.getName());
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> evt) {
        IForgeRegistry reg = evt.getRegistry();
        if (ModConfig.options.allowPotionCombining) {
            reg.register((IForgeRegistryEntry)new StickyPotionRecipeHandler());
        }
        if (ModConfig.options.allowPotionSplitting) {
            reg.register((IForgeRegistryEntry)new SplitPotionRecipeHandler());
        }
        if (ModConfig.options.breakingPotions) {
            reg.register((IForgeRegistryEntry)new QuickVialRecipeHandler());
        }
    }
}

