/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.extraalchemy;

import com.google.common.collect.UnmodifiableIterator;
import java.io.File;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import zabi.minecraft.extraalchemy.ModConfig;
import zabi.minecraft.extraalchemy.blocks.BrewingStandFire;
import zabi.minecraft.extraalchemy.capability.MagnetismStatus;
import zabi.minecraft.extraalchemy.capability.RingCharge;
import zabi.minecraft.extraalchemy.gui.GuiHandler;
import zabi.minecraft.extraalchemy.integration.BotaniaHandler;
import zabi.minecraft.extraalchemy.items.ItemPotionRing;
import zabi.minecraft.extraalchemy.items.TabExtraAlchemy;
import zabi.minecraft.extraalchemy.lib.Log;
import zabi.minecraft.extraalchemy.network.NetworkModRegistry;
import zabi.minecraft.extraalchemy.potion.PotionReference;
import zabi.minecraft.extraalchemy.potion.potion.PotionBeheading;
import zabi.minecraft.extraalchemy.potion.potion.PotionCheatDeath;
import zabi.minecraft.extraalchemy.potion.potion.PotionCombustion;
import zabi.minecraft.extraalchemy.potion.potion.PotionHurry;
import zabi.minecraft.extraalchemy.potion.potion.PotionLeech;
import zabi.minecraft.extraalchemy.potion.potion.PotionMagnetism;
import zabi.minecraft.extraalchemy.potion.potion.PotionPacifism;
import zabi.minecraft.extraalchemy.potion.potion.PotionPain;
import zabi.minecraft.extraalchemy.potion.potion.PotionReincarnation;
import zabi.minecraft.extraalchemy.proxy.Proxy;
import zabi.minecraft.extraalchemy.recipes.Recipes;
import zabi.minecraft.extraalchemy.recipes.brew.BrewingStandBlocker;
import zabi.minecraft.extraalchemy.recipes.crafting.StickyPotionRecipeHandler;
import zabi.minecraft.minerva.common.capability.SimpleCapability;

@Mod(name="Extra Alchemy", modid="extraalchemy", version="0.5.2", dependencies="required-after:minerva@[1.0.13,);after:botania", acceptedMinecraftVersions="[1.12,1.13)", certificateFingerprint="b851b8b7c7f4d8d0e910ff27618150ba80c026ec")
public class ExtraAlchemy {
    public static TabExtraAlchemy TAB = new TabExtraAlchemy();
    public static SimpleNetworkWrapper network = NetworkRegistry.INSTANCE.newSimpleChannel("extraalchemy");
    @SidedProxy(modId="extraalchemy", clientSide="zabi.minecraft.extraalchemy.proxy.ClientProxy", serverSide="zabi.minecraft.extraalchemy.proxy.ServerProxy")
    public static Proxy proxy;
    public static File recipesDirectory;
    @Mod.Instance
    public static ExtraAlchemy instance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        PotionReference.INSTANCE.getClass();
        proxy.registerEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)new PotionPacifism.PacifismHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PotionMagnetism.MagnetismHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PotionCheatDeath.PotionCheatDeathHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PotionReincarnation.PotionReincarnationHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PotionCombustion.PotionCombustionHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PotionLeech.PotionLeechHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PotionBeheading.PotionBeheadingHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PotionPain.PotionPainHandler());
        MinecraftForge.EVENT_BUS.register((Object)new BrewingStandBlocker());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        SimpleCapability.preInit(MagnetismStatus.class);
        SimpleCapability.preInit(RingCharge.class);
        if (ModConfig.options.useFireUndernathBrewingStand) {
            MinecraftForge.EVENT_BUS.register((Object)new BrewingStandFire());
        }
        Log.i("Registering Network Protocol");
        NetworkModRegistry.registerMessages(network);
        proxy.registerItemDescriptions();
        recipesDirectory = new File(event.getModConfigurationDirectory(), "custom_potions");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        TAB.func_78016_d();
        BotaniaHandler.checkLoadBotania();
        Recipes.registerRecipes();
        proxy.registerColorHandler();
        SimpleCapability.init(MagnetismStatus.class, (String)"extraalchemy", MagnetismStatus.CAPABILITY, (SimpleCapability)MagnetismStatus.DEFAULT);
        SimpleCapability.init(RingCharge.class, (String)"extraalchemy", RingCharge.CAPABILITY, (SimpleCapability)RingCharge.DEFAULT);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ModConfig.ChangeListener());
        if (ModConfig.options.log_potion_types) {
            Log.i("\n\n\n-----------------------------v- LOGGING POTIONS -v-----------------------------\n\n\n");
            PotionType.field_185176_a.forEach(pt -> Log.i(pt.getRegistryName().toString()));
            Log.i("\n\n\n-----------------------------^- LOGGING POTIONS -^-----------------------------\n\n\n");
        }
    }

    @Mod.EventHandler
    public void fingerprintError(FMLFingerprintViolationEvent evt) {
        Log.w("");
        Log.w("");
        Log.w("");
        Log.w("Fingerprint on Extra Alchemy doesn't match");
        Log.w("This may be due to the mod file being modified illegally");
        Log.w("Make sure to only download mod from a reliable source, like");
        Log.w("https://minecraft.curseforge.com/");
        Log.w("");
        Log.w("");
        Log.w("");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Mod.EventHandler
    public void receiveIMC(FMLInterModComms.IMCEvent event) {
        UnmodifiableIterator unmodifiableIterator = event.getMessages().iterator();
        while (true) {
            FMLInterModComms.IMCMessage imcMessage;
            block18: {
                block19: {
                    if (!unmodifiableIterator.hasNext()) {
                        return;
                    }
                    imcMessage = (FMLInterModComms.IMCMessage)unmodifiableIterator.next();
                    if (!imcMessage.key.equalsIgnoreCase("sticky-blacklist")) break block19;
                    if (imcMessage.isStringMessage()) {
                        StickyPotionRecipeHandler.potionBlacklist.add(imcMessage.getStringValue());
                        Log.i(imcMessage.getStringValue() + " has been added to blacklist");
                        break block18;
                    } else if (imcMessage.isItemStackMessage()) {
                        ItemStack is = imcMessage.getItemStackValue();
                        List listaEffetti = PotionUtils.func_185189_a((ItemStack)is);
                        if (listaEffetti.isEmpty()) {
                            Log.e(imcMessage.getSender() + " tried to blacklist a potion, but the itemstack has no effects");
                            continue;
                        }
                        if (listaEffetti.size() > 1) {
                            Log.e(imcMessage.getSender() + " tried to blacklist a potion, but the itemstack has more than one effect");
                            continue;
                        }
                        StickyPotionRecipeHandler.potionBlacklist.add(((PotionEffect)listaEffetti.get(0)).func_188419_a().func_76393_a());
                        Log.i(((PotionEffect)listaEffetti.get(0)).func_188419_a().func_76393_a() + " has been added to blacklist");
                        break block18;
                    } else {
                        Log.e(imcMessage.getSender() + " tried to blacklist a potion, but only String and Itemstack messages are supported");
                    }
                    break block18;
                }
                if (imcMessage.key.equalsIgnoreCase("damage-blacklist")) {
                    if (imcMessage.isStringMessage()) {
                        PotionCheatDeath.blacklist.add(imcMessage.getStringValue());
                        Log.i(imcMessage.getStringValue() + " has been added to damage blacklist");
                        break block18;
                    } else {
                        Log.e(imcMessage.getSender() + " tried to blacklist a damage source, but it is not a string. Use damageSourceObj.damageType");
                        continue;
                    }
                }
                if (imcMessage.key.equalsIgnoreCase("hurry-blacklist")) {
                    if (imcMessage.isStringMessage()) {
                        PotionHurry.blacklist.add(imcMessage.getStringValue());
                        Log.i(imcMessage.getStringValue() + " has been added to hurry blacklist");
                    } else {
                        Log.e(imcMessage.getSender() + " tried to blacklist an ITicking entity, but it is not a string. Use TileEntityClass.getName()");
                        continue;
                    }
                }
            }
            if (imcMessage.key.equalsIgnoreCase("add-ring")) {
                if (imcMessage.isStringMessage()) {
                    ItemPotionRing.addToWhitelist(imcMessage.getStringValue());
                    Log.i(imcMessage.getStringValue() + " has been added as a valid potion ring. This might not be effective if it holds more than 1 effect or if the effect doesn't exist");
                } else {
                    Log.e(imcMessage.getSender() + ": potion ring must be a STRING message of the PotionType registry name");
                    continue;
                }
            }
            if (!imcMessage.key.equalsIgnoreCase("remove-ring")) continue;
            if (imcMessage.isStringMessage()) {
                ItemPotionRing.removeFromWhitelist(imcMessage.getStringValue());
                Log.i(imcMessage.getStringValue() + " has been removed from valid potion rings");
                continue;
            }
            Log.e(imcMessage.getSender() + ": potion ring must be a STRING message of the PotionType registry name");
        }
    }
}

