/*
 * Decompiled with CFR 0.152.
 */
package knightminer.tcomplement.plugin.jei.highoven.mix;

import javax.annotation.Nonnull;
import knightminer.tcomplement.library.Util;
import knightminer.tcomplement.plugin.jei.highoven.melting.HighOvenMeltingCategory;
import knightminer.tcomplement.plugin.jei.highoven.mix.HighOvenMixWrapper;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class HighOvenMixCategory
implements IRecipeCategory<HighOvenMixWrapper> {
    public static final String CATEGORY = Util.resource("high_oven_mix");
    public static final ResourceLocation BACKGROUND = Util.getResource("textures/gui/jei/high_oven.png");
    public static ResourceLocation background_loc = Util.getResource("textures/gui/jei/high_oven.png");
    protected final IDrawable background;
    private final IDrawable scalaInput;
    private final IDrawable scalaOutput;
    private final IDrawableAnimated progress;
    private final IDrawableAnimated flame;

    public HighOvenMixCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(BACKGROUND, 0, 0, 160, 62);
        this.scalaInput = guiHelper.createDrawable(BACKGROUND, 160, 68, 16, 52);
        this.scalaOutput = guiHelper.createDrawable(BACKGROUND, 160, 16, 35, 52);
        IDrawableStatic progressDrawable = guiHelper.createDrawable(BACKGROUND, 160, 0, 3, 16);
        this.progress = guiHelper.createAnimatedDrawable(progressDrawable, 200, IDrawableAnimated.StartDirection.BOTTOM, false);
        IDrawableStatic flameDrawable = guiHelper.createDrawable(BACKGROUND, 163, 0, 14, 14);
        this.flame = guiHelper.createAnimatedDrawable(flameDrawable, 200, IDrawableAnimated.StartDirection.TOP, true);
    }

    @Nonnull
    public String getUid() {
        return CATEGORY;
    }

    @Nonnull
    public String getTitle() {
        return Util.translate("gui.jei.high_oven.mix.title", new Object[0]);
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.flame.draw(minecraft, 78, 22);
        this.progress.draw(minecraft, 8, 5);
    }

    public void setRecipe(IRecipeLayout recipeLayout, HighOvenMixWrapper recipe, IIngredients ingredients) {
        IGuiItemStackGroup items = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluids = recipeLayout.getFluidStacks();
        items.addTooltipCallback((ITooltipCallback)recipe);
        items.init(0, true, 31, 4);
        items.init(1, true, 31, 22);
        items.init(2, true, 31, 40);
        items.init(3, true, 11, 4);
        items.set(ingredients);
        items.init(4, true, 77, 38);
        items.set(4, HighOvenMeltingCategory.getHighOvenFuels());
        fluids.init(0, true, 12, 41, 16, 16, 1, false, null);
        fluids.init(1, false, 120, 5, 35, 52, 1296, false, this.scalaOutput);
        fluids.set(ingredients);
    }

    public String getModName() {
        return "Tinkers' Complement";
    }
}

