/*
 * Decompiled with CFR 0.152.
 */
package panda.divergentunderground.common.world;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;
import panda.divergentunderground.ConfigDivergentUnderground;
import panda.divergentunderground.common.blocks.BlockHardStone;
import panda.divergentunderground.init.ModBlocks;

public class FeatureGenerator
implements IWorldGenerator {
    private final Predicate<IBlockState> predicate = new StonePredicate();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.getDimension() == 0) {
            if (ConfigDivergentUnderground.enableFossils) {
                this.generateFossil(world, random, chunkX << 4, chunkZ << 4, 0, 64, 3 + random.nextInt(3), ConfigDivergentUnderground.fossilTries);
            }
            if (ConfigDivergentUnderground.enableBoulders) {
                this.generateSingleOre(ModBlocks.BOULDER.func_176223_P(), world, random, chunkX << 4, chunkZ << 4, 0, 50, ConfigDivergentUnderground.boulderTries);
            }
        }
    }

    private void generateFossil(World world, Random random, int x, int z, int minY, int maxY, int size, int chances) {
        int deltaY = maxY - minY;
        for (int i = 0; i < chances; ++i) {
            int cx = x + random.nextInt(16);
            int cz = z + random.nextInt(16);
            int cy = minY + random.nextInt(deltaY);
            BlockPos pos = new BlockPos(cx, cy, cz);
            int ty = world.func_175672_r(new BlockPos(cx, cy, cz)).func_177956_o();
            WorldGenMinable generator = new WorldGenMinable(((BlockHardStone)ModBlocks.FOSSIL).getStateFromDepth(ty, cy, false).func_177231_a((IProperty)BlockHardStone.DEPTH), size);
            generator.func_180709_b(world, random, pos);
        }
    }

    private void generateSingleOre(IBlockState state, World world, Random random, int x, int z, int minY, int maxY, int chances) {
        int deltaY = maxY - minY;
        for (int i = 0; i < chances; ++i) {
            BlockPos pos = new BlockPos(x + random.nextInt(16), minY + random.nextInt(deltaY), z + random.nextInt(16));
            if (!state.func_177230_c().isReplaceableOreGen(state, (IBlockAccess)world, pos, this.predicate)) continue;
            world.func_180501_a(pos, state, 2);
        }
    }

    static class StonePredicate
    implements Predicate<IBlockState> {
        private StonePredicate() {
        }

        public boolean apply(IBlockState toTest) {
            if (toTest != null && toTest.func_177230_c() == Blocks.field_150348_b) {
                BlockStone.EnumType blockstone = (BlockStone.EnumType)toTest.func_177229_b((IProperty)BlockStone.field_176247_a);
                return blockstone.func_190912_e();
            }
            return false;
        }
    }
}

