/*
 * Decompiled with CFR 0.152.
 */
package panda.divergentunderground;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import panda.divergentunderground.ConfigDivergentUnderground;
import panda.divergentunderground.common.blocks.BlockHardStone;
import panda.divergentunderground.common.eventhandler.EventsHandler;
import panda.divergentunderground.common.world.FeatureGenerator;
import panda.divergentunderground.common.world.StoneGenerator;
import panda.divergentunderground.experimental.CompatibilityPlugin;
import panda.divergentunderground.experimental.ICompatibilityPlugin;
import panda.divergentunderground.init.ModItems;
import panda.divergentunderground.init.ModRecipes;
import panda.divergentunderground.proxy.CommonProxy;
import panda.divergentunderground.registries.GemRegistry;
import panda.divergentunderground.registries.OreRegistry;
import panda.divergentunderground.registries.RockRegistry;

@Mod(modid="divergentunderground", name="Divergent Underground", version="0.64.0", dependencies="after:biomesoplenty;after:thermalfoundation;after:cofhworld;after:thermalexpansion;after:ic2;after:mekanism;after:forestry;after:immersiveengineering;after:quark;after:basemetals;after:thaumcraft;after:basemetals;after:chisel;after:tconstruct;", acceptedMinecraftVersions="[1.12.2]")
public class DivergentUnderground {
    public static final String MODID = "divergentunderground";
    public static final String VERSION = "0.64.0";
    public static final String NAME = "Divergent Underground";
    public static SimpleNetworkWrapper wrapper;
    @Mod.Instance(value="divergentunderground")
    public static DivergentUnderground instance;
    @SidedProxy(clientSide="panda.divergentunderground.proxy.ClientProxy", serverSide="panda.divergentunderground.proxy.ServerProxy")
    public static CommonProxy proxy;
    public static final Logger logger;
    public Configuration config;
    public static final Set<ICompatibilityPlugin> COMPAT_PLUGINS;
    public static final CreativeTabs Tab;

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
        COMPAT_PLUGINS.addAll(CompatibilityPlugin.Gather.gather(event.getAsmData()));
        this.config = new Configuration(event.getSuggestedConfigurationFile());
        ConfigDivergentUnderground.load(this.config);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new StoneGenerator(), (int)Integer.MAX_VALUE);
        MinecraftForge.EVENT_BUS.register((Object)new EventsHandler());
        for (ICompatibilityPlugin plugin : COMPAT_PLUGINS) {
            plugin.preInit();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        RockRegistry.initRocks();
        OreRegistry.initOres();
        GemRegistry.initGems();
        ModRecipes.register();
        proxy.registerColorHandlers();
        proxy.registerOreDicts();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new FeatureGenerator(), (int)3);
        for (ICompatibilityPlugin plugin : COMPAT_PLUGINS) {
            plugin.init();
        }
    }

    public static void doDicts(String type, Item ore, Block block) {
        OreDictionary.registerOre((String)("ore" + type), (Block)block);
        OreDictionary.registerOre((String)("ore" + type), (Item)ore);
        OreDictionary.registerOre((String)("rockOre" + type), (Item)ore);
    }

    static {
        logger = LogManager.getLogger((String)MODID);
        COMPAT_PLUGINS = Sets.newHashSet();
        Tab = new CreativeTabs(MODID){

            public ItemStack func_78016_d() {
                return new ItemStack(ModItems.ORE_IRON);
            }

            @SideOnly(value=Side.CLIENT)
            public void func_78018_a(NonNullList<ItemStack> list) {
                for (Item item : Item.field_150901_e) {
                    if (Block.func_149634_a((Item)item) instanceof BlockHardStone && ConfigDivergentUnderground.hideHardVariants) continue;
                    item.func_150895_a((CreativeTabs)this, list);
                }
            }
        };
    }
}

