/*
 * Decompiled with CFR 0.152.
 */
package com.viesis.viescraft.configs;

import com.viesis.viescraft.api.util.LogHelper;
import java.io.File;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.config.Configuration;

public class ViesCraftConfig {
    public static Configuration config;
    public static final String CATEGORY_VC = "ViesCraft Config";
    public static boolean vanillaFuel;
    public static boolean outsideModFuel;
    public static int viesolineBurnTime;
    public static boolean recipeDismounterPlayer;
    public static boolean engineSounds;
    public static boolean renderNameplates;
    public static final boolean VANILLAFUEL_DEFAULT = true;
    public static final String VANILLAFUEL_NAME = "Enable using vanilla fuel?";
    public static final String VANILLAFUEL_COMMENT = "Should airships be able to use vanilla fuel?";
    public static final boolean OUTSIDEMODFUEL_DEFAULT = true;
    public static final String OUTSIDEMODFUEL_NAME = "Enable using other mod's fuel?";
    public static final String OUTSIDEMODFUEL_COMMENT = "Should airships be able to use other mod's fuel?";
    public static final int VIESOLINEBURNTIME_DEFAULT = 90;
    public static final String VIESOLINEBURNTIME_NAME = "Viesoline Burn Time?";
    public static final String VIESOLINEBURNTIME_COMMENT = "How long does Viesoline burn for in seconds? ";
    public static final boolean RECIPEDISMOUNTERPLAYER_DEFAULT = true;
    public static final String RECIPEDISMOUNTERPLAYER_NAME = "Enable Player Dismounter Recipe?";
    public static final String RECIPEDISMOUNTERPLAYER_COMMENT = "Should Player Dismounter be craftable?";
    public static final boolean ENGINESOUND_DEFAULT = true;
    public static final String ENGINESOUND_NAME = "Enable airship engine sounds?";
    public static final String ENGINESOUND_COMMENT = "Should airships have engine sounds when powered?";
    public static final boolean RENDERNAMEPLATES_DEFAULT = true;
    public static final String RENDERNAMEPLATES_NAME = "Enable airship overhead nameplates?";
    public static final String RENDERNAMEPLATES_COMMENT = "Should airships display their overhead nameplates?";

    public static void init(File file) {
        config = new Configuration(file);
        ViesCraftConfig.syncConfig();
        LogHelper.info("Good news everyone! The config has been loaded!");
    }

    public static void syncConfig() {
        String category2 = CATEGORY_VC + "." + TextFormatting.GREEN + "General";
        config.addCustomCategoryComment(category2, "General airship options.");
        recipeDismounterPlayer = config.getBoolean(TextFormatting.WHITE + RECIPEDISMOUNTERPLAYER_NAME, category2, true, RECIPEDISMOUNTERPLAYER_COMMENT);
        String category3 = CATEGORY_VC + "." + TextFormatting.AQUA + "Fuel";
        config.addCustomCategoryComment(category3, "Airship fuel options.");
        vanillaFuel = config.getBoolean(TextFormatting.WHITE + VANILLAFUEL_NAME, category3, true, VANILLAFUEL_COMMENT);
        outsideModFuel = config.getBoolean(TextFormatting.WHITE + OUTSIDEMODFUEL_NAME, category3, true, OUTSIDEMODFUEL_COMMENT);
        viesolineBurnTime = config.getInt(TextFormatting.WHITE + VIESOLINEBURNTIME_NAME, category3, 90, 1, 500, VIESOLINEBURNTIME_COMMENT);
        String category4 = CATEGORY_VC + "." + TextFormatting.GOLD + "Client";
        config.addCustomCategoryComment(category4, "Client airship options.");
        engineSounds = config.getBoolean(TextFormatting.WHITE + ENGINESOUND_NAME, category4, true, ENGINESOUND_COMMENT);
        renderNameplates = config.getBoolean(TextFormatting.WHITE + RENDERNAMEPLATES_NAME, category4, true, RENDERNAMEPLATES_COMMENT);
        config.save();
        config.load();
    }
}

