/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network;

import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.container.ContainerGrid;
import com.raoulvdberge.refinedstorage.network.MessageHandlerPlayerToServer;
import com.raoulvdberge.refinedstorage.tile.grid.WirelessGrid;
import com.raoulvdberge.refinedstorage.tile.grid.portable.PortableGrid;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MessageGridSettingsUpdate
extends MessageHandlerPlayerToServer<MessageGridSettingsUpdate>
implements IMessage {
    private int viewType;
    private int sortingDirection;
    private int sortingType;
    private int searchBoxMode;
    private int size;
    private int tabSelected;
    private int tabPage;

    public MessageGridSettingsUpdate() {
    }

    public MessageGridSettingsUpdate(int viewType, int sortingDirection, int sortingType, int searchBoxMode, int size, int tabSelected, int tabPage) {
        this.viewType = viewType;
        this.sortingDirection = sortingDirection;
        this.sortingType = sortingType;
        this.searchBoxMode = searchBoxMode;
        this.size = size;
        this.tabSelected = tabSelected;
        this.tabPage = tabPage;
    }

    public void fromBytes(ByteBuf buf) {
        this.viewType = buf.readInt();
        this.sortingDirection = buf.readInt();
        this.sortingType = buf.readInt();
        this.searchBoxMode = buf.readInt();
        this.size = buf.readInt();
        this.tabSelected = buf.readInt();
        this.tabPage = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.viewType);
        buf.writeInt(this.sortingDirection);
        buf.writeInt(this.sortingType);
        buf.writeInt(this.searchBoxMode);
        buf.writeInt(this.size);
        buf.writeInt(this.tabSelected);
        buf.writeInt(this.tabPage);
    }

    @Override
    public void handle(MessageGridSettingsUpdate message, EntityPlayerMP player) {
        IGrid grid;
        if (player.field_71070_bA instanceof ContainerGrid && ((grid = ((ContainerGrid)player.field_71070_bA).getGrid()) instanceof WirelessGrid || grid instanceof PortableGrid)) {
            ItemStack stack;
            ItemStack itemStack = stack = grid instanceof WirelessGrid ? ((WirelessGrid)grid).getStack() : ((PortableGrid)grid).getStack();
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if (IGrid.isValidViewType(message.viewType)) {
                stack.func_77978_p().func_74768_a("ViewType", message.viewType);
            }
            if (IGrid.isValidSortingDirection(message.sortingDirection)) {
                stack.func_77978_p().func_74768_a("SortingDirection", message.sortingDirection);
            }
            if (IGrid.isValidSortingType(message.sortingType)) {
                stack.func_77978_p().func_74768_a("SortingType", message.sortingType);
            }
            if (IGrid.isValidSearchBoxMode(message.searchBoxMode)) {
                stack.func_77978_p().func_74768_a("SearchBoxMode", message.searchBoxMode);
            }
            if (IGrid.isValidSize(message.size)) {
                stack.func_77978_p().func_74768_a("Size", message.size);
            }
            stack.func_77978_p().func_74768_a("TabSelected", message.tabSelected);
            stack.func_77978_p().func_74768_a("TabPage", message.tabPage);
        }
    }
}

