/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.minerva.common.entity.synchronization;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import zabi.minecraft.minerva.common.entity.EntityHelper;
import zabi.minecraft.minerva.common.entity.UUIDs;
import zabi.minecraft.minerva.common.entity.synchronization.SyncTask;

@Mod.EventBusSubscriber
public class SyncManager {
    private static HashMap<UUID, ArrayList<SyncTask<EntityPlayer>>> playerList = new HashMap();
    private static HashMap<UUID, ArrayList<SyncTask<EntityLivingBase>>> entityList = new HashMap();
    private static final String DATA_TAG = "minerva:tasks";
    private static final Object playerLock = new Object();
    private static final Object entityLock = new Object();

    public static boolean executeOnPlayerAvailable(UUID playerUUID, SyncTask<EntityPlayer> action) {
        return SyncManager.executeOnPlayerAvailable(playerUUID, action, UUIDs.NULL_UUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean executeOnPlayerAvailable(UUID playerUUID, SyncTask<EntityPlayer> action, UUID referrer) {
        if (referrer == null) {
            return SyncManager.executeOnPlayerAvailable(playerUUID, action, UUIDs.NULL_UUID);
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            throw new IllegalStateException("Don't invoke CreatureSyncHelper from client");
        }
        if (UUIDs.isNull(playerUUID)) {
            throw new IllegalStateException("You can only queue valid player UUIDs");
        }
        EntityPlayer p = EntityHelper.getPlayer(playerUUID);
        if (p != null) {
            action.entityFound((EntityLivingBase)p);
            DimensionManager.getWorld((int)0).func_73046_m().func_152344_a(action);
            return true;
        }
        Object object = playerLock;
        synchronized (object) {
            ArrayList<Object> list;
            if (playerList.containsKey(playerUUID)) {
                list = playerList.get(playerUUID);
            } else {
                list = new ArrayList();
                playerList.put(playerUUID, list);
            }
            if (!UUIDs.isNull(referrer)) {
                list.removeIf(st -> st.getReferrer().equals(referrer) && st.getClass().equals(action.getClass()));
            }
            list.add(action);
            DimensionManager.getWorld((int)0).func_175693_T().func_75742_a(TaskData.class, DATA_TAG).func_76185_a();
        }
        return false;
    }

    public static boolean executeOnEntityAvailable(UUID uniqueID, SyncTask<EntityLivingBase> action) {
        return SyncManager.executeOnEntityAvailable(uniqueID, action, UUIDs.NULL_UUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean executeOnEntityAvailable(UUID uniqueID, SyncTask<EntityLivingBase> action, UUID referrer) {
        if (referrer == null) {
            return SyncManager.executeOnEntityAvailable(uniqueID, action, UUIDs.NULL_UUID);
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            throw new IllegalStateException("Don't invoke CreatureSyncHelper from client");
        }
        if (UUIDs.isNull(uniqueID)) {
            throw new IllegalStateException("You can only queue valid UUIDs");
        }
        EntityLivingBase ent = EntityHelper.getEntityAcrossDimensions(uniqueID);
        if (ent != null) {
            action.entityFound(ent);
            DimensionManager.getWorld((int)0).func_73046_m().func_152344_a(action);
            return true;
        }
        Object object = entityLock;
        synchronized (object) {
            ArrayList<Object> list;
            if (entityList.containsKey(uniqueID)) {
                list = entityList.get(uniqueID);
            } else {
                list = new ArrayList();
                entityList.put(uniqueID, list);
            }
            if (!UUIDs.isNull(referrer)) {
                list.removeIf(st -> st.getReferrer().equals(referrer) && st.getClass().equals(action.getClass()));
            }
            list.add(action);
            DimensionManager.getWorld((int)0).func_175693_T().func_75742_a(TaskData.class, DATA_TAG).func_76185_a();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanMessagesForEntity(UUID uniqueID) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            throw new IllegalStateException("Don't invoke CreatureSyncHelper from client");
        }
        EntityLivingBase ent = EntityHelper.getEntityAcrossDimensions(uniqueID);
        if (ent == null) {
            Object object = entityLock;
            synchronized (object) {
                if (entityList.containsKey(uniqueID)) {
                    entityList.get(uniqueID).clear();
                }
                DimensionManager.getWorld((int)0).func_175693_T().func_75742_a(TaskData.class, DATA_TAG).func_76185_a();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void entityJoin(EntityJoinWorldEvent evt) {
        if (evt.getWorld().field_72995_K) {
            return;
        }
        if (evt.getEntity() instanceof EntityPlayerMP) {
            UUID id = EntityPlayer.func_146094_a((GameProfile)((EntityPlayerMP)evt.getEntity()).func_146103_bH());
            ArrayList<SyncTask<EntityPlayer>> bufferList = new ArrayList<SyncTask<EntityPlayer>>();
            Object object = playerLock;
            synchronized (object) {
                if (playerList.containsKey(id)) {
                    ArrayList<SyncTask<EntityPlayer>> list = playerList.get(id);
                    bufferList.addAll(list);
                    list.clear();
                    playerList.remove(id);
                    DimensionManager.getWorld((int)0).func_175693_T().func_75742_a(TaskData.class, DATA_TAG).func_76185_a();
                }
            }
            bufferList.stream().forEach(task -> DimensionManager.getWorld((int)0).func_73046_m().func_152344_a(task.entityFound((EntityLivingBase)evt.getEntity())));
        } else if (evt.getEntity() instanceof EntityLivingBase) {
            UUID id = evt.getEntity().getPersistentID();
            ArrayList<SyncTask<EntityLivingBase>> bufferList = new ArrayList<SyncTask<EntityLivingBase>>();
            Object object = entityLock;
            synchronized (object) {
                if (entityList.containsKey(id)) {
                    ArrayList<SyncTask<EntityLivingBase>> list = entityList.get(id);
                    bufferList.addAll(list);
                    list.clear();
                    entityList.remove(id);
                    DimensionManager.getWorld((int)0).func_175693_T().func_75742_a(TaskData.class, DATA_TAG).func_76185_a();
                }
            }
            bufferList.stream().forEach(task -> DimensionManager.getWorld((int)0).func_73046_m().func_152344_a(task.entityFound((EntityLivingBase)evt.getEntity())));
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load evt) {
        if (evt.getWorld().field_72995_K || evt.getWorld().field_73011_w.getDimension() != 0) {
            return;
        }
        WorldSavedData data = evt.getWorld().func_175693_T().func_75742_a(TaskData.class, DATA_TAG);
        if (data == null) {
            data = new TaskData();
            evt.getWorld().func_175693_T().func_75745_a(DATA_TAG, data);
            data.func_76185_a();
        }
    }

    public static class TaskData
    extends WorldSavedData {
        public TaskData() {
            super(SyncManager.DATA_TAG);
        }

        public TaskData(String data) {
            super(data);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void func_76184_a(NBTTagCompound tag) {
            Object object = playerLock;
            synchronized (object) {
                playerList = new HashMap();
                TaskData.unpackPlayers(playerList, tag.func_150295_c("players", 10));
            }
            object = entityLock;
            synchronized (object) {
                entityList = new HashMap();
                TaskData.unpackEntities(entityList, tag.func_150295_c("entities", 10));
            }
        }

        private static void unpackEntities(HashMap<UUID, ArrayList<SyncTask<EntityLivingBase>>> entityListIn, NBTTagList tagList) {
            tagList.forEach(entTag -> {
                NBTTagCompound tag = (NBTTagCompound)entTag;
                UUID id = UUIDs.fromNBT(tag);
                NBTTagList tasks = tag.func_150295_c("tasks", 10);
                ArrayList nlist = new ArrayList();
                tasks.forEach(base -> {
                    NBTTagCompound nbt = (NBTTagCompound)base;
                    String className = nbt.func_74779_i("class");
                    try {
                        SyncTask task = (SyncTask)Class.forName(className).newInstance();
                        task.deserializeNBT((NBTBase)nbt);
                        nlist.add(task);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        e.printStackTrace();
                    }
                });
                entityListIn.put(id, nlist);
            });
        }

        private static void unpackPlayers(HashMap<UUID, ArrayList<SyncTask<EntityPlayer>>> playerListIn, NBTTagList tagList) {
            tagList.forEach(entTag -> {
                NBTTagCompound tag = (NBTTagCompound)entTag;
                UUID id = UUIDs.fromNBT(tag);
                NBTTagList tasks = tag.func_150295_c("tasks", 10);
                ArrayList nlist = new ArrayList();
                tasks.forEach(base -> {
                    NBTTagCompound nbt = (NBTTagCompound)base;
                    String className = nbt.func_74779_i("class");
                    try {
                        SyncTask task = (SyncTask)Class.forName(className).newInstance();
                        task.deserializeNBT((NBTBase)nbt);
                        nlist.add(task);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        e.printStackTrace();
                    }
                });
                playerListIn.put(id, nlist);
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NBTTagCompound func_189551_b(NBTTagCompound compound) {
            NBTTagList tasks;
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagList players = new NBTTagList();
            NBTTagList entities = new NBTTagList();
            tag.func_74782_a("players", (NBTBase)players);
            tag.func_74782_a("entities", (NBTBase)entities);
            Object object = playerLock;
            synchronized (object) {
                for (UUID id : playerList.keySet()) {
                    NBTTagCompound playerContainer = UUIDs.toNBT(id);
                    tasks = new NBTTagList();
                    ((ArrayList)playerList.get(id)).forEach(st -> tasks.func_74742_a((NBTBase)st.serializeNBT()));
                    playerContainer.func_74782_a("tasks", (NBTBase)tasks);
                    players.func_74742_a((NBTBase)playerContainer);
                }
            }
            object = entityLock;
            synchronized (object) {
                for (UUID id : entityList.keySet()) {
                    NBTTagCompound entityContainer = UUIDs.toNBT(id);
                    tasks = new NBTTagList();
                    ((ArrayList)entityList.get(id)).forEach(st -> tasks.func_74742_a((NBTBase)st.serializeNBT()));
                    entityContainer.func_74782_a("tasks", (NBTBase)tasks);
                    players.func_74742_a((NBTBase)entityContainer);
                }
            }
            return tag;
        }
    }
}

