/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.minerva.common.entity;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public final class RayTraceHelper {
    private RayTraceHelper() {
    }

    public static RayTraceResult rayTracePlayerSight(EntityPlayer source, double range, boolean includeEntities) {
        double d0 = source.field_70165_t;
        double d1 = source.field_70163_u + (double)source.eyeHeight;
        double d2 = source.field_70161_v;
        World world = source.field_70170_p;
        Vec3d vec3d = new Vec3d(d0, d1, d2);
        Vec3d lookVector = source.func_70040_Z().func_186678_a(range);
        Vec3d forward = vec3d.func_178787_e(lookVector);
        RayTraceResult raytraceresult = world.func_147447_a(vec3d, forward, false, true, false);
        if (includeEntities) {
            if (raytraceresult != null) {
                forward = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
            }
            Entity entity = null;
            List list = world.func_72839_b((Entity)source, source.func_174813_aQ().func_72321_a(lookVector.field_72450_a, lookVector.field_72448_b, lookVector.field_72449_c).func_186662_g(1.0));
            double d6 = 0.0;
            for (Entity ent : list) {
                double d7;
                AxisAlignedBB axisalignedbb;
                RayTraceResult raytraceresult1;
                if (!ent.func_70067_L() || ent.field_70145_X || (raytraceresult1 = (axisalignedbb = ent.func_174813_aQ().func_186662_g((double)0.3f)).func_72327_a(vec3d, forward)) == null || !((d7 = vec3d.func_72436_e(raytraceresult1.field_72307_f)) < d6) && d6 != 0.0) continue;
                entity = ent;
                d6 = d7;
            }
            if (entity != null) {
                raytraceresult = new RayTraceResult(entity);
            }
        }
        return raytraceresult;
    }

    public static RayTraceResult rayTraceResult(Entity source, Vec3d vec3, boolean includeEntities, boolean excludeSource) {
        double d0 = source.field_70165_t;
        double d1 = source.field_70163_u;
        double d2 = source.field_70161_v;
        World world = source.field_70170_p;
        Vec3d vec3d = new Vec3d(d0, d1, d2);
        Vec3d forward = vec3d.func_178787_e(vec3);
        RayTraceResult raytraceresult = world.func_147447_a(vec3d, forward, false, true, false);
        if (includeEntities) {
            if (raytraceresult != null) {
                forward = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
            }
            Entity entity = null;
            List list = world.func_72839_b(source, source.func_174813_aQ().func_72321_a(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c).func_186662_g(1.0));
            double d6 = 0.0;
            for (Entity ent : list) {
                double d7;
                AxisAlignedBB axisalignedbb;
                RayTraceResult raytraceresult1;
                if (!ent.func_70067_L() || !excludeSource && ent.func_70028_i(source) || ent.field_70145_X || (raytraceresult1 = (axisalignedbb = ent.func_174813_aQ().func_186662_g((double)0.3f)).func_72327_a(vec3d, forward)) == null || !((d7 = vec3d.func_72436_e(raytraceresult1.field_72307_f)) < d6) && d6 != 0.0) continue;
                entity = ent;
                d6 = d7;
            }
            if (entity != null) {
                raytraceresult = new RayTraceResult(entity);
            }
        }
        return raytraceresult;
    }

    public static Vec3d fromMotion(Entity entity) {
        return new Vec3d(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
    }

    public static Vec3d fromVecRange(Vec3d look, double range) {
        return new Vec3d(look.field_72450_a * range, look.field_72448_b * range, look.field_72449_c * range);
    }

    public static Vec3d fromLookVec(Entity entity, double range) {
        Vec3d look = entity.func_70040_Z();
        return new Vec3d(look.field_72450_a * range, (double)entity.func_70047_e() + look.field_72448_b * range, look.field_72449_c * range);
    }
}

