/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.minerva.common.entity;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import zabi.minecraft.minerva.common.entity.UUIDs;

public class EntityHelper {
    @Nullable
    public static EntityPlayer getPlayerAcrossDimensions(UUID uuid) {
        for (WorldServer ws : DimensionManager.getWorlds()) {
            EntityPlayer player = ws.func_152378_a(uuid);
            if (player == null) continue;
            return player;
        }
        return null;
    }

    @Nullable
    public static EntityPlayer getPlayerAcrossDimensions(String name) {
        for (WorldServer ws : DimensionManager.getWorlds()) {
            EntityPlayer player = ws.func_72924_a(name);
            if (player == null) continue;
            return player;
        }
        return null;
    }

    @Nullable
    public static EntityPlayer getPlayer(UUID uuid) {
        return DimensionManager.getWorld((int)0).func_73046_m().func_184103_al().func_177451_a(uuid);
    }

    @Nullable
    public static EntityPlayer getPlayer(String name) {
        return DimensionManager.getWorld((int)0).func_73046_m().func_184103_al().func_152612_a(name);
    }

    public static void giveItemToPlayer(EntityPlayer player, ItemStack stack) {
        if (!player.func_191521_c(stack) && !player.field_70170_p.field_72995_K) {
            player.func_71019_a(stack, true);
        }
    }

    @Nullable
    public static EntityLivingBase getEntityAcrossDimensions(UUID uniqueID) {
        if (UUIDs.isNull(uniqueID)) {
            return null;
        }
        for (WorldServer ws : DimensionManager.getWorlds()) {
            Entity e = ws.func_175733_a(uniqueID);
            if (e == null) continue;
            if (e instanceof EntityLivingBase) {
                return (EntityLivingBase)e;
            }
            throw new IllegalStateException("Entity with UUID " + uniqueID + " is not an EntityLivingBase");
        }
        return null;
    }
}

