/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.minerva.client.hud.internal;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import zabi.minecraft.minerva.client.hud.internal.ComponentWrapper;

public class DataStorage {
    private static final DataStorage INSTANCE = new DataStorage();
    private File storageFile;
    private NBTTagCompound data = new NBTTagCompound();

    private DataStorage() {
        this.storageFile = new File(new File(Minecraft.func_71410_x().field_71412_D, "hud"), "minervahud.dat");
        try {
            Files.createParentDirs((File)this.storageFile);
            if (this.storageFile.createNewFile()) {
                this.writeAsync();
            } else {
                this.read();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static DataStorage getInstance() {
        return INSTANCE;
    }

    public void updateData(ComponentWrapper component) {
        this.data.func_74782_a(component.getIdentifier().toString(), (NBTBase)component.getStatus().serialize());
        this.writeAsync();
    }

    public void restoreData(ComponentWrapper component) {
        String id = component.getIdentifier().toString();
        if (this.data.func_74764_b(id)) {
            component.getStatus().deserialize(this.data.func_74775_l(id));
        } else {
            System.err.format("Component not saved: %s\n", id);
        }
    }

    private void writeAsync() {
        new Thread(() -> this.write()).start();
    }

    private synchronized void write() {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.storageFile);
            CompressedStreamTools.func_74799_a((NBTTagCompound)this.data, (OutputStream)fos);
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private synchronized void read() {
        try {
            this.data = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(this.storageFile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

