/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.handlers;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pegbeard.dungeontactics.handlers.DTBlocks;
import pegbeard.dungeontactics.handlers.DTConfigHandler;
import pegbeard.dungeontactics.handlers.DTCreativeTab;
import pegbeard.dungeontactics.handlers.DTItems;
import pegbeard.dungeontactics.handlers.DTLogHelper;
import pegbeard.dungeontactics.handlers.Util.DTDummyRecipe;
import pegbeard.dungeontactics.reference.Reference;

@GameRegistry.ObjectHolder(value="dungeontactics")
public class DTRecipes {
    static boolean INCONVENIANT = DTConfigHandler.configuration.get("1-Feature", "Disable Conveniance Recipes", false).getBoolean(false);
    static boolean STEELRECIPES = DTConfigHandler.configuration.get("1-Feature", "Enable Steel", true).getBoolean(true);
    static boolean REPLACE_BREAD = DTConfigHandler.configuration.get("1-Feature", "Replace Bread Recipe", true).getBoolean(true);
    static boolean REPLACE_LIGHTER = DTConfigHandler.configuration.get("1-Feature", "Replace Flint and Steel Recipe", true).getBoolean(true);
    static int MODIFY_DURABILITY = DTConfigHandler.configuration.get("6-Material Modifiers", "Weapon/Tool Durability", 0).getInt(0);
    private static final Set<Item> TOOLS = Sets.newHashSet((Object[])new Item[]{Items.field_151039_o, Items.field_151053_p, Items.field_151038_n, Items.field_151017_I, DTItems.WOODEN_HAMMER, DTItems.WOODEN_BATTLEAXE, DTItems.WOODEN_GLAIVE, Items.field_151041_m, DTItems.WOODEN_CUTLASS, DTItems.WOODEN_KNIFE, DTItems.WOODEN_CESTUS, DTItems.WOODEN_SHIELD, Items.field_151050_s, Items.field_151049_t, Items.field_151051_r, Items.field_151018_J, DTItems.STONE_HAMMER, DTItems.STONE_BATTLEAXE, DTItems.STONE_GLAIVE, Items.field_151052_q, DTItems.STONE_CUTLASS, DTItems.STONE_KNIFE, DTItems.STONE_CESTUS, DTItems.STONE_SHIELD, Items.field_151035_b, Items.field_151036_c, Items.field_151037_a, Items.field_151019_K, DTItems.IRON_HAMMER, DTItems.IRON_BATTLEAXE, DTItems.IRON_GLAIVE, Items.field_151040_l, DTItems.IRON_CUTLASS, DTItems.IRON_KNIFE, DTItems.IRON_CESTUS, DTItems.IRON_SHIELD, DTItems.SILVER_PICK, DTItems.SILVER_AXE, DTItems.SILVER_SHOVEL, DTItems.SILVER_HOE, DTItems.SILVER_HAMMER, DTItems.SILVER_BATTLEAXE, DTItems.SILVER_GLAIVE, DTItems.SILVER_CUTLASS, DTItems.SILVER_KNIFE, DTItems.SILVER_CESTUS, DTItems.SILVER_SHIELD, Items.field_151005_D, Items.field_151006_E, Items.field_151011_C, Items.field_151013_M, DTItems.GOLDEN_HAMMER, DTItems.GOLDEN_BATTLEAXE, DTItems.GOLDEN_GLAIVE, Items.field_151010_B, DTItems.GOLDEN_CUTLASS, DTItems.GOLDEN_KNIFE, DTItems.GOLDEN_CESTUS, DTItems.GOLDEN_SHIELD, DTItems.STEEL_PICK, DTItems.STEEL_AXE, DTItems.STEEL_SHOVEL, DTItems.STEEL_HOE, DTItems.STEEL_HAMMER, DTItems.STEEL_BATTLEAXE, DTItems.STEEL_GLAIVE, DTItems.STEEL_CUTLASS, DTItems.STEEL_KNIFE, DTItems.STEEL_CESTUS, DTItems.STEEL_SHIELD, Items.field_151046_w, Items.field_151056_x, Items.field_151047_v, Items.field_151012_L, DTItems.DIAMOND_HAMMER, DTItems.DIAMOND_BATTLEAXE, DTItems.DIAMOND_GLAIVE, Items.field_151048_u, DTItems.DIAMOND_CUTLASS, DTItems.DIAMOND_KNIFE, DTItems.DIAMOND_CESTUS, DTItems.DIAMOND_SHIELD, DTItems.MITHRIL_PICK, DTItems.MITHRIL_AXE, DTItems.MITHRIL_SHOVEL, DTItems.MITHRIL_HOE, DTItems.MITHRIL_HAMMER, DTItems.MITHRIL_BATTLEAXE, DTItems.MITHRIL_GLAIVE, DTItems.MITHRIL_SWORD, DTItems.MITHRIL_CUTLASS, DTItems.MITHRIL_KNIFE, DTItems.MITHRIL_CESTUS, DTItems.MITHRIL_SHIELD});

    public static void Init() {
        DTRecipes.furnace();
    }

    public static void postInit() {
        if (MODIFY_DURABILITY != 0) {
            DTRecipes.changeVanillaToolMaterials();
        }
        DTRecipes.repair();
    }

    private static void changeVanillaToolMaterials() {
        for (Item item : TOOLS) {
            int durability = item.func_77612_l();
            int newDurability = 0;
            if (MODIFY_DURABILITY == 1) {
                newDurability = durability / 2;
            }
            if (MODIFY_DURABILITY == 2) {
                newDurability = durability * 2;
            }
            if (newDurability <= 0) continue;
            item.func_77656_e(newDurability);
        }
    }

    public static void furnace() {
        GameRegistry.addSmelting((ItemStack)new ItemStack((Block)Blocks.field_150399_cn, 1, 15), (ItemStack)new ItemStack(DTBlocks.DUNGEON_GLASS), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Item.func_150898_a((Block)Blocks.field_150354_m))));
        if (!INCONVENIANT) {
            GameRegistry.addSmelting((Item)Items.field_151083_be, (ItemStack)new ItemStack(Items.field_151116_aA), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151083_be)));
            GameRegistry.addSmelting((Item)Items.field_151077_bg, (ItemStack)new ItemStack(Items.field_151116_aA), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151077_bg)));
            GameRegistry.addSmelting((Item)Items.field_179566_aV, (ItemStack)new ItemStack(Items.field_151116_aA), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_179566_aV)));
            GameRegistry.addSmelting((Item)Items.field_179557_bn, (ItemStack)new ItemStack(Items.field_151116_aA), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_179557_bn)));
            GameRegistry.addSmelting((Item)Items.field_151157_am, (ItemStack)new ItemStack(Items.field_151116_aA), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151157_am)));
            GameRegistry.addSmelting((Item)Items.field_179559_bp, (ItemStack)new ItemStack(Items.field_151116_aA), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_179559_bp)));
        }
        GameRegistry.addSmelting((Item)DTItems.FLOUR, (ItemStack)new ItemStack(Items.field_151025_P), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_179566_aV)));
        GameRegistry.addSmelting((Item)Items.field_151025_P, (ItemStack)new ItemStack(DTItems.TOAST), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_179566_aV)));
        GameRegistry.addSmelting((Item)DTItems.BREADSLICE, (ItemStack)new ItemStack(DTItems.TOASTSLICE), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_179566_aV)));
        GameRegistry.addSmelting((Item)DTItems.FISH_SWIFT, (ItemStack)new ItemStack(DTItems.FISH_SWIFT_COOKED), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_179566_aV)));
        GameRegistry.addSmelting((Item)DTItems.FISH_FLYING, (ItemStack)new ItemStack(DTItems.FISH_FLYING_COOKED), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_179566_aV)));
        GameRegistry.addSmelting((Item)DTItems.FISH_LAVA, (ItemStack)new ItemStack(DTItems.FISH_LAVA_COOKED), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_179566_aV)));
        GameRegistry.addSmelting((Item)DTItems.FISH_MUSCLE, (ItemStack)new ItemStack(DTItems.FISH_MUSCLE_COOKED), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_179566_aV)));
        GameRegistry.addSmelting((Item)DTItems.FISH_LUNG, (ItemStack)new ItemStack(DTItems.FISH_LUNG_COOKED), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_179566_aV)));
        GameRegistry.addSmelting((Item)DTItems.FISH_OBSIDIAN, (ItemStack)new ItemStack(DTItems.FISH_OBSIDIAN_COOKED), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_179566_aV)));
        GameRegistry.addSmelting((Item)DTItems.FISH_TUNNEL, (ItemStack)new ItemStack(DTItems.FISH_TUNNEL_COOKED), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_179566_aV)));
        GameRegistry.addSmelting((Item)DTItems.IRONRING, (ItemStack)new ItemStack(Items.field_191525_da), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151040_l)));
        GameRegistry.addSmelting((Item)DTItems.GOLDENRING, (ItemStack)new ItemStack(Items.field_151074_bl), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151010_B)));
        GameRegistry.addSmelting((Item)DTItems.DIAMONDRING, (ItemStack)new ItemStack(Items.field_151074_bl), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151010_B)));
        GameRegistry.addSmelting((Item)DTItems.IRON_HAMMER, (ItemStack)new ItemStack(Items.field_191525_da), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151040_l)));
        GameRegistry.addSmelting((Item)DTItems.SILVER_HAMMER, (ItemStack)new ItemStack(DTItems.NUGGET_SILVER), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151010_B)));
        GameRegistry.addSmelting((Item)DTItems.GOLDEN_HAMMER, (ItemStack)new ItemStack(Items.field_151074_bl), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151010_B)));
        GameRegistry.addSmelting((Item)DTItems.STEEL_HAMMER, (ItemStack)new ItemStack(DTItems.INGOT_STEEL), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151040_l)));
        GameRegistry.addSmelting((Item)DTItems.MITHRIL_HAMMER, (ItemStack)new ItemStack(DTItems.INGOT_MITHRIL), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151010_B)));
        GameRegistry.addSmelting((Item)DTItems.IRON_BATTLEAXE, (ItemStack)new ItemStack(Items.field_191525_da), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151040_l)));
        GameRegistry.addSmelting((Item)DTItems.SILVER_BATTLEAXE, (ItemStack)new ItemStack(DTItems.NUGGET_SILVER), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151010_B)));
        GameRegistry.addSmelting((Item)DTItems.GOLDEN_BATTLEAXE, (ItemStack)new ItemStack(Items.field_151074_bl), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151010_B)));
        GameRegistry.addSmelting((Item)DTItems.STEEL_BATTLEAXE, (ItemStack)new ItemStack(DTItems.INGOT_STEEL), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151040_l)));
        GameRegistry.addSmelting((Item)DTItems.MITHRIL_BATTLEAXE, (ItemStack)new ItemStack(DTItems.INGOT_MITHRIL), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151010_B)));
        GameRegistry.addSmelting((Item)DTItems.IRON_GLAIVE, (ItemStack)new ItemStack(Items.field_191525_da), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151040_l)));
        GameRegistry.addSmelting((Item)DTItems.SILVER_GLAIVE, (ItemStack)new ItemStack(DTItems.NUGGET_SILVER), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151010_B)));
        GameRegistry.addSmelting((Item)DTItems.GOLDEN_GLAIVE, (ItemStack)new ItemStack(Items.field_151074_bl), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151010_B)));
        GameRegistry.addSmelting((Item)DTItems.MITHRIL_GLAIVE, (ItemStack)new ItemStack(DTItems.INGOT_MITHRIL), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151010_B)));
        GameRegistry.addSmelting((Item)DTItems.STEEL_GLAIVE, (ItemStack)new ItemStack(DTItems.INGOT_STEEL), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151040_l)));
        GameRegistry.addSmelting((Item)DTItems.SILVER_SWORD, (ItemStack)new ItemStack(DTItems.NUGGET_SILVER), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151010_B)));
        GameRegistry.addSmelting((Item)DTItems.STEEL_SWORD, (ItemStack)new ItemStack(DTItems.INGOT_STEEL), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151040_l)));
        GameRegistry.addSmelting((Item)DTItems.MITHRIL_SWORD, (ItemStack)new ItemStack(DTItems.INGOT_MITHRIL), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151010_B)));
        GameRegistry.addSmelting((Item)DTItems.IRON_CUTLASS, (ItemStack)new ItemStack(Items.field_191525_da), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151040_l)));
        GameRegistry.addSmelting((Item)DTItems.SILVER_CUTLASS, (ItemStack)new ItemStack(DTItems.NUGGET_SILVER), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151010_B)));
        GameRegistry.addSmelting((Item)DTItems.GOLDEN_CUTLASS, (ItemStack)new ItemStack(Items.field_151074_bl), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151010_B)));
        GameRegistry.addSmelting((Item)DTItems.STEEL_CUTLASS, (ItemStack)new ItemStack(DTItems.INGOT_STEEL), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151040_l)));
        GameRegistry.addSmelting((Item)DTItems.MITHRIL_CUTLASS, (ItemStack)new ItemStack(DTItems.INGOT_MITHRIL), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151010_B)));
        GameRegistry.addSmelting((Item)DTItems.IRON_KNIFE, (ItemStack)new ItemStack(Items.field_191525_da), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151040_l)));
        GameRegistry.addSmelting((Item)DTItems.SILVER_KNIFE, (ItemStack)new ItemStack(DTItems.NUGGET_SILVER), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151010_B)));
        GameRegistry.addSmelting((Item)DTItems.GOLDEN_KNIFE, (ItemStack)new ItemStack(Items.field_151074_bl), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151010_B)));
        GameRegistry.addSmelting((Item)DTItems.STEEL_KNIFE, (ItemStack)new ItemStack(DTItems.INGOT_STEEL), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151040_l)));
        GameRegistry.addSmelting((Item)DTItems.MITHRIL_KNIFE, (ItemStack)new ItemStack(DTItems.INGOT_MITHRIL), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151010_B)));
        GameRegistry.addSmelting((Item)DTItems.IRON_CESTUS, (ItemStack)new ItemStack(Items.field_191525_da), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151040_l)));
        GameRegistry.addSmelting((Item)DTItems.SILVER_CESTUS, (ItemStack)new ItemStack(DTItems.NUGGET_SILVER), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151010_B)));
        GameRegistry.addSmelting((Item)DTItems.GOLDEN_CESTUS, (ItemStack)new ItemStack(Items.field_151074_bl), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151010_B)));
        GameRegistry.addSmelting((Item)DTItems.STEEL_CESTUS, (ItemStack)new ItemStack(DTItems.INGOT_STEEL), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151040_l)));
        GameRegistry.addSmelting((Item)DTItems.MITHRIL_CESTUS, (ItemStack)new ItemStack(DTItems.INGOT_MITHRIL), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151010_B)));
        GameRegistry.addSmelting((Item)DTItems.IRON_SHIELD, (ItemStack)new ItemStack(Items.field_191525_da), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151040_l)));
        GameRegistry.addSmelting((Item)DTItems.SILVER_SHIELD, (ItemStack)new ItemStack(DTItems.NUGGET_SILVER), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151010_B)));
        GameRegistry.addSmelting((Item)DTItems.GOLDEN_SHIELD, (ItemStack)new ItemStack(Items.field_151074_bl), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151010_B)));
        GameRegistry.addSmelting((Item)DTItems.STEEL_SHIELD, (ItemStack)new ItemStack(DTItems.INGOT_STEEL), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151040_l)));
        GameRegistry.addSmelting((Item)DTItems.MITHRIL_SHIELD, (ItemStack)new ItemStack(DTItems.INGOT_MITHRIL), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151010_B)));
        GameRegistry.addSmelting((Item)DTItems.THROWINGKNIFE, (ItemStack)new ItemStack(Items.field_191525_da), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151040_l)));
        GameRegistry.addSmelting((Item)DTItems.SLOWNESSKNIFE, (ItemStack)new ItemStack(Items.field_191525_da), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151040_l)));
        GameRegistry.addSmelting((Item)DTItems.WEAKNESSKNIFE, (ItemStack)new ItemStack(Items.field_191525_da), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151040_l)));
        GameRegistry.addSmelting((Item)DTItems.POISONKNIFE, (ItemStack)new ItemStack(Items.field_191525_da), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151040_l)));
        GameRegistry.addSmelting((Item)DTItems.CAUSTICKNIFE, (ItemStack)new ItemStack(Items.field_191525_da), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151040_l)));
        if (STEELRECIPES) {
            GameRegistry.addSmelting((Item)Items.field_151042_j, (ItemStack)new ItemStack(DTItems.INGOT_STEEL), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151042_j)));
        }
        GameRegistry.addSmelting((Block)DTBlocks.ORE_SILVER, (ItemStack)new ItemStack(DTItems.INGOT_SILVER), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151043_k)));
        GameRegistry.addSmelting((Block)DTBlocks.ORE_MITHRIL, (ItemStack)new ItemStack(DTItems.INGOT_MITHRIL), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151043_k)));
        GameRegistry.addSmelting((Block)DTBlocks.NETHER_GOLD, (ItemStack)FurnaceRecipes.func_77602_a().func_151395_a(new ItemStack(Blocks.field_150352_o)), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151043_k)));
        GameRegistry.addSmelting((Block)DTBlocks.STONE_QUARTZ, (ItemStack)FurnaceRecipes.func_77602_a().func_151395_a(new ItemStack(Blocks.field_150449_bY)), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151128_bU)));
        GameRegistry.addSmelting((Block)DTBlocks.END_DIAMOND, (ItemStack)FurnaceRecipes.func_77602_a().func_151395_a(new ItemStack(Blocks.field_150482_ag)), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151045_i)));
        GameRegistry.addSmelting((Block)DTBlocks.END_LAPIS, (ItemStack)FurnaceRecipes.func_77602_a().func_151395_a(new ItemStack(Blocks.field_150369_x)), (float)FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(Items.field_151137_ax)));
        DTRecipes.clusterSmelting(DTItems.CLUSTER_IRON, "oreIron", "ingotIron", "Iron Override", Reference.IRONOVERRIDEDEFAULT);
        DTRecipes.clusterSmelting(DTItems.CLUSTER_GOLD, "oreGold", "ingotGold", "Gold Override", Reference.GOLDOVERRIDEDEFAULT);
        DTRecipes.clusterSmelting(DTItems.CLUSTER_SILVER, "oreSilver", "ingotSilver", "Silver Override", Reference.SILVEROVERRIDEDEFAULT);
        DTRecipes.clusterSmelting(DTItems.CLUSTER_MITHRIL, "oreMithril", "ingotMithril", "Mithril Override", Reference.MITHRILOVERRIDEDEFAULT);
        DTRecipes.clusterSmelting(DTItems.CLUSTER_TIN, "oreTin", "ingotTin", "Tin Override", Reference.TINOVERRIDEDEFAULT);
        DTRecipes.clusterSmelting(DTItems.CLUSTER_COPPER, "oreCopper", "ingotCopper", "Copper Override", Reference.COPPEROVERRIDEDEFAULT);
        DTRecipes.clusterSmelting(DTItems.CLUSTER_ALUMINIUM, "oreAluminium", "ingotAluminium", "Aluminium Override", Reference.NICKELOVERRIDEDEFAULT);
        DTRecipes.clusterSmelting(DTItems.CLUSTER_ALUMINIUM, "oreAluminum", "ingotAluminum", "Aluminium Override", Reference.NICKELOVERRIDEDEFAULT);
        DTRecipes.clusterSmelting(DTItems.CLUSTER_ALUMINIUM, "oreBauxite", "ingotAluminium", "Aluminium Override", Reference.NICKELOVERRIDEDEFAULT);
        DTRecipes.clusterSmelting(DTItems.CLUSTER_ALUMINIUM, "oreBauxite", "ingotAluminum", "Aluminium Override", Reference.NICKELOVERRIDEDEFAULT);
        DTRecipes.clusterSmelting(DTItems.CLUSTER_NICKEL, "oreNickel", "ingotNickel", "Nickel Override", Reference.NICKELOVERRIDEDEFAULT);
        DTRecipes.clusterSmelting(DTItems.CLUSTER_LEAD, "oreLead", "ingotLead", "Lead Override", Reference.LEADOVERRIDEDEFAULT);
        DTRecipes.clusterSmelting(DTItems.CLUSTER_PLATINUM, "oreSheldonite", "ingotPlatinum", "Platinum Override", Reference.PLATINUMOVERRIDEDEFAULT);
        DTRecipes.clusterSmelting(DTItems.CLUSTER_PLATINUM, "orePlatinum", "ingotPlatinum", "Platinum Override", Reference.PLATINUMOVERRIDEDEFAULT);
        DTRecipes.clusterSmelting(DTItems.CLUSTER_TUNGSTEN, "oreTungsten", "ingotTungsten", "Tungsten Override", Reference.TUNGSTENOVERRIDEDEFAULT);
        DTRecipes.clusterSmelting(DTItems.CLUSTER_TITANIUM, "oreTitanium", "ingotTitanium", "Titanium Override", Reference.TITANIUMOVERRIDEDEFAULT);
        DTRecipes.clusterSmelting(DTItems.CLUSTER_OSMIUM, "oreOsmium", "ingotOsmium", "Osmium Override", Reference.OSMIUMOVERRIDEDEFAULT);
    }

    public static void clusterSmelting(Item item, String oreBlock, String oreIngot, String name, String[] base) {
        boolean overrideConfig = DTConfigHandler.configuration.get("4-OreClusterOverrides", "Cluster Output Override", false).getBoolean(false);
        float xp = 0.0f;
        if (FurnaceRecipes.func_77602_a().func_151395_a(new ItemStack(item)).func_77973_b() == Items.field_190931_a) {
            ItemStack ingot;
            Property override = DTConfigHandler.configuration.get("4-OreClusterOverrides", name, base);
            ArrayList<String> configIngot = new ArrayList<String>(Arrays.asList(override.getStringList()));
            if (overrideConfig && !configIngot.isEmpty()) {
                ItemStack ingot2 = new ItemStack(Item.func_111206_d((String)((String)configIngot.get(0))));
                if (ingot2.func_77973_b() != null && ingot2.func_77973_b() != Items.field_190931_a) {
                    xp = FurnaceRecipes.func_77602_a().func_151398_b(ingot2);
                    GameRegistry.addSmelting((Item)item, (ItemStack)ingot2, (float)xp);
                }
            } else if (OreDictionary.doesOreNameExist((String)oreBlock) && OreDictionary.doesOreNameExist((String)oreIngot) && (ingot = DTRecipes.findResources(oreBlock)) != null && ingot.func_77973_b() != Items.field_190931_a) {
                xp = FurnaceRecipes.func_77602_a().func_151398_b(ingot);
                GameRegistry.addSmelting((Item)item, (ItemStack)ingot, (float)xp);
            }
            if (FurnaceRecipes.func_77602_a().func_151395_a(new ItemStack(item)).func_77973_b() != Items.field_190931_a) {
                item.func_77637_a(DTCreativeTab.DT_TAB);
            }
        }
    }

    public static void repair() {
    }

    public static void setRepairItem(Item.ToolMaterial mat, String ingot, Set<Item> set) {
        if (mat.getRepairItemStack().func_77973_b() == Items.field_190931_a && DTRecipes.doesOreExist(ingot)) {
            mat.setRepairItem(DTRecipes.findResources(ingot));
            if (set != null) {
                DTRecipes.addToCreativeTab(set);
            }
        }
    }

    public static ItemStack findResources(String resource) {
        if (OreDictionary.doesOreNameExist((String)resource)) {
            ItemStack ingot = null;
            NonNullList oreList = OreDictionary.getOres((String)resource);
            if (!oreList.isEmpty()) {
                if (((ItemStack)oreList.get(0)).func_77973_b() != null && ((ingot = FurnaceRecipes.func_77602_a().func_151395_a(new ItemStack(((ItemStack)oreList.get(0)).func_77973_b(), 1, ((ItemStack)oreList.get(0)).func_77960_j()))) == null || ingot.func_77973_b() == Items.field_190931_a)) {
                    ingot = (ItemStack)oreList.get(0);
                }
                if (ingot.func_77973_b() != null) {
                    return new ItemStack(ingot.func_77973_b(), 1, ingot.func_77960_j());
                }
            }
        }
        return null;
    }

    public static boolean doesOreExist(String resource) {
        return !OreDictionary.getOres((String)resource).isEmpty();
    }

    private static void addToCreativeTab(Set<Item> set) {
        for (Item item : set) {
            item.func_77637_a(DTCreativeTab.DT_WEAPONS_TAB);
        }
    }

    @Mod.EventBusSubscriber(modid="dungeontactics")
    public static class RegistrationHandler {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void removeRecipes(RegistryEvent.Register<IRecipe> event) {
            if (INCONVENIANT) {
                RegistrationHandler.removeRecipes(new ResourceLocation("dungeontactics:misc/convenience/books_from_shelves"));
                RegistrationHandler.removeRecipes(new ResourceLocation("dungeontactics:misc/convenience/clayball_from_clay"));
                RegistrationHandler.removeRecipes(new ResourceLocation("dungeontactics:misc/convenience/flint_from_gravel"));
                RegistrationHandler.removeRecipes(new ResourceLocation("dungeontactics:misc/convenience/melonslice_from_melon"));
                RegistrationHandler.removeRecipes(new ResourceLocation("dungeontactics:misc/convenience/planks_from_sticks"));
                RegistrationHandler.removeRecipes(new ResourceLocation("dungeontactics:misc/convenience/snowballs_from_snow"));
                RegistrationHandler.removeRecipes(new ResourceLocation("dungeontactics:misc/convenience/sticks_from_cactus"));
                RegistrationHandler.removeRecipes(new ResourceLocation("dungeontactics:misc/convenience/sticks_from_logs"));
                RegistrationHandler.removeRecipes(new ResourceLocation("dungeontactics:misc/convenience/sticks_from_saplings"));
                RegistrationHandler.removeRecipes(new ResourceLocation("dungeontactics:misc/convenience/string_from_wool"));
                RegistrationHandler.removeRecipes(new ResourceLocation("dungeontactics:misc/convenience/unpoison_potato"));
            }
            if (REPLACE_BREAD) {
                RegistrationHandler.removeRecipes(new ResourceLocation("minecraft:bread"));
            }
            if (!REPLACE_BREAD) {
                RegistrationHandler.removeRecipes(new ResourceLocation("dungeontactics:misc/flour"));
            }
            if (REPLACE_LIGHTER) {
                RegistrationHandler.removeRecipes(new ResourceLocation("minecraft:flint_and_steel"));
            }
            if (!REPLACE_LIGHTER) {
                RegistrationHandler.removeRecipes(new ResourceLocation("dungeontactics:tools/flint_and_steel"));
            }
        }

        public static void removeRecipes(ResourceLocation resource) {
            IForgeRegistry registry = ForgeRegistries.RECIPES;
            DTLogHelper.logInfo("Overriding recipes with dummy recipes, please ignore the following \"Dangerous alternative prefix\" warnings.", new Object[0]);
            IRecipe replacement = (IRecipe)new DTDummyRecipe().setRegistryName(resource);
            registry.register((IForgeRegistryEntry)replacement);
        }

        private static int removeRecipes(Predicate<IRecipe> predicate) {
            int recipesRemoved = 0;
            IForgeRegistry registry = ForgeRegistries.RECIPES;
            ArrayList<IRecipe> toRemove = new ArrayList<IRecipe>();
            for (IRecipe recipe2 : registry) {
                if (!predicate.test(recipe2)) continue;
                toRemove.add(recipe2);
                ++recipesRemoved;
            }
            DTLogHelper.logInfo("Overriding recipes with dummy recipes, please ignore the following \"Dangerous alternative prefix\" warnings.", new Object[0]);
            toRemove.forEach(recipe -> {
                ResourceLocation registryName = Objects.requireNonNull(recipe.getRegistryName());
                IRecipe replacement = (IRecipe)new DTDummyRecipe().setRegistryName(registryName);
                registry.register((IForgeRegistryEntry)replacement);
            });
            return recipesRemoved;
        }

        private static void removeRecipes(Block output) {
            RegistrationHandler.removeRecipes(Item.func_150898_a((Block)output));
        }

        private static void removeRecipes(Item output) {
            int recipesRemoved = RegistrationHandler.removeRecipes((IRecipe recipe) -> {
                ItemStack recipeOutput = recipe.func_77571_b();
                return !recipeOutput.func_190926_b() && recipeOutput.func_77973_b() == output;
            });
            DTLogHelper.logInfo("Removed {} recipe(s) for {}", recipesRemoved, output.getRegistryName());
        }

        private static void removeRecipes(Class<? extends IRecipe> recipeClass) {
            int recipesRemoved = RegistrationHandler.removeRecipes(recipeClass::isInstance);
            DTLogHelper.logInfo("Removed {} recipe(s) for {}", recipesRemoved, recipeClass);
        }
    }
}

