/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.entities.projectiles;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import pegbeard.dungeontactics.entities.projectiles.DTThrowableGeneric;
import pegbeard.dungeontactics.handlers.DTItems;

public class DTEntityThrowingKnife
extends DTThrowableGeneric {
    public boolean field_190534_ay = false;
    public int damage = 1;
    public int knockbackStrength = 0;
    protected ItemStack knifeType;

    public DTEntityThrowingKnife(World world) {
        super(world);
    }

    public DTEntityThrowingKnife(World world, EntityLivingBase entityLiving) {
        super(world, entityLiving);
    }

    public DTEntityThrowingKnife(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public void setKnifeType(Item knife) {
        this.knifeType = new ItemStack(knife);
    }

    public ItemStack getKnifeType() {
        return this.knifeType;
    }

    @Override
    protected void func_70184_a(RayTraceResult result) {
        World world = this.func_130014_f_();
        if (result != null && result.field_72308_g != null && !result.field_72308_g.field_70128_L) {
            float k;
            if (!world.field_72995_K) {
                Potion effect = this.getEffect(this.knifeType);
                float i0 = 0.0f;
                if (result.field_72308_g instanceof EntityLivingBase) {
                    i0 = (float)(1 + world.field_73012_v.nextInt(1)) + world.field_73012_v.nextFloat() + (float)(this.damage / 2);
                }
                result.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), i0);
                if (effect != null) {
                    ((EntityLivingBase)result.field_72308_g).func_70690_d(new PotionEffect(effect, 100, 1));
                }
                if (this.field_190534_ay) {
                    result.field_72308_g.func_70015_d((int)i0 - this.damage / 2);
                }
            }
            if (this.knockbackStrength > 0 && (k = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) > 0.0f) {
                result.field_72308_g.func_70024_g(this.field_70159_w * (double)this.knockbackStrength * (double)0.6f / (double)k, 0.1, this.field_70179_y * (double)this.knockbackStrength * (double)0.6f / (double)k);
            }
        }
        if (!world.field_72995_K) {
            this.func_70106_y();
            if (this.getKnifeType() != ItemStack.field_190927_a && this.getKnifeType().func_77973_b() != DTItems.THROWINGKNIFE && this.field_70146_Z.nextInt(3) == 0) {
                this.setKnifeType(DTItems.THROWINGKNIFE);
            }
            EntityItem drop = new EntityItem(world, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getKnifeType());
            if (this.field_70146_Z.nextInt(3) != 0) {
                world.func_72838_d((Entity)drop);
            } else {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187635_cQ, this.func_184176_by(), 0.8f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                for (int i = 0; i < 4; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.ITEM_CRACK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, new int[]{Item.func_150891_b((Item)this.getKnifeType().func_77973_b())});
                }
            }
        }
    }

    public Potion getEffect(ItemStack stack) {
        Item knife = stack.func_77973_b();
        if (knife == DTItems.SLOWNESSKNIFE) {
            return MobEffects.field_76421_d;
        }
        if (knife == DTItems.WEAKNESSKNIFE) {
            return MobEffects.field_76437_t;
        }
        if (knife == DTItems.POISONKNIFE) {
            return MobEffects.field_76436_u;
        }
        if (knife == DTItems.CAUSTICKNIFE) {
            return MobEffects.field_82731_v;
        }
        return null;
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74757_a("fire", this.field_190534_ay);
        tagCompound.func_74768_a("damage", this.damage);
        tagCompound.func_74768_a("knockbackStrength", this.knockbackStrength);
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.field_190534_ay = tagCompund.func_74767_n("fire");
        this.damage = tagCompund.func_74762_e("damage");
        this.knockbackStrength = tagCompund.func_74762_e("knockbackStrength");
    }
}

