/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.tonics;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jwaresoftware.mcmods.vfp.common.IMultiColored;
import org.jwaresoftware.mcmods.vfp.common.LiquidType;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpLiquidNonFood;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;

public final class TonicDrink
extends VfpLiquidNonFood
implements IMultiColored {
    public TonicDrink(VfpProfile oid) {
        super(oid, LiquidType.POTION);
        this.autoregister();
    }

    public TonicDrink() {
        this(VfpOid.TonicDrink);
    }

    @Override
    protected ItemStack getNewEmptyContainer() {
        return new ItemStack(VfpObj.Our_Empty_Bottle_obj);
    }

    @Override
    protected int getRegularItemUseDuration() {
        return MinecraftGlue.SHORT_FOOD_CONSUME_DURATION();
    }

    @Override
    protected void onDrinkDrunk(ItemStack original, ItemStack remaining, World world, EntityPlayer player) {
        MinecraftGlue.Potions.cureFireBurningEffects(player, true);
        super.onDrinkDrunk(original, remaining, world, player);
    }

    @Override
    protected void applyPotionEffectsOnDrunk(ItemStack original, ItemStack remaining, World world, EntityPlayer player) {
        super.applyPotionEffectsOnDrunk(original, remaining, world, player);
        MinecraftGlue.Potions.addPotionEffects((EntityLivingBase)player, original);
    }

    static final int getColorFromMoonshine(ItemStack moonshine, int tintIndex) {
        Integer custom_color;
        int color_num = -1;
        if (tintIndex <= 0 && (custom_color = MinecraftGlue.Potions.getColorOrNull(moonshine)) != null) {
            color_num = custom_color;
        }
        return color_num;
    }

    @Override
    public int getColorFrom(ItemStack tonic, int tintIndex) {
        return TonicDrink.getColorFromMoonshine(tonic, tintIndex);
    }

    public String func_77653_i(ItemStack tonic) {
        String registeredName = MinecraftGlue.Potions.getTypeDisplayNameOrNull(tonic);
        return registeredName != null ? registeredName : super.func_77653_i(tonic);
    }

    static final ItemStack initDefaultEffect(ItemStack moonshine) {
        return PotionUtils.func_185188_a((ItemStack)moonshine, (PotionType)MinecraftGlue.PotionType_harmless);
    }

    public void func_77622_d(ItemStack tonic, World world, EntityPlayer player) {
        if (!MinecraftGlue.Potions.isa(tonic, true)) {
            TonicDrink.initDefaultEffect(tonic);
        }
    }

    @Override
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab) && !this._hidden) {
            ItemStack tonic = new ItemStack((Item)this);
            TonicDrink.initDefaultEffect(tonic);
            list.add((Object)tonic);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack func_190903_i() {
        return TonicDrink.initDefaultEffect(super.func_190903_i());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack tonic, World world, List tooltip, ITooltipFlag flags) {
        MinecraftGlue.Potions.addPotionInformation(MinecraftGlue.Potions.getEffects(tonic, false), tooltip, true);
        super.func_77624_a(tonic, world, tooltip, flags);
    }

    static final boolean isa(ItemStack stack) {
        return stack.func_77973_b() == VfpObj.Tonic_Drink_obj;
    }

    @Nonnull
    public static final ItemStack create(@Nonnull ItemStack from_potion, int spread) {
        ItemStack tonic = new ItemStack((Item)VfpObj.Tonic_Drink_obj);
        MinecraftGlue.Potions.copyDefinition(from_potion, tonic);
        return tonic;
    }

    @Nonnull
    public static final ItemStack create(@Nonnull Collection<PotionEffect> effects, @Nullable Integer customColor, @Nullable String unlocalizedName) {
        ItemStack tonic = new ItemStack((Item)VfpObj.Tonic_Drink_obj);
        MinecraftGlue.Potions.copyDefinition(tonic, effects, customColor);
        if (unlocalizedName != null) {
            MinecraftGlue.ItemStacks_getTagCompoundNonNull(tonic).func_74778_a(MinecraftGlue.CUSTOM_POTION_UNLOCALIZED_TAGNAME(), unlocalizedName);
        }
        return tonic;
    }
}

