/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.meats;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.EntityHasProperty;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.RandomChanceWithLooting;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootingEnchantBonus;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.Smelt;
import net.minecraft.world.storage.loot.properties.EntityOnFire;
import net.minecraft.world.storage.loot.properties.EntityProperty;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.core.VfpBuildHelperSupport;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRuntime;
import org.jwaresoftware.mcmods.vfp.meats.AirSac;

public class HostileMobItems
extends VfpBuildHelperSupport {
    @Override
    protected String categoryName() {
        return "HostilesDrops";
    }

    @Override
    public void makeObjects(VfpRuntime runtime) {
        boolean brewingEnabled = runtime.getConfig().includePotionBrewing();
        VfpObj.Guardian_Fins_obj = VfpBuilder.newMisc(VfpOid.Guardian_Fins);
        VfpObj.Guardian_Raw_obj = VfpBuilder.newWolfFood(VfpOid.Guardian_Meat_Raw, LikeFood.uncooked_fish);
        VfpObj.Guardian_Cooked_obj = VfpBuilder.newWolfFood(VfpOid.Guardian_Meat, LikeFood.bear);
        VfpObj.Guardian_AirSac_obj = new AirSac(brewingEnabled);
    }

    @Override
    public void addDictionaryEntries(VfpRuntime runtime) {
        OreDictionary.registerOre((String)"ingredientKebabAdventure", (Item)VfpObj.Guardian_Raw_obj);
        OreDictionary.registerOre((String)"ingredientFishSausageMain", (Item)VfpObj.Guardian_Raw_obj);
        OreDictionary.registerOre((String)"ingredientChowderMain", (Item)VfpObj.Guardian_Cooked_obj);
        OreDictionary.registerOre((String)"foodProteinCooked", (Item)VfpObj.Guardian_Cooked_obj);
    }

    @Override
    public void addLootEntries(VfpRuntime runtime) {
        VfpConfig config = runtime.getConfig();
        if (!config.includeModDrops()) {
            return;
        }
        if (config.includeGuardianDrops()) {
            EntityProperty[] onfire = new EntityProperty[]{new EntityOnFire(true)};
            EntityProperty[] not_onfire = new EntityProperty[]{new EntityOnFire(false)};
            MinecraftGlue.Loot.addLootEntry("vanillafoodpantry", LootTableList.field_186440_v, null, (LootEntry)MinecraftGlue.Loot.createEntryItem(VfpOid.Guardian_Fins.fmlid(), VfpObj.Guardian_Fins_obj, 1, 2, 1, -1));
            MinecraftGlue.Loot.addLootEntry("vanillafoodpantry", LootTableList.field_186440_v, "hord_xlootpool1", (LootEntry)MinecraftGlue.Loot.createEntryItem(VfpOid.Guardian_Air_Sac.fmlid(), VfpObj.Guardian_AirSac_obj, 5, -1, new LootCondition[]{new RandomChanceWithLooting(0.1f, 0.1f), new EntityHasProperty(not_onfire, LootContext.EntityTarget.THIS)}, new LootFunction[]{new SetCount(MinecraftGlue.Loot._NOC, new RandomValueRange(0.0f, 1.0f)), new LootingEnchantBonus(MinecraftGlue.Loot._NOC, new RandomValueRange(0.0f, 1.0f), 2)}));
            if (!config.excludeGuardianMeatDrops()) {
                MinecraftGlue.Loot.addLootEntry("vanillafoodpantry", LootTableList.field_186440_v, "pool1", (LootEntry)MinecraftGlue.Loot.createEntryItem(VfpOid.Guardian_Meat_Raw.fmlid(), VfpObj.Guardian_Raw_obj, 2, -1, MinecraftGlue.Loot._NOC, new LootFunction[]{new SetCount(MinecraftGlue.Loot._NOC, new RandomValueRange(1.0f, 3.0f)), new LootingEnchantBonus(MinecraftGlue.Loot._NOC, new RandomValueRange(0.0f, 1.0f), 6)}));
                MinecraftGlue.Loot.addLootEntry("vanillafoodpantry", LootTableList.field_186440_v, "pool2", (LootEntry)MinecraftGlue.Loot.createEntryItem(VfpOid.Guardian_Meat.fmlid(), VfpObj.Guardian_Raw_obj, 2, -1, MinecraftGlue.Loot._NOC, new LootFunction[]{new SetCount(MinecraftGlue.Loot._NOC, new RandomValueRange(1.0f, 2.0f)), new LootingEnchantBonus(MinecraftGlue.Loot._NOC, new RandomValueRange(0.0f, 1.0f), 6), new Smelt(new LootCondition[]{new EntityHasProperty(onfire, LootContext.EntityTarget.THIS)})}));
            }
        }
    }

    @Override
    public void buildRecipes(VfpRuntime runtime, IForgeRegistry<IRecipe> recipes) {
        GameRegistry.addSmelting((Item)VfpObj.Guardian_Raw_obj, (ItemStack)new ItemStack(VfpObj.Guardian_Cooked_obj), (float)LikeFood.uncooked_fish.smeltExperience());
    }

    @Override
    public void linkRenderModels(VfpRuntime runtime) {
        if (runtime.hasUI()) {
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Guardian_Fins, VfpObj.Guardian_Fins_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Guardian_Meat_Raw, VfpObj.Guardian_Raw_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Guardian_Meat, VfpObj.Guardian_Cooked_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Guardian_Air_Sac, VfpObj.Guardian_AirSac_obj);
        }
    }
}

