/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.meats;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.core.VfpBuildHelperSupport;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRewards;
import org.jwaresoftware.mcmods.vfp.core.VfpRuntime;
import org.jwaresoftware.mcmods.vfp.meats.BatPoop;

public class BattyExtensions
extends VfpBuildHelperSupport {
    @Override
    protected String categoryName() {
        return "BatExtras";
    }

    @Override
    public void makeObjects(VfpRuntime runtime) {
        boolean brewingEnabled = runtime.getConfig().includePotionBrewing();
        VfpObj.Bat_Poop_obj = new BatPoop(brewingEnabled).autoregister();
        VfpObj.Bat_Raw_obj = VfpBuilder.newWolfFood(VfpOid.Bat_Raw, LikeFood.uncooked_bat);
        VfpObj.Bat_Cooked_obj = VfpBuilder.newFood(VfpOid.Bat_Cooked, LikeFood.bat);
        VfpObj.Bat_Sonar_Sac_obj = VfpBuilder.newBrewingItem(VfpOid.Bat_Sonar_Sac, brewingEnabled ? MinecraftGlue.BrewEffect.goldenCarrotEffectII : null, true);
        VfpObj.Bat_Burger_obj = VfpBuilder.newFood(VfpOid.Bat_Burger, new LikeFood(-1, LikeFood.bat, LikeFood.sandwich));
        VfpObj.Bat_CheeseBurger_obj = VfpBuilder.newFood(VfpOid.Bat_CheeseBurger, new LikeFood(-1, LikeFood.bat, LikeFood.sandwich, LikeFood.butter_dab));
        BatPoop.initDispenseBehavior(VfpObj.Bat_Poop_obj);
    }

    @Override
    public void linkLikeFoods(VfpRuntime runtime) {
        LikeFood.bat.food().item(VfpObj.Bat_Cooked_obj);
        LikeFood.uncooked_bat.food().item(VfpObj.Bat_Raw_obj);
    }

    @Override
    public void addDictionaryEntries(VfpRuntime runtime) {
        OreDictionary.registerOre((String)"ingredientKebabAdventure", (Item)VfpObj.Bat_Raw_obj);
        OreDictionary.registerOre((String)"foodSandwich", (Item)VfpObj.Bat_Burger_obj);
        OreDictionary.registerOre((String)"foodSandwich", (Item)VfpObj.Bat_CheeseBurger_obj);
        OreDictionary.registerOre((String)"foodBatCooked", (Item)VfpObj.Bat_Cooked_obj);
        OreDictionary.registerOre((String)"foodProteinCooked", (Item)VfpObj.Bat_Cooked_obj);
        OreDictionary.registerOre((String)"bonemeal", (Item)VfpObj.Bat_Poop_obj);
    }

    @Override
    public void addLootEntries(VfpRuntime runtime) {
        if (runtime.getConfig().includeModDrops() && runtime.getConfig().includeBatDrops()) {
            MinecraftGlue.Loot.addLootEntry("vanillafoodpantry", LootTableList.field_186424_f, "pool1", (LootEntry)MinecraftGlue.Loot.createEntryItem(VfpOid.Bat_Sonar_Sac.fmlid(), VfpObj.Bat_Sonar_Sac_obj, 5, -1));
        }
    }

    @Override
    public void buildRecipes(VfpRuntime runtime, IForgeRegistry<IRecipe> recipes) {
        GameRegistry.addSmelting((Item)VfpObj.Bat_Raw_obj, (ItemStack)new ItemStack(VfpObj.Bat_Cooked_obj), (float)LikeFood.uncooked_bat.smeltExperience());
        recipes.register(new ShapedOreRecipe(null, new ItemStack(MinecraftGlue.Items_rotten_flesh, 3), new Object[]{"mmm", "psb", Character.valueOf('m'), "foodRedMeat", Character.valueOf('p'), VfpObj.Bat_Poop_obj, Character.valueOf('s'), "portionSugarSmall", Character.valueOf('b'), "portionWaterLarge"}).setRegistryName(ModInfo.r("rotten_flesh_from_bat_poop")));
        recipes.register((IForgeRegistryEntry)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(null, new ItemStack(VfpObj.Bat_Burger_obj, VfpCapacity.SANDWICH_BATCH.count()), new Object[]{"mmm", " b ", Character.valueOf('m'), VfpObj.Bat_Cooked_obj, Character.valueOf('b'), "foodBreadSandwich"}).setRegistryName(ModInfo.r(VfpOid.Bat_Burger.fmlid() + "_batch")), LikeFood.sandwich.craftExperience()));
        recipes.register((IForgeRegistryEntry)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(null, new ItemStack(VfpObj.Bat_CheeseBurger_obj, VfpCapacity.SANDWICH_BATCH.count()), new Object[]{"mmm", "cb ", Character.valueOf('m'), VfpObj.Bat_Cooked_obj, Character.valueOf('c'), "foodCheese", Character.valueOf('b'), "foodBreadSandwich"}).setRegistryName(ModInfo.r(VfpOid.Bat_CheeseBurger.fmlid() + "_batch")), LikeFood.sandwich.craftExperience()));
        recipes.register(new ShapelessOreRecipe(null, VfpObj.Bat_Burger_obj, new Object[]{VfpObj.Bat_Cooked_obj, "portionBread"}).setRegistryName(ModInfo.r(VfpOid.Bat_Burger.fmlid())));
    }

    @Override
    public void linkRenderModels(VfpRuntime runtime) {
        if (runtime.hasUI()) {
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Bat_Poop, VfpObj.Bat_Poop_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Bat_Raw, VfpObj.Bat_Raw_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Bat_Cooked, VfpObj.Bat_Cooked_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Bat_Sonar_Sac, VfpObj.Bat_Sonar_Sac_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Bat_Burger, VfpObj.Bat_Burger_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Bat_CheeseBurger, VfpObj.Bat_CheeseBurger_obj);
        }
    }
}

