/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import org.jwaresoftware.mcmods.vfp.common.IReheatable;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.LiquidType;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.TANHelper;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpSimpleBowlFood;
import toughasnails.api.thirst.IDrink;

@Optional.Interface(iface="toughasnails.api.thirst.IDrink", modid="toughasnails")
public final class VfpStew
extends VfpSimpleBowlFood
implements IReheatable,
IDrink {
    protected VfpStew(VfpProfile oid, LikeFood like, boolean ingredient) {
        super(oid, like, ingredient);
        this.func_185043_a(new ResourceLocation("temperature"), new IReheatable.TemperaturePropertyGetter());
    }

    public float func_150906_h(ItemStack stew) {
        float modifier = super.func_150906_h(stew);
        return this.computeSaturationModifierForWarmedFood(stew, modifier, 2.0f, false);
    }

    @Optional.Method(modid="toughasnails")
    public final int getThirst() {
        return LiquidType.STEW.getThirst();
    }

    @Optional.Method(modid="toughasnails")
    public final float getHydration() {
        return LiquidType.STEW.getHydration();
    }

    @Optional.Method(modid="toughasnails")
    public final float getPoisonChance() {
        return 0.0f;
    }

    @Override
    @Optional.Method(modid="toughasnails")
    protected boolean canConsume(ItemStack stew, World world, EntityPlayer player) {
        IReheatable t_cap;
        boolean consume = super.canConsume(stew, world, player);
        if (!consume && MinecraftGlue.ModIntegration.TOUGH_AS_NAILS.isLoaded() && !(consume = TANHelper.isThirsty(world, player)) && (t_cap = this.getTemperatureChangeCapability(stew)) != null && t_cap.isHeated(stew)) {
            consume = TANHelper.isPlayerAtExtremeTemperature(player, false);
        }
        return consume;
    }

    @Override
    @Optional.Method(modid="toughasnails")
    protected void applyPotionEffectsOnConsumed(ItemStack original, ItemStack remaining, World world, EntityPlayer player) {
        super.applyPotionEffectsOnConsumed(original, remaining, world, player);
        if (MinecraftGlue.ModIntegration.TOUGH_AS_NAILS.isLoaded() && TANHelper.isEnabled()) {
            TANHelper.quenchThirst(player, this.getThirst(), this.getHydration(), 0.0f);
            IReheatable t_cap = this.getTemperatureChangeCapability(original);
            if (t_cap != null && t_cap.isHeated(original)) {
                TANHelper.warmIfCold(player, 3, this.getBonusTemperatureTimeLeftForApply(original, -1));
            }
        }
    }

    public void func_77663_a(ItemStack stew, World world, Entity holder, int slotindex, boolean selected) {
        this.onUpdateTickBonusTemperature(stew, world, holder, slotindex, selected);
    }

    public static final VfpStew newStew(VfpProfile oid, LikeFood like) {
        return new VfpStew(oid, like, false);
    }
}

