/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpSimpleBowlFood;

public final class VfpSpecialSalad
extends VfpSimpleBowlFood {
    private final boolean _longlastingFlag;

    protected VfpSpecialSalad(VfpProfile oid, LikeFood like, boolean longlasting) {
        super(oid, like, false);
        this._longlastingFlag = longlasting;
        this.func_77625_d(this.getItemMaxStackSize().count());
    }

    @Override
    protected VfpCapacity getItemMaxStackSize() {
        return this._longlastingFlag ? VfpCapacity.SMALL_STACK : VfpConfig.getInstance().maxSoupsStackCapacity(super.getItemMaxStackSize());
    }

    @Override
    protected int getPotionEffectDurationSecs(boolean good) {
        return this._longlastingFlag && good ? 180 : super.getPotionEffectDurationSecs(good);
    }

    protected void addLongSaturation(ItemStack dish, World world, EntityPlayer player) {
        int satLevel = 0;
        if (player.func_110143_aJ() < player.func_110138_aP()) {
            ++satLevel;
        }
        MinecraftGlue.Potions.addStubbornPotionEffect((EntityLivingBase)player, MinecraftGlue.Potion_saturation, this.getPotionEffectDurationSecs(true), satLevel, false, false);
    }

    @Override
    protected void applyPotionEffectsOnConsumed(ItemStack original, ItemStack remaining, World world, EntityPlayer player) {
        if (this._longlastingFlag) {
            this.addLongSaturation(original, world, player);
        }
        super.applyPotionEffectsOnConsumed(original, remaining, world, player);
    }

    public static final VfpSpecialSalad newSalad() {
        return new VfpSpecialSalad((VfpProfile)VfpOid.Special_Salad, LikeFood.special_salad, true);
    }
}

