/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpAware;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;

public class VfpPlainBlock
extends Block
implements VfpAware {
    protected final VfpProfile _oid;

    protected VfpPlainBlock(VfpProfile oid, Material likeMaterial, Block likeBlock) {
        super(likeMaterial == null ? likeBlock.func_149688_o(likeBlock.func_176223_P()) : likeMaterial);
        Validate.isTrue((boolean)oid.isBlock(), (String)"A VFP block's type MUST align as a Block", (Object[])new Object[0]);
        this._oid = oid;
        this.func_149663_c(oid.fmlid());
    }

    public VfpPlainBlock(VfpProfile oid, Material likeMaterial, Block likeBlock, CreativeTabs tab) {
        this(oid, likeMaterial, likeBlock);
        VfpUtils.copy(likeBlock, this, 1.0f);
        this.func_149672_a(likeBlock.func_185467_w());
        tab = VfpUtils.bestTab(tab, MinecraftGlue.CreativeTabs_block);
        this.func_149647_a(tab);
    }

    @Override
    public final VfpProfile vfplink() {
        return this._oid;
    }

    public VfpPlainBlock autoregister() {
        VfpUtils.autoregisterBlock(this, this._oid.fmlid(), false);
        return this;
    }

    public final <T extends VfpPlainBlock> T autoregister(Class<T> of) {
        return (T)((VfpPlainBlock)of.cast(this.autoregister()));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return this._oid.isRehydratable() ? BlockRenderLayer.TRANSLUCENT : super.func_180664_k();
    }

    public boolean func_149662_c(IBlockState state) {
        return this._oid == null || !this._oid.isRehydratable();
    }

    public Block func_149672_a(SoundType sound) {
        return super.func_149672_a(sound);
    }

    public String getUnlocalizedName(ItemStack stack) {
        return this.func_149739_a();
    }

    public static class VfpItemBlock
    extends ItemBlock
    implements VfpAware {
        public VfpItemBlock(Block block) {
            super(block);
            Validate.isInstanceOf(VfpPlainBlock.class, (Object)block);
        }

        protected final <T extends VfpPlainBlock> VfpPlainBlock getVfpBlock(Class<T> of) {
            return (VfpPlainBlock)of.cast(this.func_179223_d());
        }

        @Override
        public final VfpProfile vfplink() {
            return this.getVfpBlock(VfpPlainBlock.class).vfplink();
        }

        public int func_77647_b(int blockmeta) {
            return blockmeta;
        }

        public String func_77667_c(ItemStack stack) {
            return ((VfpPlainBlock)this.func_179223_d()).getUnlocalizedName(stack);
        }
    }
}

