/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.agents;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.material.MapColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.common.FoodColor;
import org.jwaresoftware.mcmods.vfp.common.Ingredient;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.OneXp;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpPotionTypes;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpTransientVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRewards;
import org.jwaresoftware.mcmods.vfp.core.VfpRuntime;

public final class FoodPowders
extends VfpPantryMultiItem
implements FoodColor {
    static final int MAX_POWDERS_PER_USAGE = 200;
    static final int NUM_RESERVED_SLOTS = 64;
    public static final int _NONE = 0;
    public static final int _DRINK = 1;
    public static final int _BREAD = 16;
    public static final int _COOKIE = 256;
    public static final int _SOUP = 4096;
    public static final int _COLOR = 65536;
    public static final int _SEASON = 0x100000;
    static VfpVariant[] VARIANT_ARRAY;
    private static final VfpVariantSet VARIANT_SET;
    private static FoodPowders INSTANCE;
    private static ItemStack[] TYPED_INSTANCES;
    private static boolean _HAVE_PICKLING;

    public static final int[] getReservedIngredientIdRange() {
        return new int[]{Usage.DRINK_FLAVOR.idFirst(), Usage.OTHER.idLast()};
    }

    public FoodPowders(VfpOid oid, CreativeTabs tab) {
        super((VfpProfile)oid, false, VARIANT_ARRAY, tab);
    }

    @Override
    public int color(ItemStack stack) {
        VfpVariant variant = VfpVariant.byItemStack(stack, this._variant_default);
        Integer color = variant.datadata(Type.class).colorValue();
        return color != null ? color : 0xF1F1F1;
    }

    @Override
    protected boolean showSubItem(VfpVariant variant, CreativeTabs forTab, CreativeTabs pickedTab) {
        boolean show;
        Type type = variant.datadata(Type.class);
        boolean bl = show = type != null && type != Type.FILLER;
        if (type == Type.PICKLING) {
            show = _HAVE_PICKLING;
        }
        return show;
    }

    static final synchronized FoodPowders makeObjects(VfpConfig config) {
        if (INSTANCE == null) {
            ArrayList<VfpTransientVariant> variants = new ArrayList<VfpTransientVariant>(199);
            String basename = VARIANT_SET.typeName();
            List<Type> typeDefs = Type.orderedValues();
            for (Type type : typeDefs) {
                String fmlid = basename + "_" + type.name().toLowerCase(Locale.US);
                variants.add(new VfpTransientVariant(type.meta(), fmlid, null, type, (CreativeTabs)null, VARIANT_SET));
            }
            VARIANT_ARRAY = variants.toArray(VfpVariant.EMPTY_ARRAY);
            INSTANCE = VfpBuilder.newMultiItem(VfpOid.FoodPowder, FoodPowders.class);
        }
        return INSTANCE;
    }

    static final void addDictionaryEntries() {
        if (INSTANCE != null) {
            List<Type> typeDefs = Type.orderedValues();
            ArrayList<ItemStack> instances = new ArrayList<ItemStack>(71);
            for (Type type : typeDefs) {
                ItemStack a_powder = new ItemStack((Item)INSTANCE, 1, type.meta());
                if (type.isColorer()) {
                    OreDictionary.registerOre((String)"powderFoodColor", (ItemStack)a_powder);
                }
                if (type.isDrinkFlavor()) {
                    OreDictionary.registerOre((String)"powderDrinkFlavor", (ItemStack)a_powder);
                }
                if (type.isSoupFlavor()) {
                    OreDictionary.registerOre((String)"powderSoupFlavor", (ItemStack)a_powder);
                }
                if (type.substitutionFor() != null) {
                    OreDictionary.registerOre((String)type.substitutionFor(), (ItemStack)a_powder);
                }
                instances.add(a_powder);
            }
            TYPED_INSTANCES = instances.toArray(new ItemStack[0]);
            OreDictionary.registerOre((String)"powderGelatin", (ItemStack)FoodPowders._copy(Type.GELATIN, 1));
            OreDictionary.registerOre((String)"powderMilk", (ItemStack)FoodPowders._copy(Type.MILK, 1));
            OreDictionary.registerOre((String)"powderCream", (ItemStack)FoodPowders._copy(Type.CREAM, 1));
            OreDictionary.registerOre((String)"powderCheese", (ItemStack)FoodPowders._copy(Type.CHEESE, 1));
            OreDictionary.registerOre((String)"powderMushroom", (ItemStack)FoodPowders._copy(Type.MUSHROOM, 1));
            OreDictionary.registerOre((String)"powderLemon", (ItemStack)FoodPowders._copy(Type.UGLI_FRUIT, 1));
            OreDictionary.registerOre((String)"ingredientLemonFlavor", (ItemStack)FoodPowders._copy(Type.UGLI_FRUIT, 1));
            OreDictionary.registerOre((String)"powderSunflowerSeeds", (ItemStack)FoodPowders._copy(Type.SUNFLOWER_SEEDS, 1));
            OreDictionary.registerOre((String)"powderSunflowerSeeds", (ItemStack)FoodPowders._copy(Type.SUNBUTTER_MIX, 1));
        }
    }

    private static final void autorecipeGelatinPowder(VfpConfig config, IForgeRegistry<IRecipe> recipes) {
        int meta = Type.GELATIN.meta();
        ItemStack gel_powder = new ItemStack((Item)INSTANCE, MinecraftGlue.ItemStacks_getSize(Type.GELATIN.item().recipeitem()), meta);
        VfpRewards.addRewardingCraftItem(gel_powder, LikeFood.bone.craftExperience());
        if (config.enableBoneSmelting()) {
            GameRegistry.addSmelting((Item)MinecraftGlue.Items_bone, (ItemStack)new ItemStack((Item)INSTANCE, MinecraftGlue.ItemStacks_getSize(gel_powder), meta), (float)LikeFood.bone.smeltExperience());
        }
    }

    private static final void autorecipeBuiltinMixes(VfpConfig config, IForgeRegistry<IRecipe> recipes) {
        ItemStack pepper = null;
        Type type = FoodPowders.findType("peppercorn");
        if (type != null) {
            pepper = FoodPowders.get(type, 1);
        }
        ArrayList<String> ingredients = new ArrayList<String>();
        ingredients.add("foodFlour");
        if (pepper != null) {
            ingredients.add((String)pepper);
        }
        ingredients.add("ingredientSalt");
        ingredients.add((String)VfpObj.Baking_Soda_obj);
        recipes.register(new ShapelessOreRecipe(ModInfo.r("foodpowders"), FoodPowders.get(Type.BATTER_MIX, 3), ingredients.toArray()).setRegistryName(ModInfo.r("foodpowder_batter_mix")));
        ingredients.clear();
        if (pepper != null) {
            ingredients.add((String)pepper);
        }
        ingredients.add("ingredientSalt");
        ingredients.add((String)MinecraftGlue.Items_sugar);
        recipes.register(new ShapelessOreRecipe(ModInfo.r("foodpowders"), FoodPowders.get(Type.JERKY_RUB, 6), ingredients.toArray()).setRegistryName(ModInfo.r("foodpowder_jerky_rub")));
        ingredients.clear();
        type = FoodPowders.findType("stew_mix");
        if (type != null && pepper != null && type.isSeasoningFlavor()) {
            String thyme = config.getPresentAs("thyme");
            ItemStack garlic = FoodPowders.get(FoodPowders.findType("garlic"), 1);
            ingredients.add("ingredientSalt");
            ingredients.add((String)pepper);
            ingredients.add((String)FoodPowders.get(Type.CARROT, 1));
            ingredients.add((String)FoodPowders.get(FoodPowders.findType("celery"), 1));
            ingredients.add((String)FoodPowders.get(FoodPowders.findType("onion"), 1));
            if (garlic != null) {
                ingredients.add((String)garlic);
            }
            if (thyme != null) {
                ingredients.add(thyme);
            }
            recipes.register(new ShapelessOreRecipe(ModInfo.r("foodpowders"), FoodPowders.get(type, 6), ingredients.toArray()).setRegistryName(ModInfo.r("foodpowder_stew_mix")));
        }
        ingredients.clear();
        type = FoodPowders.findType("citrus");
        if (type != null && OreDictionary.doesOreNameExist((String)"ingredientCitrusFill")) {
            ingredients.add("additiveDrying");
            String alt = config.getPresentAs("lime");
            ingredients.add(alt);
            ingredients.add(alt);
            ingredients.add("ingredientCitrusFill");
            recipes.register(new ShapelessOreRecipe(ModInfo.r("foodpowders"), FoodPowders.get(type, 6), ingredients.toArray()).setRegistryName(ModInfo.r("foodpowder_citrus")));
        }
        ingredients.clear();
        type = FoodPowders.findType("mocha");
        if (type != null && FoodPowders.findType("coffee") != null) {
            ingredients.add((String)FoodPowders.get(FoodPowders.findType("coffee"), 1));
            ingredients.add((String)new ItemStack((Item)INSTANCE, 1, Type.COCOA.meta()));
            ingredients.add((String)new ItemStack((Item)INSTANCE, 1, Type.MILK.meta()));
            recipes.register(new ShapelessOreRecipe(ModInfo.r("foodpowders"), FoodPowders.get(type, 6), ingredients.toArray()).setRegistryName(ModInfo.r("foodpowder_mocha")));
        }
    }

    private static final void autorecipeCompounds(VfpConfig config, IForgeRegistry<IRecipe> recipes) {
        recipes.register(new ShapelessOreRecipe(ModInfo.r("foodpowders"), new ItemStack((Item)INSTANCE, 1, Type.CREAM.meta()), new Object[]{new ItemStack((Item)INSTANCE, 1, Type.MILK.meta()), new ItemStack((Item)INSTANCE, 1, Type.MILK.meta())}).setRegistryName(ModInfo.r("foodpowder_cream")));
        recipes.register(new ShapedOreRecipe(null, new ItemStack((Item)INSTANCE, 1, Type.FEATHER.meta()), new Object[]{"fff", "fff", "vvd", Character.valueOf('f'), "feather", Character.valueOf('v'), MinecraftGlue.Blocks_vine, Character.valueOf('d'), "additiveDrying"}).setRegistryName(ModInfo.r("foodpowder_feather")));
        ItemStack muscle_powder = new ItemStack((Item)INSTANCE, 1, Type.MUSCLE.meta());
        recipes.register((IForgeRegistryEntry)VfpRewards.addRewardingCraftItem((IRecipe)new ShapelessOreRecipe(ModInfo.r("foodpowders"), muscle_powder, new Object[]{new ItemStack((Item)INSTANCE, 1, Type.CACTUS.meta()), new ItemStack((Item)INSTANCE, 1, Type.ROSE.meta()), "foodSimpleEgg", VfpObj.Ink_Sac_obj, "additiveDrying"}), OneXp.Per08.value()).setRegistryName(ModInfo.r("foodpowder_muscle_alt1")));
        recipes.register(new ShapelessOreRecipe(ModInfo.r("foodpowders"), muscle_powder, new Object[]{new ItemStack((Item)INSTANCE, 1, Type.CACTUS.meta()), new ItemStack((Item)INSTANCE, 1, Type.ROSE.meta()), new ItemStack((Item)INSTANCE, 1, Type.INK.meta()), new ItemStack((Item)INSTANCE, 1, Type.EGG.meta())}).setRegistryName(ModInfo.r("foodpowder_muscle")));
        VfpRewards.addRewardingCraftItem(new ItemStack((Item)INSTANCE, 3, Type.BUSHTEA.meta()), OneXp.Per03.value());
        VfpRewards.addRewardingCraftItem(new ItemStack((Item)INSTANCE, 3, Type.DANDTEA.meta()), OneXp.Per03.value());
        ItemStack allium = new ItemStack(MinecraftGlue.Blocks_red_flower, 1, BlockFlower.EnumFlowerType.ALLIUM.func_176968_b());
        recipes.register((IForgeRegistryEntry)VfpRewards.addRewardingCraftItem((IRecipe)new ShapelessOreRecipe(ModInfo.r("foodpowders"), new ItemStack((Item)INSTANCE, 2, Type.FLOWERPOWER.meta()), new Object[]{new ItemStack(MinecraftGlue.Blocks_double_plant, 1, BlockDoublePlant.EnumPlantType.PAEONIA.func_176936_a()), new ItemStack(MinecraftGlue.Blocks_double_plant, 1, BlockDoublePlant.EnumPlantType.SYRINGA.func_176936_a()), allium, allium, "foodFlower", "foodFlower", "additiveDrying"}).setRegistryName(ModInfo.r("foodpowder_flowerpower")), OneXp.Per03.value()));
        recipes.register(new ShapelessOreRecipe(ModInfo.r("foodpowders"), new ItemStack((Item)INSTANCE, 3, Type.UGLI_FRUIT.meta()), new Object[]{new ItemStack(VfpObj.Raftugli_Fruit_obj), "additiveDrying"}).setRegistryName(ModInfo.r("foodpowder_ugli")));
        GameRegistry.addSmelting((ItemStack)new ItemStack((Item)INSTANCE, 1, Type.SUNFLOWER_SEEDS.meta()), (ItemStack)new ItemStack((Item)INSTANCE, 1, Type.SUNBUTTER_MIX.meta()), (float)0.0f);
    }

    private static final void autorecipeBrewingReactants(VfpConfig config) {
        if (config.includePotionBrewing()) {
            MinecraftGlue.BrewEffect.addRecipeFor((Item)INSTANCE, Type.FLOWERPOWER.meta(), VfpPotionTypes.GENERIC_LUCK);
            MinecraftGlue.BrewEffect.addConversionFor(VfpPotionTypes.GENERIC_LUCK, (Item)INSTANCE, Type.FLOWERPOWER.meta(), VfpPotionTypes.SUPER_GOOD_JUJU);
            MinecraftGlue.BrewEffect.addConversionFor(VfpPotionTypes.GENERIC_LUCK, VfpObj.Fermented_Feather_obj, 0, VfpPotionTypes.BADD_JUJU);
            MinecraftGlue.BrewEffect.addConversionFor(VfpPotionTypes.GENERIC_LUCK, MinecraftGlue.Items_fermented_spider_eye, 0, VfpPotionTypes.BADD_JUJU);
        }
    }

    static final void buildRecipes(VfpRuntime runtime, IForgeRegistry<IRecipe> recipes) {
        VfpConfig config = runtime.getConfig();
        boolean debug = config.isDebugMode();
        for (int i = 0; i < VARIANT_ARRAY.length; ++i) {
            Object powder_source;
            Type type = VARIANT_ARRAY[i].datadata(Type.class);
            if (type.isCompound() || !type.item().isEnabled()) continue;
            ItemStack typedef = type.item().recipeitem();
            Object[] powder_ingredients = new Object[1 + type.item().multiplier()];
            powder_ingredients[0] = "additiveDrying";
            if (type.item().isClassifier()) {
                String ingredientname = type.item().recipeitemName();
                if (!VfpUtils.ingredientDefined(ingredientname)) {
                    if (!debug) continue;
                    runtime.getLog().warn("Skipping powder %s made of %s (not present in game)", (Object)type.name(), (Object)ingredientname);
                    continue;
                }
                powder_source = ingredientname;
            } else {
                powder_source = typedef.func_77946_l();
                MinecraftGlue.ItemStacks_setSize(powder_source, 1);
            }
            for (int j = 1; j < powder_ingredients.length; ++j) {
                powder_ingredients[j] = powder_source;
            }
            ItemStack powder_portions = new ItemStack((Item)INSTANCE, MinecraftGlue.ItemStacks_getSize(typedef), type.meta());
            recipes.register(new ShapelessOreRecipe(ModInfo.r("foodpowders"), powder_portions, powder_ingredients).setRegistryName(ModInfo.r("foodpowder_" + type.name().toLowerCase(Locale.US))));
        }
        FoodPowders.autorecipeGelatinPowder(config, recipes);
        FoodPowders.autorecipeCompounds(config, recipes);
        FoodPowders.autorecipeBuiltinMixes(config, recipes);
        FoodPowders.autorecipeBrewingReactants(config);
        _HAVE_PICKLING = VfpUtils.ingredientDefined("powderPickling");
    }

    static final VfpVariantSet variants() {
        return VARIANT_SET;
    }

    private static final ItemStack _copy(Type powder, int amount) {
        assert (TYPED_INSTANCES != null);
        ItemStack item = TYPED_INSTANCES[powder.ordinal()];
        item = new ItemStack(item.func_77973_b(), amount, item.func_77960_j());
        return item;
    }

    private static final MinecraftGlue.ItemStackDef _copydef(Type powder, int amount) {
        assert (INSTANCE != null);
        return new MinecraftGlue.ItemStackDef((Item)INSTANCE, amount, powder.meta());
    }

    @Nullable
    public static final Ingredient toIngredient(Type powder, int amount, Usage usage, String preferredName) {
        Ingredient ingredient = null;
        if (powder != null && VARIANT_SET.lookup(powder.meta()) != null) {
            if (usage == null) {
                usage = Usage.OTHER;
            }
            if (preferredName == null) {
                preferredName = powder.name_lowercased();
            }
            boolean metaCheck = powder.meta() >= 0 && powder.meta() < 200;
            Validate.validState((boolean)metaCheck, (String)"A food powder's meta value MUST be between 0 and %d exclusive", (Object[])new Object[]{200});
            ingredient = new Ingredient(preferredName, usage.idLast() - powder.meta(), FoodPowders._copydef(powder, amount));
        }
        return ingredient;
    }

    @Nullable
    public static final Ingredient toIngredient(Type powder, Usage usage, String preferredName) {
        return FoodPowders.toIngredient(powder, 1, usage, preferredName);
    }

    @Nullable
    public static final Ingredient toIngredient(@Nullable Type powder, int id, @Nullable String preferredName) {
        Ingredient ingredient = null;
        if (powder != null && VARIANT_SET.lookup(powder.meta()) != null) {
            if (preferredName == null) {
                preferredName = powder.name_lowercased();
            }
            ingredient = new Ingredient(preferredName, id, FoodPowders._copydef(powder, 1));
        }
        return ingredient;
    }

    @Nullable
    public static final ItemStack get(@Nullable Type powder, int amount) {
        ItemStack item = null;
        if (powder != null && VARIANT_SET.lookup(powder.meta()) != null) {
            item = FoodPowders._copy(powder, amount);
        }
        return item;
    }

    @Nullable
    public static final MinecraftGlue.ItemStackDef getDef(@Nullable Type powder, int amount) {
        MinecraftGlue.ItemStackDef defn = null;
        if (powder != null && VARIANT_SET.lookup(powder.meta()) != null) {
            defn = FoodPowders._copydef(powder, amount);
        }
        return defn;
    }

    @Nullable
    public static final Type findType(@Nonnull String name) {
        return Type._VALUES.get(name.toUpperCase());
    }

    static {
        VARIANT_SET = new VfpVariantSet.ByMapInstance((VfpProfile)VfpOid.FoodPowder, (Class)FoodPowders.class, "type"){

            @Override
            protected VfpVariant[] declaredVariants() {
                assert (VARIANT_ARRAY != null);
                return VARIANT_ARRAY;
            }
        };
        _HAVE_PICKLING = false;
    }

    public static final class Type
    implements Comparable<Type> {
        static int _NEXT_ORDINAL = 0;
        static final Map<String, Type> _VALUES = new HashMap<String, Type>(233);
        public static final Type SYRUP = new Type("SYRUP", new Ingredient("fpt_syrup", 0, new MinecraftGlue.ItemStackDef(VfpObj.Sugar_obj), 2), 1, null, false, (Integer)171775);
        public static final Type COCOA = new Type("COCOA", new Ingredient("fpt_cocoa", 0, new MinecraftGlue.ItemStackDef(MinecraftGlue.Items_dye, 1, EnumDyeColor.BROWN.func_176767_b()), 2), 65793, null, false, (Integer)8931339);
        public static final Type APPLE = new Type("APPLE", new Ingredient("fpt_apple", 0, "foodApple", 1, 2), 273, null, false, (Integer)16774112);
        public static final Type PUMPKIN = new Type("PUMPKIN", new MinecraftGlue.ItemStackDef(MinecraftGlue.Blocks_pumpkin, 4), 4368, 16768161);
        public static final Type MELON = new Type("MELON", new MinecraftGlue.ItemStackDef(MinecraftGlue.Blocks_melon_block, 4), 1, MinecraftGlue.MapColor_PINK);
        public static final Type CARROT = new Type("CARROT", new MinecraftGlue.ItemStackDef(MinecraftGlue.Items_carrot, 2), 69649, 16748827);
        public static final Type DANDELION = new Type("DANDELION", new MinecraftGlue.ItemStackDef(MinecraftGlue.Blocks_yellow_flower, 1, BlockFlower.EnumFlowerType.DANDELION.func_176968_b()), 65537, 16574754);
        public static final Type CACTUS = new Type("CACTUS", new MinecraftGlue.ItemStackDef(MinecraftGlue.Blocks_cactus, 4), 69889, MinecraftGlue.MapColor_LIME);
        public static final Type POPPY = new Type("POPPY", new MinecraftGlue.ItemStackDef(MinecraftGlue.Blocks_red_flower, 1, BlockFlower.EnumFlowerType.POPPY.func_176968_b()), 65537, 0xFF0000);
        public static final Type MILK = new Type("MILK", new Ingredient("fpt_milk", 0, "portionMilkLarge", 4, 1), 1, "ingredientMilk", true, (Integer)0xFFFFDD);
        public static final Type POTATO = new Type("POTATO", new MinecraftGlue.ItemStackDef(MinecraftGlue.Items_potato, 2), 4112, 16775636);
        public static final Type EGG = new Type("EGG", new Ingredient("fpt_egg", 0, "foodSimpleEgg"), 16, "ingredientEgg", false, (Integer)0xFFFF8C);
        public static final Type INK = new Type("INK", new MinecraftGlue.ItemStackDef(MinecraftGlue.Items_dye, 2, EnumDyeColor.BLACK.func_176767_b()), 65537, "ingredientInk", MinecraftGlue.MapColor_BLACK.field_76291_p);
        public static final Type MUSHROOM = new Type("MUSHROOM", new Ingredient("fpt_shroom", 0, "foodMushroom"), 4096, "ingredientMushroom", false, (Integer)11306333);
        public static final Type ROSE = new Type("ROSE", new Ingredient("fpt_rose", 0, "foodRoseFlower"), 65536, "ingredientRoseFlower", false, (Integer)MinecraftGlue.MapColor_RED.field_76291_p);
        public static final Type GELATIN = new Type("GELATIN", new MinecraftGlue.ItemStackDef(MinecraftGlue.Items_bone, 2), 0, true);
        public static final Type CHEESE = new Type("CHEESE", new Ingredient("fpt_cheez", 0, "foodCheese"), 4112, "ingredientCheese", false, (Integer)16772518);
        public static final Type FEATHER = new Type("FEATHER", new MinecraftGlue.ItemStackDef(MinecraftGlue.Items_feather), 0, true);
        public static final Type MUSCLE = new Type("MUSCLE", new Ingredient("fpt_muscle", 0, "unused"), 0, "powderBoost", true, (Integer)3419182);
        public static final Type BUSHTEA = new Type("BUSHTEA", new Ingredient("fpt_bushtea", 0, "unused"), 0, "ingredientBushTea", true, (Integer)6585650);
        public static final Type DANDTEA = new Type("DANDTEA", new Ingredient("fpt_dandtea", 0, "unused"), 0, "ingredientBushTea", true, (Integer)13873231);
        public static final Type CREAM = new Type("CREAM", new Ingredient("fpt_cream", 0, "unused"), 0, "ingredientCream", true, (Integer)15128708);
        public static final Type VINEGAR = new Type("VINEGAR", new Ingredient("fpt_vinegar", 0, "unused"), 0, "ingredientVinegar", true, null);
        public static final Type FILLER = new Type("CLEAR", new Ingredient("fpt_filler", 0, "unused"), 0, null, true, null);
        public static final Type BATTER_MIX = new Type("BATTER_MIX", new Ingredient("fpt_battermix", 0, "unused"), 0x100000, null, true, null);
        public static final Type JERKY_RUB = new Type("JERKY_MIX", new Ingredient("fpt_jerkymix", 0, "unused"), 0x100000, null, true, null);
        public static final Type POTATO_STARCH = new Type("POTATO_STARCH", new Ingredient("fpt_starch", 0, "unused"), 0, "ingredientStarch", true, null);
        public static final Type BEET = new Type("BEET", new Ingredient("fpt_beet", 0, "foodBeets", 1, 2), 69632, "ingredientBeet", false, (Integer)12612474);
        public static final Type PICKLING = new Type("PICKLING", new Ingredient("fpt_pickling", 0, "unused"), 0x100000, null, true, null);
        public static final Type CHORUSFRUIT = new Type("CHORUSFRUIT", new Ingredient("fpt_chorus", 0, new MinecraftGlue.ItemStackDef(MinecraftGlue.Items_chorus_fruit), 1), 65537, null, false, (Integer)7887224);
        public static final Type FLOWERPOWER = new Type("PINKFLOWERS", new Ingredient("fpt_flower", 0, "unused"), 65536, "additiveFlowerPower", true, (Integer)MinecraftGlue.MapColor_PINK.field_76291_p);
        public static final Type UGLI_FRUIT = new Type("UGLI", new Ingredient("fpt_ugli", 0, "unused"), 0, "ingredientCitrusFill", true, null);
        public static final Type SUNFLOWER_SEEDS = new Type("SUNFLOWER_SEEDS", new Ingredient("fpt_sunflower", 0, "unused"), 0, null, true, null);
        public static final Type SUNBUTTER_MIX = new Type("SUNBUTTER_MIX", new Ingredient("fpt_sunbuttmix", 0, "unused"), 0, null, true, null);
        private final String _name;
        private final int _ordinal;
        private final int _meta;
        private final Ingredient _item;
        private final int _uses;
        private final Integer _colorValue;
        private final String _substituteFor;
        private final boolean _compound;

        public static final Collection<Type> values() {
            return Collections.unmodifiableCollection(_VALUES.values());
        }

        Type(int id, String name, Ingredient item, int uses, String subsFor, boolean xrecipeFlag, Integer colorValue) {
            this._name = name = name.toUpperCase(Locale.US);
            this._ordinal = _NEXT_ORDINAL++;
            this._meta = id < 0 ? this._ordinal : id;
            this._item = item;
            this._uses = uses;
            this._substituteFor = subsFor;
            this._colorValue = colorValue;
            this._compound = xrecipeFlag;
            _VALUES.put(name, this);
        }

        Type(String name, Ingredient item, int uses, String subsFor, boolean xrecipeFlag, Integer colorValue) {
            this(-1, name, item, uses, subsFor, xrecipeFlag, colorValue);
        }

        Type(String name, MinecraftGlue.ItemStackDef item, int uses, String subsFor, Integer colorValue) {
            this(-1, name, new Ingredient("fpt_unused", 0, item), uses, subsFor, false, colorValue);
        }

        Type(String name, MinecraftGlue.ItemStackDef item, int uses, Integer colorValue) {
            this(-1, name, new Ingredient("fpt_unused", 0, item), uses, (String)null, false, colorValue);
        }

        Type(String name, MinecraftGlue.ItemStackDef item, int uses, MapColor color) {
            this(name, item, uses, null, color.field_76291_p);
        }

        Type(String name, MinecraftGlue.ItemStackDef item, int uses, String subsFor) {
            this(name, item, uses, subsFor, null);
        }

        Type(String name, MinecraftGlue.ItemStackDef item, int uses, boolean xrecipeFlag) {
            this(-1, name, new Ingredient("fpt_unused", 0, item), uses, (String)null, xrecipeFlag, (Integer)null);
        }

        public Type(int id, String name, MinecraftGlue.ItemStackDef item, int uses, String subsFor, Integer colorValue) {
            this(id, name, new Ingredient("fpt_unused", 0, item), uses, subsFor, false, colorValue);
        }

        public Type(int id, String name, MinecraftGlue.ItemStackDef item, int uses, int multiplier, String subsFor, Integer colorValue) {
            this(id, name, new Ingredient("fpt_unused", 0, item, multiplier), uses, subsFor, false, colorValue);
        }

        public Type(int id, String name, MinecraftGlue.ItemStackDef item, int uses, String subsFor, boolean xrecipeFlag) {
            this(id, name, new Ingredient("fpt_unused", 0, item), uses, subsFor, xrecipeFlag, null);
        }

        public Type(int id, String name, MinecraftGlue.ItemStackDef item, int uses, String subsFor, Integer colorValue, boolean xrecipeFlag) {
            this(id, name, new Ingredient("fpt_unused", 0, item), uses, subsFor, xrecipeFlag, colorValue);
        }

        public final String name() {
            return this._name;
        }

        public final String name_lowercased() {
            return this.name().toLowerCase(Locale.US);
        }

        public final int ordinal() {
            return this._ordinal;
        }

        public final int meta() {
            return this._meta;
        }

        Ingredient item() {
            return this._item;
        }

        public boolean isBreadFlavor() {
            return (this._uses & 0x10) == 16;
        }

        public boolean isDrinkFlavor() {
            return (this._uses & 1) == 1;
        }

        public boolean isSoupFlavor() {
            return (this._uses & 0x1000) == 4096;
        }

        public boolean isCookieFlavor() {
            return (this._uses & 0x100) == 256;
        }

        public boolean isSeasoningFlavor() {
            return (this._uses & 0x100000) == 0x100000;
        }

        public boolean isColorer() {
            return this._colorValue != null && (this._uses & 0x10000) == 65536;
        }

        public Integer colorValue() {
            return this._colorValue;
        }

        public String substitutionFor() {
            return this._substituteFor;
        }

        public boolean isCompound() {
            return this._compound;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(50);
            sb.append(this.name()).append("|").append(this.meta()).append("|").append(this._uses).append("|").append(this.colorValue()).append("|").append(this.substitutionFor());
            return sb.toString();
        }

        public boolean equals(Object o) {
            return o == null ? false : (o instanceof Type ? ((Type)o)._meta == this._meta : false);
        }

        public int hashCode() {
            return this._meta + this._name.hashCode();
        }

        @Override
        public int compareTo(Type o) {
            if (o == null) {
                return 1;
            }
            if (o == this) {
                return 0;
            }
            return this._ordinal > o._ordinal ? 1 : (this._ordinal < o._ordinal ? -1 : 0);
        }

        public static final List<Type> orderedValues() {
            ArrayList<Type> list = new ArrayList<Type>(_VALUES.values());
            Collections.sort(list);
            return list;
        }

        static final void checkReservedPowderCount() {
            Validate.validState((_NEXT_ORDINAL < 64 ? 1 : 0) != 0, (String)"At most %d builtin food powders are expected (now at %d)", (Object[])new Object[]{64, _NEXT_ORDINAL});
        }

        public static int reservedPowderCount() {
            return 64;
        }
    }

    public static enum Usage {
        DRINK_FLAVOR(400),
        BREAD_FLAVOR(DRINK_FLAVOR.idLast() + 200),
        COOKIE_FLAVOR(BREAD_FLAVOR.idLast() + 200),
        SOUP_FLAVOR(COOKIE_FLAVOR.idLast() + 200),
        COLORING(SOUP_FLAVOR.idLast() + 200),
        SEASONING_FLAVOR(COLORING.idLast() + 200),
        OTHER(SEASONING_FLAVOR.idLast() + 200);

        private final int _offset;

        private Usage(int offset) {
            this._offset = offset;
        }

        public int idLast() {
            return this._offset;
        }

        public int idFirst() {
            return this._offset - 200 + 1;
        }
    }
}

