package atomicstryker.infernalmobs.common.mods;

import atomicstryker.infernalmobs.common.MobModifier;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.math.MathHelper;

public class MM_Alchemist extends MobModifier
{

    public MM_Alchemist()
    {
        super();
    }

    public MM_Alchemist(MobModifier next)
    {
        super(next);
    }

    private long nextAbilityUse = 0L;
    private final static long coolDown = 6000L;
    private final static float MIN_DISTANCE = 2F;

    @Override
    public String getModName()
    {
        return "Alchemist";
    }

    @Override
    public boolean onUpdate(EntityLivingBase mob)
    {
        if (hasSteadyTarget()) {
            long time = System.currentTimeMillis();
            if (time > nextAbilityUse)
            {
                nextAbilityUse = time + coolDown;
                tryAbility(mob, mob.field_70170_p.func_72890_a(mob, 12f));
            }
        }
        return super.onUpdate(mob);
    }

    private void tryAbility(EntityLivingBase mob, EntityLivingBase target)
    {
        if (target == null || !mob.func_70685_l(target))
        {
            return;
        }

        if (mob.func_70068_e(target) > MIN_DISTANCE)
        {
            double diffX = target.field_70165_t + target.field_70159_w - mob.field_70165_t;
            double diffY = target.field_70163_u + (double) target.func_70047_e() - 1.100000023841858D - mob.field_70163_u;
            double diffZ = target.field_70161_v + target.field_70179_y - mob.field_70161_v;
            float distance = MathHelper.func_76133_a(diffX * diffX + diffZ * diffZ);

            PotionType potiontype = PotionTypes.field_185252_x;

            if (distance >= 8.0F && !target.func_70644_a(MobEffects.field_76421_d))
            {
                potiontype = PotionTypes.field_185246_r;
            }
            else if (target.func_110143_aJ() >= 8.0F && !target.func_70644_a(MobEffects.field_76436_u))
            {
                potiontype = PotionTypes.field_185254_z;
            }
            else if (distance <= 3.0F && !target.func_70644_a(MobEffects.field_76437_t) && mob.func_70681_au().nextFloat() < 0.25F)
            {
                potiontype = PotionTypes.field_185226_I;
            }

            EntityPotion potion = new EntityPotion(mob.field_70170_p, mob, PotionUtils.func_185188_a(new ItemStack(Items.field_185155_bH), potiontype));
            potion.field_70125_A -= -20.0F;
            potion.func_70186_c(diffX, diffY + (double) (distance * 0.2F), diffZ, 0.75F, 8.0F);
            mob.field_70170_p.func_72838_d(potion);
        }
    }

    @Override
    protected String[] getModNameSuffix()
    {
        return suffix;
    }

    private static String[] suffix = { "theWitchkin", "theBrewmaster", "theSinged" };

    @Override
    protected String[] getModNamePrefix()
    {
        return prefix;
    }

    private static String[] prefix = { "witchkin", "brewing", "singed" };

}
