package atomicstryker.infernalmobs.common.mods;

import atomicstryker.infernalmobs.common.InfernalMobsCore;
import atomicstryker.infernalmobs.common.MobModifier;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;

public class MM_1UP extends MobModifier
{
    private boolean healed;
    
    public MM_1UP()
    {
        super();
    }
    
    public MM_1UP(MobModifier next)
    {
        super(next);
    }
    
    @Override
    public String getModName()
    {
        return "1UP";
    }

    @Override
    public boolean onUpdate(EntityLivingBase mob)
    {
        if (!healed && mob.func_110143_aJ() < (getActualMaxHealth(mob)*0.25))
        {
            InfernalMobsCore.instance().setEntityHealthPastMax(mob, getActualMaxHealth(mob));
            mob.field_70170_p.func_184133_a(null, new BlockPos(mob), SoundEvents.field_187802_ec, SoundCategory.HOSTILE, 1.0F + mob.func_70681_au().nextFloat(), mob.func_70681_au().nextFloat() * 0.7F + 0.3F);
            healed = true;
        }
        return super.onUpdate(mob);
    }
    
    @Override
    public Class<?>[] getBlackListMobClasses()
    {
        return disallowed;
    }
    private static Class<?>[] disallowed = { EntityCreeper.class };
    
    @Override
    protected String[] getModNameSuffix()
    {
        return suffix;
    }
    private static String[] suffix = { "ofRecurrence", "theUndying", "oftwinLives" };
    
    @Override
    protected String[] getModNamePrefix()
    {
        return prefix;
    }
    private static String[] prefix = { "recurring", "undying", "twinlived" };
}
