/*
 * Decompiled with CFR 0.152.
 */
package openmods.world;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class DropCapture {
    public static final DropCapture instance = new DropCapture();
    private final List<CaptureContext> captures = Lists.newArrayList();

    public CaptureContext start(AxisAlignedBB aabb) {
        CaptureContext context = new CaptureContext(aabb);
        this.captures.add(context);
        return context;
    }

    public CaptureContext start(int x, int y, int z) {
        return this.start(new AxisAlignedBB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)));
    }

    public CaptureContext start(BlockPos pos) {
        return this.start(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @SubscribeEvent
    public void onEntityConstruct(EntityJoinWorldEvent evt) {
        block1: {
            Entity e = evt.getEntity();
            if (e == null || e.getClass() != EntityItem.class || e.field_70170_p.field_72995_K) break block1;
            EntityItem ei = (EntityItem)e;
            for (CaptureContext c : this.captures) {
                if (c.check(ei)) break;
            }
        }
    }

    public class CaptureContext {
        private final AxisAlignedBB aabb;
        private final List<EntityItem> drops = Lists.newArrayList();

        public CaptureContext(AxisAlignedBB aabb) {
            this.aabb = aabb;
        }

        private boolean check(EntityItem item) {
            if (!item.field_70128_L && this.aabb.func_72326_a(item.func_174813_aQ())) {
                this.drops.add(item);
                return true;
            }
            return false;
        }

        public List<EntityItem> stop() {
            DropCapture.this.captures.remove(this);
            return this.drops;
        }
    }
}

