/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.command;

import codechicken.lib.reflect.ObfMapping;
import com.brandon3055.brandonscore.handlers.BCEventHandler;
import com.brandon3055.brandonscore.handlers.HandHelper;
import com.brandon3055.brandonscore.inventory.ContainerPlayerAccess;
import com.brandon3055.brandonscore.lib.ChatHelper;
import com.brandon3055.brandonscore.lib.PairKV;
import com.brandon3055.brandonscore.network.PacketDispatcher;
import com.brandon3055.brandonscore.utils.DataUtils;
import com.brandon3055.brandonscore.utils.InventoryUtils;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChunkData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.commons.io.IOUtils;

public class BCUtilCommands
extends CommandBase {
    private static Random rand = new Random();

    public String func_71517_b() {
        return "bcore_util";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/bcore_util help";
    }

    public int func_82362_a() {
        return 3;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            this.help(sender);
            return;
        }
        try {
            String function = args[0];
            if (function.toLowerCase().equals("nbt")) {
                this.functionNBT(server, sender, args);
            } else if (function.equals("regenchunk")) {
                this.regenChunk(server, sender, args);
            } else if (function.equals("noclip")) {
                this.toggleNoClip(server, sender, args);
            } else if (function.equals("uuid")) {
                this.getUUID(server, sender, args);
            } else if (function.equals("player_access")) {
                this.playerAccess(server, sender, args);
            } else if (function.equals("dump_event_listeners")) {
                BCUtilCommands.dumpEventListeners(sender);
            } else if (!function.equals("light") || ObfMapping.obfuscated) {
                if (function.equals("eggify")) {
                    this.eggify(server, sender, args);
                } else {
                    this.help(sender);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new CommandException(e.getMessage(), new Object[0]);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 2 && args[0].equals("player_access")) {
            PlayerProfileCache cache = server.func_152358_ax();
            ArrayList<String> list = new ArrayList<String>();
            list.add("list");
            list.addAll(Lists.newArrayList((Object[])cache.func_152654_a()));
            return BCUtilCommands.func_175762_a((String[])args, list);
        }
        return BCUtilCommands.func_71530_a((String[])args, (String[])new String[]{"nbt", "regenchunk", "noclip", "uuid", "player_access", "dump_event_listeners", "eggify"});
    }

    private void help(ICommandSender sender) {
        ChatHelper.message(sender, "The following are a list of Brandon's Core Utility Commands", new Style().func_150238_a(TextFormatting.AQUA).func_150228_d(Boolean.valueOf(true)));
        ChatHelper.message(sender, "/bcore_util nbt", TextFormatting.BLUE);
        ChatHelper.message(sender, "-Prints the NBT tag of the stack you are holding to chat and to the console.", TextFormatting.GRAY);
        ChatHelper.message(sender, "/bcore_util regenchunk [radius]", TextFormatting.BLUE);
        ChatHelper.message(sender, "-Regenerates the chunk(s) at your position.", TextFormatting.GRAY);
        ChatHelper.message(sender, "/bcore_util noclip", TextFormatting.BLUE);
        ChatHelper.message(sender, "-Toggles noclip allowing you to fly through blocks as if in spectator mode... Or fall into the void if you dont have flight", TextFormatting.GRAY);
    }

    private void functionNBT(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        EntityPlayerMP player = BCUtilCommands.func_71521_c((ICommandSender)sender);
        ItemStack stack = HandHelper.getMainFirst((EntityPlayer)player);
        if (stack.func_190926_b()) {
            throw new CommandException("You are not holding an item!", new Object[0]);
        }
        if (!stack.func_77942_o()) {
            throw new CommandException("That stack has no NBT tag!", new Object[0]);
        }
        NBTTagCompound compound = stack.func_77978_p();
        LogHelperBC.logNBT(compound);
        StringBuilder builder = new StringBuilder();
        LogHelperBC.buildNBT(builder, (NBTBase)compound, "", "Tag", false);
        String[] lines = builder.toString().split("\n");
        DataUtils.forEach(lines, s -> ChatHelper.message(sender, s, TextFormatting.GOLD));
    }

    private void regenChunk(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        int rad = 0;
        if (args.length > 1) {
            rad = BCUtilCommands.func_175755_a((String)args[1]);
        }
        LogHelperBC.dev(rad);
        for (int xOffset = -rad; xOffset <= rad; ++xOffset) {
            for (int yOffset = -rad; yOffset <= rad; ++yOffset) {
                WorldServer world = (WorldServer)sender.func_130014_f_();
                EntityPlayerMP player = BCUtilCommands.func_71521_c((ICommandSender)sender);
                int chunkX = player.field_70176_ah + xOffset;
                int chunkZ = player.field_70164_aj + yOffset;
                Chunk oldChunk = world.func_72964_e(chunkX, chunkZ);
                ChunkProviderServer chunkProviderServer = world.func_72863_F();
                IChunkGenerator chunkGenerate = chunkProviderServer.field_186029_c;
                Chunk newChunk = chunkGenerate.func_185932_a(chunkX, chunkZ);
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        for (int y = 0; y < world.func_72800_K(); ++y) {
                            BlockPos chunkPos = new BlockPos(x, y, z);
                            BlockPos absPos = new BlockPos(x + chunkX * 16, y, z + chunkZ * 16);
                            IBlockState newState = newChunk.func_177435_g(chunkPos);
                            world.func_175656_a(absPos, newState);
                            TileEntity tileEntity = newChunk.func_177424_a(chunkPos, Chunk.EnumCreateEntityType.IMMEDIATE);
                            if (tileEntity == null) continue;
                            world.func_175690_a(absPos, tileEntity);
                        }
                    }
                }
                oldChunk.func_177446_d(false);
                oldChunk.func_186030_a((IChunkProvider)chunkProviderServer, chunkGenerate);
                PlayerChunkMap playerChunkMap = world.func_184164_w();
                if (playerChunkMap == null) {
                    return;
                }
                oldChunk.func_177427_f(true);
                oldChunk.func_76603_b();
                PlayerChunkMapEntry watcher = playerChunkMap.func_187301_b(oldChunk.field_76635_g, oldChunk.field_76647_h);
                if (watcher == null) continue;
                watcher.func_187267_a((Packet)new SPacketChunkData(oldChunk, 65535));
            }
        }
    }

    private void toggleNoClip(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String name = sender.func_70005_c_();
        EntityPlayerMP player = BCUtilCommands.func_71521_c((ICommandSender)sender);
        boolean enabled = BCEventHandler.noClipPlayers.contains(name);
        if (enabled) {
            BCEventHandler.noClipPlayers.remove(name);
            PacketDispatcher.sendNoClip(player, false);
            sender.func_145747_a((ITextComponent)new TextComponentString("NoClip Disabled!"));
        } else {
            BCEventHandler.noClipPlayers.add(name);
            PacketDispatcher.sendNoClip(player, true);
            sender.func_145747_a((ITextComponent)new TextComponentString("NoClip Enabled!"));
        }
    }

    private void getUUID(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        EntityPlayerMP player = BCUtilCommands.func_71521_c((ICommandSender)sender);
        if (args.length == 2) {
            player = BCUtilCommands.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[1]);
        }
        TextComponentString comp = new TextComponentString(player.func_70005_c_() + "'s UUID: " + TextFormatting.UNDERLINE + player.func_110124_au());
        Style style = new Style();
        style.func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, player.func_110124_au().toString()));
        style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Click to get text")));
        comp.func_150255_a(style);
        sender.func_145747_a((ITextComponent)comp);
    }

    public static void dumpEventListeners(ICommandSender sender) throws CommandException {
        HashMap eventListenerMap = new HashMap();
        BCUtilCommands.dumpBus("EVENT_BUS", MinecraftForge.EVENT_BUS, eventListenerMap);
        BCUtilCommands.dumpBus("ORE_GEN_BUS", MinecraftForge.ORE_GEN_BUS, eventListenerMap);
        BCUtilCommands.dumpBus("TERRAIN_GEN_BUS", MinecraftForge.TERRAIN_GEN_BUS, eventListenerMap);
        StringBuilder builder = new StringBuilder("\n");
        for (String bus : eventListenerMap.keySet()) {
            builder.append("Dumping listeners for bus: ").append(bus).append("\n");
            Map busListeners = (Map)eventListenerMap.get(bus);
            ArrayList sortedClasses = Lists.newArrayList(busListeners.keySet());
            sortedClasses.sort(Comparator.comparing(Class::getName));
            for (Class eventClass : sortedClasses) {
                List listenerList = (List)busListeners.get(eventClass);
                listenerList.sort(Comparator.comparingInt(value -> ((EventPriority)value.getKey()).ordinal()));
                builder.append("    Handlers for event: ").append(eventClass).append("\n");
                for (PairKV listener : listenerList) {
                    Method m = (Method)listener.getValue();
                    builder.append("        ").append(listener.getKey()).append(" ").append(m.getDeclaringClass().getName()).append(" ").append(m.getName()).append("(").append(BCUtilCommands.separateWithCommas(m.getParameterTypes())).append(")\n");
                }
                builder.append("\n");
            }
        }
        LogHelperBC.info(builder.toString());
        for (String s : builder.toString().split("\n")) {
            sender.func_145747_a((ITextComponent)new TextComponentString(s));
        }
    }

    private static String separateWithCommas(Class<?>[] types) {
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < types.length; ++j) {
            sb.append(types[j].getTypeName());
            if (j >= types.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    private static void dumpBus(String name, EventBus bus, Map<String, Map<Class<?>, List<PairKV<EventPriority, Method>>>> baseMap) throws CommandException {
        Map map = baseMap.computeIfAbsent(name, eventBus -> new HashMap());
        try {
            ConcurrentHashMap listeners = (ConcurrentHashMap)ReflectionHelper.getPrivateValue(EventBus.class, (Object)bus, (String[])new String[]{"listeners"});
            for (Object obj : listeners.keySet()) {
                for (Method method : obj.getClass().getMethods()) {
                    SubscribeEvent anno = method.getAnnotation(SubscribeEvent.class);
                    if (anno == null) continue;
                    for (Class<?> parameter : method.getParameterTypes()) {
                        if (!Event.class.isAssignableFrom(parameter)) continue;
                        map.computeIfAbsent(parameter, aClass -> new ArrayList()).add(new PairKV<EventPriority, Method>(anno.priority(), method));
                    }
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new CommandException(e.getMessage(), new Object[0]);
        }
    }

    private void eggify(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        EntityPlayerMP player = BCUtilCommands.func_71521_c((ICommandSender)sender);
        Entity entity = this.traceEntity((EntityPlayer)player);
        if (entity == null) {
            player.func_145747_a((ITextComponent)new TextComponentString("You must be looking at an entity!"));
            return;
        }
        ItemStack spawnEgg = new ItemStack(Items.field_151063_bx);
        NBTTagCompound data = entity.func_189511_e(new NBTTagCompound());
        data.func_74778_a("id", String.valueOf(EntityList.func_191301_a((Entity)entity)));
        spawnEgg.func_77983_a("EntityTag", (NBTBase)data);
        data.func_82580_o("Pos");
        data.func_82580_o("Motion");
        data.func_82580_o("Rotation");
        data.func_82580_o("FallDistance");
        data.func_82580_o("Fire");
        data.func_82580_o("Air");
        data.func_82580_o("OnGround");
        data.func_82580_o("Dimension");
        data.func_82580_o("Invulnerable");
        data.func_82580_o("PortalCooldown");
        data.func_82580_o("UUID");
        InventoryUtils.givePlayerStack((EntityPlayer)player, spawnEgg);
    }

    @Nullable
    protected Entity traceEntity(EntityPlayer player) {
        Entity entity = null;
        List list = player.field_70170_p.func_72839_b((Entity)player, player.func_174813_aQ().func_186662_g(20.0));
        double d0 = 0.0;
        Vec3d start = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        Vec3d look = player.func_70040_Z();
        Vec3d end = new Vec3d(player.field_70165_t + look.field_72450_a * 20.0, player.field_70163_u + (double)player.func_70047_e() + look.field_72448_b * 20.0, player.field_70161_v + look.field_72449_c * 20.0);
        for (int i = 0; i < list.size(); ++i) {
            double d1;
            Entity entity1 = (Entity)list.get(i);
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g(0.2);
            RayTraceResult raytraceresult = axisalignedbb.func_72327_a(start, end);
            if (raytraceresult == null || !((d1 = start.func_72436_e(raytraceresult.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity;
    }

    private void playerAccess(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 2) {
            throw new CommandException("Please specify a player or use the list option to view all known players.", new Object[0]);
        }
        String target = args[1];
        PlayerProfileCache cache = server.func_152358_ax();
        File playersFolder = new File(server.func_130014_f_().func_72860_G().func_75765_b(), "playerdata");
        File[] playerArray = playersFolder.listFiles((dir, name) -> name.endsWith(".dat"));
        if (playerArray == null) {
            throw new PlayerNotFoundException("There are no players in the playerdata folder");
        }
        HashMap<String, File> playerFiles = new HashMap<String, File>();
        for (File file : playerArray) {
            playerFiles.put(file.getName().replace(".dat", ""), file);
        }
        HashMap<UUID, GameProfile> playerMap = new HashMap<UUID, GameProfile>();
        for (String stringId : playerFiles.keySet()) {
            try {
                UUID uuid = UUID.fromString(stringId);
                GameProfile profile = cache.func_152652_a(uuid);
                playerMap.put(uuid, profile);
            }
            catch (Throwable e) {
                sender.func_145747_a(new TextComponentString("Detected possible non-playerdata file in playerdata folder: " + playerFiles.get(stringId) + ". Skipping").func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
        }
        if (target.equals("list")) {
            sender.func_145747_a((ITextComponent)new TextComponentString("################## All Known Players ##################"));
            for (UUID uuid : playerMap.keySet()) {
                GameProfile profile = (GameProfile)playerMap.get(uuid);
                boolean online = false;
                for (EntityPlayer player : server.func_184103_al().func_181057_v()) {
                    if (!player.func_146103_bH().getId().equals(uuid)) continue;
                    online = true;
                    break;
                }
                TextComponentString message = new TextComponentString((online ? TextFormatting.GREEN + "[Online]: " : TextFormatting.GRAY + "[Offline]: ") + profile.getName());
                boolean offline = UUID.nameUUIDFromBytes(("OfflinePlayer:" + profile.getName()).getBytes(Charsets.UTF_8)).equals(uuid);
                if (offline) {
                    message.func_150257_a(new TextComponentString(" (Offline Account)").func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                }
                ITextComponent messageHover = new TextComponentString("Last Seen: \n").func_150257_a((ITextComponent)new TextComponentString(TextFormatting.GRAY + "UUID: " + uuid + "\n")).func_150257_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "-Click to access player."));
                Style msgStyle = new Style();
                msgStyle.func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/bcore_util player_access " + uuid));
                msgStyle.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, messageHover));
                message.func_150255_a(msgStyle);
                sender.func_145747_a((ITextComponent)message);
            }
            return;
        }
        GameProfile profile = null;
        if (cache.field_152661_c.containsKey(target)) {
            profile = cache.func_152655_a(target);
            target = profile.getId().toString();
        } else {
            try {
                profile = cache.func_152652_a(UUID.fromString(target));
            }
            catch (IllegalArgumentException uuid) {
                // empty catch block
            }
            if (profile == null) {
                throw new CommandException("Could not find the specified player name or uuid!", new Object[0]);
            }
        }
        EntityPlayerMP playerSender = BCUtilCommands.func_71521_c((ICommandSender)sender);
        Object targetPlayer = server.func_184103_al().func_177451_a(profile.getId());
        if (targetPlayer == null) {
            File playerFile = BCUtilCommands.getPlayerFile(server, target);
            targetPlayer = new OfflinePlayer((EntityPlayer)playerSender, (World)server.func_71218_a(0), profile, playerFile);
        }
        if (playerSender == targetPlayer) {
            throw new CommandException("This command only works on other players!", new Object[0]);
        }
        BCUtilCommands.openPlayerAccessUI(server, playerSender, (EntityPlayer)targetPlayer);
    }

    public static File getPlayerFile(MinecraftServer server, String uuid) throws CommandException {
        File playerFolder = new File(server.func_130014_f_().func_72860_G().func_75765_b(), "playerdata");
        File[] playerArray = playerFolder.listFiles();
        if (playerArray == null) {
            throw new PlayerNotFoundException("There are no players in the playerdata folder");
        }
        for (File file : playerArray) {
            if (!file.getName().replace(".dat", "").equals(uuid)) continue;
            return file;
        }
        throw new PlayerNotFoundException("Could not find a data file for the specified player!");
    }

    public static NBTTagCompound readPlayerCompound(File playerData) throws CommandException {
        NBTTagCompound nBTTagCompound;
        DataInputStream is = null;
        try {
            is = new DataInputStream(new GZIPInputStream(new FileInputStream(playerData)));
            NBTTagCompound compound = CompressedStreamTools.func_74794_a((DataInputStream)is);
            IOUtils.closeQuietly((InputStream)is);
            nBTTagCompound = compound;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new CommandException(e.toString(), new Object[0]);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return nBTTagCompound;
    }

    public static void writePlayerCompound(File playerFile, NBTTagCompound playerCompound) throws IOException {
        DataOutputStream os = null;
        try {
            os = new DataOutputStream(new GZIPOutputStream(new FileOutputStream(playerFile)));
            CompressedStreamTools.func_74800_a((NBTTagCompound)playerCompound, (DataOutput)os);
            IOUtils.closeQuietly((OutputStream)os);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)os);
    }

    public static void openPlayerAccessUI(MinecraftServer server, EntityPlayerMP player, EntityPlayer playerAccess) {
        player.func_71117_bO();
        player.func_71128_l();
        int windowId = player.field_71139_cq;
        PacketDispatcher.sendOpenPlayerAccessUI(player, windowId);
        PacketDispatcher.sendPlayerAccessUIUpdate(player, playerAccess);
        player.field_71070_bA = new ContainerPlayerAccess((EntityPlayer)player, playerAccess, server);
        player.field_71070_bA.field_75152_c = windowId;
        player.field_71070_bA.func_75132_a((IContainerListener)player);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((EntityPlayer)player, player.field_71070_bA));
    }

    public static class OfflinePlayer
    extends EntityPlayer {
        private final EntityPlayer accessedBy;
        private final File playerFile;
        private NBTTagCompound playerCompound;

        public OfflinePlayer(EntityPlayer accessedBy, World worldIn, GameProfile gameProfileIn, File playerFile) throws CommandException {
            super(worldIn, gameProfileIn);
            this.accessedBy = accessedBy;
            this.playerFile = playerFile;
            this.field_71071_by = new InventoryPlayer(this){

                public void func_70296_d() {
                    this.saveOfflinePlayer();
                }

                public void func_174888_l() {
                    super.func_174888_l();
                    this.saveOfflinePlayer();
                }
            };
            this.playerCompound = BCUtilCommands.readPlayerCompound(playerFile);
            this.func_70020_e(this.playerCompound);
        }

        public void tpTo(EntityPlayer player) {
            this.field_70165_t = player.field_70165_t;
            this.field_70163_u = player.field_70163_u;
            this.field_70161_v = player.field_70161_v;
            this.field_71093_bK = player.field_71093_bK;
            this.saveOfflinePlayer();
        }

        public boolean func_175149_v() {
            return false;
        }

        public boolean func_184812_l_() {
            return false;
        }

        public void saveOfflinePlayer() {
            this.func_189511_e(this.playerCompound);
            try {
                BCUtilCommands.writePlayerCompound(this.playerFile, this.playerCompound);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.accessedBy.func_145747_a((ITextComponent)new TextComponentString("An error occurred while saving the player's inventory!\n" + e.toString() + "\nFull error is in server console."));
            }
        }
    }
}

