/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.builders;

import com.brandon3055.brandonscore.client.BCClientEventHandler;
import com.brandon3055.brandonscore.client.BCTextures;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.BCFontRenderer;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.GuiMarkdownElement;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.IPartBuilder;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.MouseIntractable;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.Part;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.PartContainer;
import com.brandon3055.brandonscore.lib.StackReference;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class PartBuilderStack
extends IPartBuilder {
    private static Pattern stackPat = Pattern.compile("(?<=[^\\\\]|^)(\u00a7stack\\[[^\u00a7]*]\\{[^\u00a7]*})|(?<=[^\\\\]|^)(\u00a7stack\\[[^\u00a7 ]*])");
    private static Pattern stackString = Pattern.compile("(?<=\u00a7stack\\[)(.*)(?=][{])|(?<=\u00a7stack\\[)(.*)(?=])");
    private static Pattern stackOPS = Pattern.compile("(?<=]\\{)(.*)(?=})");

    @Override
    public int matches(String test) {
        Matcher matcher = stackPat.matcher(test);
        if (matcher.find()) {
            return matcher.start();
        }
        return -1;
    }

    @Override
    public String build(BCFontRenderer font, String markdown, int nextPart, BCFontRenderer fr, PartContainer container, LinkedList<Part> parts, int elementLeft, int elementRight, int xPos, int yPos, int nextYLevel) {
        int size;
        GuiMarkdownElement.profiler.startSection("Build Stack");
        this.builtHeight = font.field_78288_b;
        Matcher stackPatMatch = stackPat.matcher(markdown);
        if (!stackPatMatch.find(0)) {
            LogHelperBC.error("Failed to build " + this.getClass().getSimpleName() + " This suggests a false match occurred which should not be possible!");
            return "";
        }
        String match = stackPatMatch.group();
        Matcher stackStringMatch = stackString.matcher(match);
        String stackString = "";
        if (!stackStringMatch.find() || (stackString = stackStringMatch.group()).isEmpty()) {
            return stackPatMatch.replaceFirst("[Broken Stack. No stack string Found]");
        }
        boolean isOre = OreDictionary.doesOreNameExist((String)stackString);
        Matcher opsMatch = stackOPS.matcher(match);
        String ops = opsMatch.find() ? opsMatch.group() : "";
        try {
            size = Part.parseSize(elementRight - elementLeft, Part.readOption(ops, "size", "18"));
        }
        catch (NumberFormatException e) {
            return stackPatMatch.replaceFirst("[Broken Stack. Invalid size value! Must be an integer number]");
        }
        final boolean drawSlot = Part.readOption(ops, "draw_slot", "false").equals("true");
        boolean drawHover = Part.readOption(ops, "draw_hover", "true").equals("true");
        final String altHover = Part.readOption(ops, "alt_hover", "");
        ArrayList<Object> baseStacks = new ArrayList<Object>();
        if (isOre) {
            baseStacks.addAll((Collection<Object>)OreDictionary.getOres((String)stackString));
        } else {
            Object stack;
            StackReference stackRef = StackReference.fromString(stackString);
            if (stackRef == null || (stack = stackRef.createStack()).func_190926_b()) {
                return stackPatMatch.replaceFirst("[Broken Stack. Specified Item or Block could not be found!]");
            }
            baseStacks.add(stack);
        }
        NonNullList finalStacks = NonNullList.func_191196_a();
        for (ItemStack itemStack : baseStacks) {
            if (itemStack.func_77960_j() == Short.MAX_VALUE && itemStack.func_77981_g()) {
                itemStack.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, finalStacks);
                continue;
            }
            finalStacks.add((Object)itemStack);
        }
        final ItemStack[] stacks = (ItemStack[])finalStacks.toArray((Object[])new ItemStack[finalStacks.size()]);
        MouseIntractable mouseIntractable = new MouseIntractable(){

            @Override
            public ItemStack getHoverStack() {
                if (altHover.isEmpty()) {
                    return stacks[BCClientEventHandler.elapsedTicks / 40 % stacks.length];
                }
                return super.getHoverStack();
            }
        };
        if (drawHover && !altHover.isEmpty()) {
            if (altHover.contains("\\n")) {
                mouseIntractable.hoverText.addAll(Arrays.asList(altHover.split("(\\\\n)")));
            } else {
                mouseIntractable.hoverText.add(altHover);
            }
        }
        container.mouseIntractables.add(mouseIntractable);
        if (this.finalXPos + size > elementRight) {
            this.finalXPos = elementLeft;
            this.finalYPos = nextYLevel;
        }
        Part part = new Part(container){

            @Override
            public void render(BCFontRenderer font, int xPos, int yPos, int mouseX, int mouseY, int colour, boolean shadow, float partialTicks) {
                GlStateManager.func_179094_E();
                if (drawSlot) {
                    this.container.bindTexture(BCTextures.MODULAR_GUI);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.container.drawScaledCustomSizeModalRect(xPos, yPos, 0.0, 0.0, 18.0, 18.0, this.width, this.height, 255.0, 255.0);
                }
                double scaledWidth = (double)size / 18.0;
                double scaledHeight = (double)size / 18.0;
                ItemStack stack = stacks[BCClientEventHandler.elapsedTicks / 40 % stacks.length];
                RenderHelper.func_74520_c();
                GlStateManager.func_179137_b((double)((double)xPos + scaledWidth), (double)((double)yPos + scaledHeight), (double)(this.container.getRenderZLevel() - 80.0));
                GlStateManager.func_179139_a((double)scaledWidth, (double)scaledHeight, (double)1.0);
                this.container.mc.func_175599_af().func_175042_a(stack, 0, 0);
                if (stack.func_190916_E() > 1) {
                    String s = "\u00a7f" + stack.func_190916_E() + "" + "\u00a7" + "f";
                    GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(-(this.container.getRenderZLevel() - 80.0)));
                    this.container.zOffset += 45.0;
                    this.container.drawString(font, s, 18 - font.func_78256_a(s) - 1, font.field_78288_b, 0xFFFFFF, true);
                    this.container.zOffset -= 45.0;
                }
                GlStateManager.func_179131_c((float)font.field_78291_n, (float)font.field_78292_o, (float)font.field_78306_p, (float)1.0f);
                RenderHelper.func_74518_a();
                GlStateManager.func_179121_F();
            }
        };
        part.width = size;
        part.height = size;
        this.finalXPos += part.width;
        parts.add(part);
        mouseIntractable.parts.add(part);
        this.builtHeight = this.finalYPos - yPos + part.height + 1;
        return stackPatMatch.replaceFirst("");
    }
}

