/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.guielements;

import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiColourProvider;
import net.minecraft.client.Minecraft;

public class GuiBorderedRect
extends MGuiElementBase<GuiBorderedRect> {
    private GuiColourProvider.HoverColour<Integer> fillColour;
    private GuiColourProvider.HoverColour<Integer> borderColour;
    public double borderWidth = 1.0;

    public GuiBorderedRect() {
    }

    public GuiBorderedRect(int xPos, int yPos) {
        super(xPos, yPos);
    }

    public GuiBorderedRect(int xPos, int yPos, int xSize, int ySize) {
        super(xPos, yPos, xSize, ySize);
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        boolean hovering = this.isMouseOver(mouseX, mouseY);
        this.drawBorderedRect(this.xPos(), this.yPos(), this.xSize(), this.ySize(), this.borderWidth, this.getFillColour(hovering), this.getBorderColour(hovering));
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
    }

    public GuiBorderedRect setColours(int fill, int fillHover, int border, int borderHover) {
        this.setFillColours(fill, fillHover);
        this.setBorderColours(border, borderHover);
        return this;
    }

    public GuiBorderedRect setColours(int fill, int border) {
        this.setFillColour(fill);
        this.setBorderColour(border);
        return this;
    }

    public GuiBorderedRect setBorderColourGetter(GuiColourProvider.HoverColour<Integer> rectBorderColour) {
        this.borderColour = rectBorderColour;
        return this;
    }

    public GuiBorderedRect setBorderColours(int border, int borderHover) {
        this.setBorderColourGetter(hovering -> hovering ? borderHover : border);
        return this;
    }

    public GuiBorderedRect setBorderColour(int border) {
        if (this.borderColour != null) {
            int hover = this.borderColour.getColour(true);
            this.setBorderColourGetter(hovering -> hovering ? hover : border);
        }
        this.setBorderColourGetter(hovering -> border);
        return this;
    }

    public GuiBorderedRect setFillColourGetter(GuiColourProvider.HoverColour<Integer> rectBackColour) {
        this.fillColour = rectBackColour;
        return this;
    }

    public GuiBorderedRect setFillColours(int fill, int fillHover) {
        this.setFillColourGetter(hovering -> hovering ? fillHover : fill);
        return this;
    }

    public GuiBorderedRect setFillColour(int fill) {
        if (this.fillColour != null) {
            int hover = this.fillColour.getColour(true);
            this.setFillColourGetter(hovering -> hovering ? hover : fill);
        }
        this.setFillColourGetter(hovering -> fill);
        return this;
    }

    public GuiBorderedRect setBorderWidth(double borderWidth) {
        this.borderWidth = borderWidth;
        return this;
    }

    protected int getFillColour(boolean hover) {
        if (this.fillColour != null) {
            return this.fillColour.getColour(hover);
        }
        if (this.borderColour != null) {
            return this.borderColour.getColour(hover);
        }
        return -1;
    }

    protected int getBorderColour(boolean hover) {
        if (this.borderColour != null) {
            return this.borderColour.getColour(hover);
        }
        if (this.fillColour != null) {
            return this.fillColour.getColour(hover);
        }
        return -16777216;
    }
}

