/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.client.gui;

import com.cazsius.solcarrot.client.gui.FoodData;
import com.cazsius.solcarrot.client.gui.GuiFoodBook;
import com.cazsius.solcarrot.client.gui.elements.UIBox;
import com.cazsius.solcarrot.client.gui.elements.UIElement;
import com.cazsius.solcarrot.client.gui.elements.UIImage;
import com.cazsius.solcarrot.client.gui.elements.UILabel;
import com.cazsius.solcarrot.client.gui.elements.UIStack;
import com.cazsius.solcarrot.lib.Localization;
import com.cazsius.solcarrot.tracking.ProgressInfo;
import java.awt.Rectangle;

final class ProgressGraph
extends UIElement {
    private static final int segmentLength = 48;
    private ProgressInfo.ConfigInfo configInfo;

    ProgressGraph(FoodData foodData, int centerX, int lineY) {
        super(new Rectangle(centerX, lineY, 96, 1));
        ProgressInfo progressInfo = foodData.progressInfo;
        this.configInfo = progressInfo.configInfo;
        int leftEdge = centerX - 36;
        int leftPoint = centerX - 24;
        int rightPoint = centerX + 24;
        int rightEdge = centerX + 36;
        int padding = 4;
        int milestonesAchieved = progressInfo.milestonesAchieved();
        int previousMilestone = milestonesAchieved > 0 ? this.configInfo.milestones[milestonesAchieved - 1] : 0;
        int nextMilestone = progressInfo.nextMilestone();
        boolean hasReachedMax = progressInfo.hasReachedMax();
        boolean hasSurpassedMax = hasReachedMax && progressInfo.foodsEaten > previousMilestone;
        int progress = 48 * (progressInfo.foodsEaten - previousMilestone) / (nextMilestone - previousMilestone);
        int progressX = leftPoint + (hasSurpassedMax ? 48 : progress);
        UIImage carrotIcon = new UIImage(GuiFoodBook.carrotImage);
        carrotIcon.setCenterY(lineY);
        if (milestonesAchieved > 0) {
            carrotIcon.setMaxX(leftEdge - padding);
        } else {
            int distanceToLeftBookEdge = 36;
            carrotIcon.setCenterX(leftPoint - distanceToLeftBookEdge / 2);
        }
        carrotIcon.tooltip = hasReachedMax ? Localization.localized("gui", "food_book.stats.tooltip.progress.max", new Object[0]) : Localization.localized("gui", "food_book.stats.tooltip.progress", progressInfo.foodsUntilNextMilestone());
        this.children.add(carrotIcon);
        this.children.add(UIBox.horizontalLine(leftPoint, progressX, lineY, GuiFoodBook.fullBlack));
        UILabel previousMilestoneLabel = new UILabel("" + previousMilestone);
        previousMilestoneLabel.color = GuiFoodBook.fullBlack;
        previousMilestoneLabel.tooltip = Localization.localized("gui", "food_book.stats.tooltip.previous_milestone", previousMilestone);
        previousMilestoneLabel.setCenterX(leftPoint);
        previousMilestoneLabel.setMaxY(lineY - 3);
        this.children.add(previousMilestoneLabel);
        this.children.add(UIBox.verticalLine(leftPoint, lineY - 2, lineY - 1, GuiFoodBook.fullBlack));
        if (milestonesAchieved > 0) {
            this.addHeartsView(leftPoint, previousMilestoneLabel.getMinY() - 4, true);
            this.children.add(UIBox.horizontalLine(leftEdge, leftPoint, lineY, GuiFoodBook.fullBlack));
        }
        UILabel foodsEatenLabel = new UILabel("" + progressInfo.foodsEaten);
        foodsEatenLabel.color = GuiFoodBook.fullBlack;
        foodsEatenLabel.tooltip = Localization.localized("gui", "food_book.stats.tooltip.foods_tasted", progressInfo.foodsEaten);
        foodsEatenLabel.setCenterX(progressX);
        foodsEatenLabel.setMinY(lineY + 7);
        this.children.add(foodsEatenLabel);
        this.children.add(UIBox.verticalLine(progressX, lineY + 1, lineY + 5, GuiFoodBook.fullBlack));
        if (!hasReachedMax) {
            UILabel nextMilestoneLabel = new UILabel("" + nextMilestone);
            nextMilestoneLabel.color = GuiFoodBook.lessBlack;
            nextMilestoneLabel.tooltip = Localization.localized("gui", "food_book.stats.tooltip.next_milestone", nextMilestone);
            nextMilestoneLabel.setCenterX(rightPoint);
            nextMilestoneLabel.setMaxY(lineY - 3);
            this.children.add(nextMilestoneLabel);
            this.children.add(UIBox.verticalLine(rightPoint, lineY - 2, lineY - 1, GuiFoodBook.lessBlack));
            this.addHeartsView(rightPoint, previousMilestoneLabel.getMinY() - 4, false);
        }
        if (!hasSurpassedMax) {
            this.children.add(UIBox.horizontalLine(progressX + 1, rightPoint, lineY, hasReachedMax ? GuiFoodBook.leastBlack : GuiFoodBook.lessBlack));
        }
        boolean isLastMilestoneVisible = milestonesAchieved + 1 >= this.configInfo.milestones.length;
        this.children.add(UIBox.horizontalLine(rightPoint + 1, rightEdge, lineY, isLastMilestoneVisible ? GuiFoodBook.leastBlack : GuiFoodBook.lessBlack));
        int totalFoodCount = foodData.validFoods.size();
        if (progressInfo.foodsEaten < totalFoodCount) {
            UILabel totalFoodsLabel = new UILabel(Localization.formatBigNumber(totalFoodCount));
            totalFoodsLabel.color = GuiFoodBook.leastBlack;
            totalFoodsLabel.tooltip = Localization.localized("gui", "food_book.stats.tooltip.total_foods", totalFoodCount);
            totalFoodsLabel.setMinX(rightEdge + padding);
            totalFoodsLabel.setCenterY(lineY);
            this.children.add(totalFoodsLabel);
        }
        this.calculateFrameFromChildren();
        System.out.println(this.frame);
    }

    private void addHeartsView(int centerX, int maxY, boolean isOpaque) {
        UIStack heartsView = new UIStack();
        heartsView.tooltip = Localization.localizedQuantity("gui", "food_book.stats.tooltip.hearts_per_milestone", this.configInfo.heartsPerMilestone);
        int hearts = this.configInfo.heartsPerMilestone;
        if (hearts <= 3) {
            heartsView.spacing = -1;
            for (int i = 0; i < hearts; ++i) {
                UIImage heartImage = new UIImage(GuiFoodBook.heartImage);
                heartImage.setSize(9, 9);
                heartImage.alpha = isOpaque ? 1.0f : 0.5f;
                heartsView.addChild(heartImage);
            }
        } else {
            heartsView.spacing = 1;
            UIImage heartImage = new UIImage(GuiFoodBook.heartImage);
            heartImage.setSize(9, 9);
            heartImage.alpha = isOpaque ? 1.0f : 0.5f;
            heartsView.addChild(heartImage);
            UILabel label = new UILabel("\u00d7" + hearts);
            label.color = isOpaque ? GuiFoodBook.fullBlack : GuiFoodBook.lessBlack;
            heartsView.addChild(label);
        }
        heartsView.setCenterX(centerX);
        heartsView.setMaxY(maxY);
        heartsView.updateFrames();
        this.children.add(heartsView);
    }
}

