/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.tasks;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api.questing.party.IParty;
import betterquesting.api.questing.party.IPartyDatabase;
import betterquesting.api.questing.tasks.IProgression;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.ItemComparison;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api2.cache.CapabilityProviderQuestCache;
import betterquesting.api2.cache.QuestCache;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.DBEntry;
import bq_standard.client.gui.tasks.PanelTaskCrafting;
import bq_standard.core.BQ_Standard;
import bq_standard.tasks.factory.FactoryTaskCrafting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreIngredient;
import org.apache.logging.log4j.Level;

public class TaskCrafting
implements ITask,
IProgression<int[]> {
    private final List<UUID> completeUsers = new ArrayList<UUID>();
    public final NonNullList<BigItemStack> requiredItems = NonNullList.func_191196_a();
    public final HashMap<UUID, int[]> userProgress = new HashMap();
    public boolean partialMatch = true;
    public boolean ignoreNBT = false;
    public boolean allowAnvil = false;
    public boolean allowSmelt = true;
    public boolean allowCraft = true;

    public ResourceLocation getFactoryID() {
        return FactoryTaskCrafting.INSTANCE.getRegistryName();
    }

    public boolean isComplete(UUID uuid) {
        return this.completeUsers.contains(uuid);
    }

    public void setComplete(UUID uuid) {
        if (!this.completeUsers.contains(uuid)) {
            this.completeUsers.add(uuid);
        }
    }

    public String getUnlocalisedName() {
        return "bq_standard.task.crafting";
    }

    public void detect(EntityPlayer player, IQuest quest) {
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        if (this.isComplete(playerID)) {
            return;
        }
        int[] progress = quest == null || (Boolean)quest.getProperty(NativeProps.GLOBAL) == false ? this.getPartyProgress(playerID) : this.getGlobalProgress();
        boolean flag = true;
        for (int i = 0; i < this.requiredItems.size(); ++i) {
            BigItemStack rStack = (BigItemStack)this.requiredItems.get(i);
            if (progress[i] >= rStack.stackSize) continue;
            flag = false;
            break;
        }
        if (flag) {
            this.setComplete(playerID);
            QuestCache qc = (QuestCache)player.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
            if (qc != null) {
                qc.markQuestDirty(((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).getID((Object)quest));
            }
        }
    }

    public void onItemCraft(DBEntry<IQuest> quest, EntityPlayer player, ItemStack stack) {
        if (!this.allowCraft) {
            return;
        }
        this.onItemInternal(quest, player, stack);
    }

    public void onItemSmelt(DBEntry<IQuest> quest, EntityPlayer player, ItemStack stack) {
        if (!this.allowSmelt) {
            return;
        }
        this.onItemInternal(quest, player, stack);
    }

    public void onItemAnvil(DBEntry<IQuest> quest, EntityPlayer player, ItemStack stack) {
        if (!this.allowAnvil) {
            return;
        }
        this.onItemInternal(quest, player, stack);
    }

    private void onItemInternal(DBEntry<IQuest> quest, EntityPlayer player, ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        if (this.isComplete(playerID)) {
            return;
        }
        int[] progress = this.getUsersProgress(playerID);
        boolean updated = false;
        for (int i = 0; i < this.requiredItems.size(); ++i) {
            BigItemStack rStack = (BigItemStack)this.requiredItems.get(i);
            if (progress[i] >= rStack.stackSize || !ItemComparison.StackMatch((ItemStack)rStack.getBaseStack(), (ItemStack)stack, (!this.ignoreNBT ? 1 : 0) != 0, (boolean)this.partialMatch) && !ItemComparison.OreDictionaryMatch((OreIngredient)rStack.getOreIngredient(), (NBTTagCompound)rStack.GetTagCompound(), (ItemStack)stack, (!this.ignoreNBT ? 1 : 0) != 0, (boolean)this.partialMatch)) continue;
            int n = i;
            progress[n] = progress[n] + stack.func_190916_E();
            updated = true;
        }
        if (updated) {
            this.setUserProgress(playerID, progress);
            QuestCache qc = (QuestCache)player.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
            if (qc != null) {
                qc.markQuestDirty(quest.getID());
            }
        }
        this.detect(player, (IQuest)quest.getValue());
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("partialMatch", this.partialMatch);
        nbt.func_74757_a("ignoreNBT", this.ignoreNBT);
        nbt.func_74757_a("allowCraft", this.allowCraft);
        nbt.func_74757_a("allowSmelt", this.allowSmelt);
        nbt.func_74757_a("allowAnvil", this.allowAnvil);
        NBTTagList itemArray = new NBTTagList();
        for (BigItemStack stack : this.requiredItems) {
            itemArray.func_74742_a((NBTBase)JsonHelper.ItemStackToJson((BigItemStack)stack, (NBTTagCompound)new NBTTagCompound()));
        }
        nbt.func_74782_a("requiredItems", (NBTBase)itemArray);
        return nbt;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.partialMatch = nbt.func_74767_n("partialMatch");
        this.ignoreNBT = nbt.func_74767_n("ignoreNBT");
        if (nbt.func_74764_b("allowCraft")) {
            this.allowCraft = nbt.func_74767_n("allowCraft");
        }
        if (nbt.func_74764_b("allowSmelt")) {
            this.allowSmelt = nbt.func_74767_n("allowSmelt");
        }
        if (nbt.func_74764_b("allowAnvil")) {
            this.allowAnvil = nbt.func_74767_n("allowAnvil");
        }
        this.requiredItems.clear();
        NBTTagList iList = nbt.func_150295_c("requiredItems", 10);
        for (int i = 0; i < iList.func_74745_c(); ++i) {
            this.requiredItems.add((Object)JsonHelper.JsonToItemStack((NBTTagCompound)iList.func_150305_b(i)));
        }
    }

    public void readProgressFromNBT(NBTTagCompound nbt, boolean merge) {
        this.completeUsers.clear();
        NBTTagList cList = nbt.func_150295_c("completeUsers", 8);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            try {
                this.completeUsers.add(UUID.fromString(cList.func_150307_f(i)));
                continue;
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load UUID for task", (Throwable)e);
            }
        }
        this.userProgress.clear();
        NBTTagList pList = nbt.func_150295_c("userProgress", 10);
        for (int n = 0; n < pList.func_74745_c(); ++n) {
            UUID uuid;
            NBTTagCompound pTag = pList.func_150305_b(n);
            try {
                uuid = UUID.fromString(pTag.func_74779_i("uuid"));
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load user progress for task", (Throwable)e);
                continue;
            }
            int[] data = new int[this.requiredItems.size()];
            NBTTagList dJson = pTag.func_150295_c("data", 3);
            for (int i = 0; i < data.length && i < dJson.func_74745_c(); ++i) {
                try {
                    data[i] = dJson.func_186858_c(i);
                    continue;
                }
                catch (Exception e) {
                    BQ_Standard.logger.log(Level.ERROR, "Incorrect task progress format", (Throwable)e);
                }
            }
            this.userProgress.put(uuid, data);
        }
    }

    public NBTTagCompound writeProgressToNBT(NBTTagCompound nbt, List<UUID> users) {
        NBTTagList jArray = new NBTTagList();
        for (UUID uuid : this.completeUsers) {
            jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
        }
        nbt.func_74782_a("completeUsers", (NBTBase)jArray);
        NBTTagList progArray = new NBTTagList();
        for (Map.Entry<UUID, int[]> entry : this.userProgress.entrySet()) {
            NBTTagCompound pJson = new NBTTagCompound();
            pJson.func_74778_a("uuid", entry.getKey().toString());
            NBTTagList pArray = new NBTTagList();
            for (int i : entry.getValue()) {
                pArray.func_74742_a((NBTBase)new NBTTagInt(i));
            }
            pJson.func_74782_a("data", (NBTBase)pArray);
            progArray.func_74742_a((NBTBase)pJson);
        }
        nbt.func_74782_a("userProgress", (NBTBase)progArray);
        return nbt;
    }

    public void resetUser(UUID uuid) {
        this.completeUsers.remove(uuid);
        this.userProgress.remove(uuid);
    }

    public void resetAll() {
        this.completeUsers.clear();
        this.userProgress.clear();
    }

    public float getParticipation(UUID uuid) {
        if (this.requiredItems.size() <= 0) {
            return 1.0f;
        }
        float total = 0.0f;
        int[] progress = this.getUsersProgress(uuid);
        for (int i = 0; i < this.requiredItems.size(); ++i) {
            BigItemStack rStack = (BigItemStack)this.requiredItems.get(i);
            total += (float)progress[i] / (float)rStack.stackSize;
        }
        return total / (float)this.requiredItems.size();
    }

    public IGuiPanel getTaskGui(IGuiRect rect, IQuest quest) {
        return new PanelTaskCrafting(rect, quest, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen parent, IQuest quest) {
        return null;
    }

    public void setUserProgress(UUID uuid, int[] progress) {
        this.userProgress.put(uuid, progress);
    }

    public int[] getUsersProgress(UUID ... users) {
        int[] progress = new int[this.requiredItems.size()];
        for (UUID uuid : users) {
            int[] tmp = this.userProgress.get(uuid);
            if (tmp == null || tmp.length != this.requiredItems.size()) continue;
            for (int n = 0; n < progress.length; ++n) {
                int n2 = n;
                progress[n2] = progress[n2] + tmp[n];
            }
        }
        return progress.length != this.requiredItems.size() ? new int[this.requiredItems.size()] : progress;
    }

    public int[] getPartyProgress(UUID uuid) {
        UUID[] uUIDArray;
        IParty party = ((IPartyDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.PARTY_DB)).getUserParty(uuid);
        if (party == null) {
            UUID[] uUIDArray2 = new UUID[1];
            uUIDArray = uUIDArray2;
            uUIDArray2[0] = uuid;
        } else {
            uUIDArray = party.getMembers().toArray(new UUID[0]);
        }
        return this.getUsersProgress(uUIDArray);
    }

    public int[] getGlobalProgress() {
        int[] total = new int[this.requiredItems.size()];
        for (int[] up : this.userProgress.values()) {
            if (up == null || up.length != this.requiredItems.size()) continue;
            for (int i = 0; i < up.length; ++i) {
                int n = i;
                total[n] = total[n] + up[i];
            }
        }
        return total;
    }
}

