/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.importers.hqm;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.importers.IImporter;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.questing.IQuestLineDatabase;
import betterquesting.api.questing.IQuestLineEntry;
import betterquesting.api.questing.rewards.IReward;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.FileExtensionFilter;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api2.storage.IDatabaseNBT;
import betterquesting.api2.utils.BQThreadedIO;
import bq_standard.core.BQ_Standard;
import bq_standard.importers.hqm.HQMUtilities;
import bq_standard.importers.hqm.converters.HQMRep;
import bq_standard.importers.hqm.converters.rewards.HQMRewardChoice;
import bq_standard.importers.hqm.converters.rewards.HQMRewardCommand;
import bq_standard.importers.hqm.converters.rewards.HQMRewardReputation;
import bq_standard.importers.hqm.converters.rewards.HQMRewardStandard;
import bq_standard.importers.hqm.converters.tasks.HQMTaskAdvancement;
import bq_standard.importers.hqm.converters.tasks.HQMTaskBlockBreak;
import bq_standard.importers.hqm.converters.tasks.HQMTaskBlockPlace;
import bq_standard.importers.hqm.converters.tasks.HQMTaskCraft;
import bq_standard.importers.hqm.converters.tasks.HQMTaskDetect;
import bq_standard.importers.hqm.converters.tasks.HQMTaskKill;
import bq_standard.importers.hqm.converters.tasks.HQMTaskLocation;
import bq_standard.importers.hqm.converters.tasks.HQMTaskReputaion;
import bq_standard.importers.hqm.converters.tasks.HQMTaskTame;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Function;
import net.minecraft.init.Items;
import org.apache.logging.log4j.Level;

public class HQMQuestImporter
implements IImporter {
    public static final HQMQuestImporter INSTANCE = new HQMQuestImporter();
    private static final FileFilter FILTER = new FileExtensionFilter(".json");
    private static HashMap<String, Function<JsonObject, ITask[]>> taskConverters = new HashMap();
    private static HashMap<String, Function<JsonElement, IReward[]>> rewardConverters = new HashMap();
    public HashMap<String, HQMRep> reputations = new HashMap();
    private HashMap<String, IQuest> idMap = new HashMap();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public FileFilter getFileFilter() {
        return FILTER;
    }

    public String getUnlocalisedName() {
        return "bq_standard.importer.hqm_quest.name";
    }

    public String getUnlocalisedDescription() {
        return "bq_standard.importer.hqm_quest.desc";
    }

    public void loadFiles(IQuestDatabase questDB, IQuestLineDatabase lineDB, File[] files) {
        JsonArray json;
        this.reputations.clear();
        this.idMap.clear();
        for (File selected : files) {
            if (selected == null || !selected.exists() || !selected.getName().equalsIgnoreCase("reputations.json")) continue;
            json = HQMQuestImporter.ReadArrayFromFile(selected);
            this.LoadReputations(json);
        }
        for (File selected : files) {
            if (selected == null || !selected.exists() || selected.getName().equalsIgnoreCase("reputations.json")) continue;
            json = JsonHelper.ReadFromFile((File)selected);
            this.ImportQuestLine(questDB, lineDB, (JsonObject)json);
        }
    }

    private static JsonArray ReadArrayFromFile(File file) {
        Future task = BQThreadedIO.INSTANCE.enqueue(() -> {
            if (file == null) return new JsonArray();
            if (!file.exists()) {
                return new JsonArray();
            }
            try (InputStreamReader fr = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
                JsonArray jsonArray = (JsonArray)GSON.fromJson((Reader)fr, JsonArray.class);
                return jsonArray;
            }
            catch (Exception e) {
                QuestingAPI.getLogger().log(Level.ERROR, "An error occured while loading JSON from file:", (Throwable)e);
                int i = 0;
                File bkup = new File(file.getParent(), "malformed_" + file.getName() + i + ".json");
                while (true) {
                    if (!bkup.exists()) {
                        QuestingAPI.getLogger().log(Level.ERROR, "Creating backup at: " + bkup.getAbsolutePath());
                        JsonHelper.CopyPaste((File)file, (File)bkup);
                        return new JsonArray();
                    }
                    bkup = new File(file.getParent(), "malformed_" + file.getName() + ++i + ".json");
                }
            }
        });
        try {
            return (JsonArray)task.get();
        }
        catch (Exception e) {
            QuestingAPI.getLogger().error("Unable to read from file " + file, (Throwable)e);
            return new JsonArray();
        }
    }

    private void LoadReputations(JsonArray jsonRoot) {
        if (jsonRoot == null || jsonRoot.size() <= 0) {
            return;
        }
        int i = -1;
        for (JsonElement e : jsonRoot) {
            if (!(e instanceof JsonObject)) continue;
            JsonObject jRep = e.getAsJsonObject();
            String repName = "Reputation(" + i + ")";
            if (jRep.has("Name")) {
                repName = JsonHelper.GetString((JsonObject)jRep, (String)"Name", (String)repName);
            }
            if (jRep.has("name")) {
                repName = JsonHelper.GetString((JsonObject)jRep, (String)"name", (String)repName);
            }
            String repId = "" + ++i;
            if (jRep.has("Id")) {
                repId = JsonHelper.GetNumber((JsonObject)jRep, (String)"Id", (Number)i).toString();
            }
            if (jRep.has("id")) {
                repId = JsonHelper.GetString((JsonObject)jRep, (String)"id", (String)repId);
            }
            HQMRep repObj = new HQMRep(repName);
            JsonArray mrkAry = null;
            if (jRep.has("Markers")) {
                mrkAry = JsonHelper.GetArray((JsonObject)jRep, (String)"Markers");
            }
            if (mrkAry == null) {
                mrkAry = JsonHelper.GetArray((JsonObject)jRep, (String)"markers");
            }
            for (int m = 0; m < mrkAry.size(); ++m) {
                JsonElement e2 = mrkAry.get(m);
                if (!(e2 instanceof JsonObject)) continue;
                JsonObject jMark = e2.getAsJsonObject();
                int mId = m;
                if (jMark.has("Id")) {
                    mId = JsonHelper.GetNumber((JsonObject)jMark, (String)"Id", (Number)mId).intValue();
                }
                int mVal = 0;
                if (jMark.has("Value")) {
                    mVal = JsonHelper.GetNumber((JsonObject)jMark, (String)"Value", (Number)mVal).intValue();
                }
                if (jMark.has("value")) {
                    mVal = JsonHelper.GetNumber((JsonObject)jMark, (String)"value", (Number)mVal).intValue();
                }
                repObj.addMarker(mId, mVal);
            }
            this.reputations.put(repId, repObj);
        }
    }

    private IQuest GetNewQuest(String oldID, IQuestDatabase qdb) {
        if (this.idMap.containsKey(oldID)) {
            return this.idMap.get(oldID);
        }
        IQuest quest = qdb.createNew(qdb.nextID());
        this.idMap.put(oldID, quest);
        return quest;
    }

    /*
     * Could not resolve type clashes
     */
    private void ImportQuestLine(IQuestDatabase questDB, IQuestLineDatabase lineDB, JsonObject json) {
        IQuestLine questLine = lineDB.createNew(lineDB.nextID());
        questLine.setProperty(NativeProps.NAME, (Object)JsonHelper.GetString((JsonObject)json, (String)"name", (String)"HQM Quest Line"));
        questLine.setProperty(NativeProps.DESC, (Object)JsonHelper.GetString((JsonObject)json, (String)"description", (String)"No description"));
        this.LoadReputations(JsonHelper.GetArray((JsonObject)json, (String)"reputations"));
        JsonArray qlJson = JsonHelper.GetArray((JsonObject)json, (String)"quests");
        ArrayList<String> loadedQuests = new ArrayList<String>();
        for (int i = 0; i < qlJson.size(); ++i) {
            IQuest preReq;
            String[] nParts;
            String id;
            String idName;
            JsonElement element = qlJson.get(i);
            if (element == null || !element.isJsonObject()) continue;
            JsonObject jQuest = element.getAsJsonObject();
            String name = JsonHelper.GetString((JsonObject)jQuest, (String)"name", (String)"HQM Quest");
            String string = idName = jQuest.has("uuid") ? JsonHelper.GetString((JsonObject)jQuest, (String)"uuid", (String)name) : name;
            if (loadedQuests.contains(idName)) {
                int n = 1;
                while (loadedQuests.contains(idName + " (" + n + ")")) {
                    ++n;
                }
                BQ_Standard.logger.log(Level.WARN, "Found duplicate quest " + name + ". Any quests with this pre-requisite will need repair!");
                idName = name + " (" + n + ")";
            }
            loadedQuests.add(idName);
            IQuest quest = this.GetNewQuest(idName, questDB);
            quest.setProperty(NativeProps.NAME, (Object)name);
            quest.setProperty(NativeProps.DESC, (Object)JsonHelper.GetString((JsonObject)jQuest, (String)"description", (String)"No Description"));
            BigItemStack tmp = HQMUtilities.HQMStackT1(JsonHelper.GetObject((JsonObject)jQuest, (String)"icon"));
            if (tmp != null) {
                quest.setProperty(NativeProps.ICON, (Object)tmp);
            } else {
                quest.setProperty(NativeProps.ICON, (Object)new BigItemStack(Items.field_151156_bN));
            }
            if (json.has("repeat")) {
                JsonObject jRpt = JsonHelper.GetObject((JsonObject)jQuest, (String)"repeat");
                int rTime = 0;
                rTime += JsonHelper.GetNumber((JsonObject)jRpt, (String)"days", (Number)0).intValue() * 24000;
                quest.setProperty(NativeProps.REPEAT_TIME, (Object)(rTime += JsonHelper.GetNumber((JsonObject)jRpt, (String)"hours", (Number)0).intValue() * 1000));
            }
            for (JsonElement er : JsonHelper.GetArray((JsonObject)jQuest, (String)"prerequisites")) {
                if (er == null || !er.isJsonPrimitive() || !er.getAsJsonPrimitive().isString()) continue;
                id = er.getAsJsonPrimitive().getAsString();
                if (id.startsWith("{") && id.contains("[") && (nParts = id.split("\\[")).length > 1) {
                    id = nParts[1].replaceFirst("]", "");
                }
                preReq = this.GetNewQuest(id, questDB);
                this.addReq(quest, questDB.getID((Object)preReq));
            }
            for (JsonElement er : JsonHelper.GetArray((JsonObject)jQuest, (String)"optionlinks")) {
                if (er == null || !er.isJsonPrimitive() || !er.getAsJsonPrimitive().isString()) continue;
                id = er.getAsJsonPrimitive().getAsString();
                if (id.startsWith("{") && id.contains("[") && (nParts = id.split("\\[")).length > 1) {
                    id = nParts[1].replaceFirst("]", "");
                }
                preReq = this.GetNewQuest(id, questDB);
                this.addReq(quest, questDB.getID((Object)preReq));
            }
            for (JsonElement jt : JsonHelper.GetArray((JsonObject)jQuest, (String)"tasks")) {
                JsonObject jTask;
                String tType;
                if (jt == null || !jt.isJsonObject() || (tType = JsonHelper.GetString((JsonObject)(jTask = jt.getAsJsonObject()), (String)"type", (String)"")) == null || tType.length() <= 0) continue;
                if (!taskConverters.containsKey(tType)) {
                    BQ_Standard.logger.warn("Unsupported HQM task \"" + tType + "\"! Skipping...");
                    continue;
                }
                ITask[] tsks = taskConverters.get(tType).apply(jTask);
                if (tsks == null || tsks.length <= 0) continue;
                IDatabaseNBT taskReg = quest.getTasks();
                for (ITask t : tsks) {
                    taskReg.add(taskReg.nextID(), (Object)t);
                }
            }
            for (Map.Entry entry : rewardConverters.entrySet()) {
                IReward[] rews;
                if (!jQuest.has((String)entry.getKey()) || (rews = (IReward[])((Function)entry.getValue()).apply(jQuest.get((String)entry.getKey()))) == null || rews.length <= 0) continue;
                IDatabaseNBT rewardReg = quest.getRewards();
                for (ITask r : rews) {
                    rewardReg.add(rewardReg.nextID(), (Object)r);
                }
            }
            if (questLine.getValue(questDB.getID((Object)quest)) != null) {
                BQ_Standard.logger.log(Level.WARN, "Tried to add duplicate quest " + quest + " to quest line " + questLine.getUnlocalisedName());
                continue;
            }
            int qleX = JsonHelper.GetNumber((JsonObject)jQuest, (String)"x", (Number)0).intValue();
            int qleY = JsonHelper.GetNumber((JsonObject)jQuest, (String)"y", (Number)0).intValue();
            boolean bigIcon = JsonHelper.GetBoolean((JsonObject)jQuest, (String)"bigicon", (boolean)false);
            IQuestLineEntry qle = questLine.createNew(questDB.getID((Object)quest));
            int size = bigIcon ? 32 : 24;
            qle.setSize(size, size);
            qle.setPosition(qleX, qleY);
        }
    }

    private boolean containsReq(IQuest quest, int id) {
        for (int reqID : quest.getRequirements()) {
            if (id != reqID) continue;
            return true;
        }
        return false;
    }

    private void addReq(IQuest quest, int id) {
        if (this.containsReq(quest, id)) {
            return;
        }
        int[] orig = quest.getRequirements();
        int[] added = Arrays.copyOf(orig, orig.length + 1);
        added[orig.length] = id;
        quest.setRequirements(added);
    }

    static {
        taskConverters.put("DETECT", new HQMTaskDetect(false)::convertTask);
        taskConverters.put("CONSUME", new HQMTaskDetect(true)::convertTask);
        taskConverters.put("CONSUME_QDS", new HQMTaskDetect(true)::convertTask);
        taskConverters.put("KILL", new HQMTaskKill()::convertTask);
        taskConverters.put("LOCATION", new HQMTaskLocation()::convertTask);
        taskConverters.put("CRAFT", new HQMTaskCraft()::convertTask);
        taskConverters.put("TAME", new HQMTaskTame()::convertTask);
        taskConverters.put("ADVANCEMENT", new HQMTaskAdvancement()::convertTask);
        taskConverters.put("BLOCK_BREAK", new HQMTaskBlockBreak()::convertTask);
        taskConverters.put("BLOCK_PLACE", new HQMTaskBlockPlace()::convertTask);
        taskConverters.put("REPUTATION", new HQMTaskReputaion()::convertTask);
        rewardConverters.put("reward", new HQMRewardStandard()::convertReward);
        rewardConverters.put("rewardchoice", new HQMRewardChoice()::convertReward);
        rewardConverters.put("reputationrewards", new HQMRewardReputation()::convertReward);
        rewardConverters.put("commandrewards", new HQMRewardCommand()::convertReward);
    }
}

