/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.client.gui.editors.tasks;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.gui.misc.IVolatileScreen;
import betterquesting.api.enums.EnumPacketAction;
import betterquesting.api.network.IPacketSender;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.RenderUtils;
import betterquesting.api2.client.gui.GuiScreenCanvas;
import betterquesting.api2.client.gui.controls.IFieldFilter;
import betterquesting.api2.client.gui.controls.IValueIO;
import betterquesting.api2.client.gui.controls.PanelButton;
import betterquesting.api2.client.gui.controls.PanelButtonStorage;
import betterquesting.api2.client.gui.controls.PanelTextField;
import betterquesting.api2.client.gui.controls.filters.FieldFilterString;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasTextured;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.client.gui.panels.bars.PanelVScrollBar;
import betterquesting.api2.client.gui.panels.content.PanelGeneric;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import betterquesting.api2.client.gui.resources.textures.ItemTexture;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.utils.QuestTranslation;
import bq_standard.client.gui.editors.tasks.CanvasAdvancementSearch;
import bq_standard.tasks.TaskAdvancement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;

public class GuiEditTaskAdvancement
extends GuiScreenCanvas
implements IVolatileScreen {
    private final IQuest quest;
    private final TaskAdvancement task;
    private ResourceLocation selected;
    private static final ResourceLocation QUEST_EDIT = new ResourceLocation("betterquesting:quest_edit");

    public GuiEditTaskAdvancement(GuiScreen parent, IQuest quest, TaskAdvancement task) {
        super(parent);
        this.quest = quest;
        this.task = task;
        this.selected = task.advID;
    }

    public void initPanel() {
        super.initPanel();
        Keyboard.enableRepeatEvents((boolean)true);
        CanvasTextured cvBackground = new CanvasTextured((IGuiRect)new GuiTransform(), PresetTexture.PANEL_MAIN.getTexture());
        this.addPanel((IGuiPanel)cvBackground);
        cvBackground.addPanel((IGuiPanel)new PanelTextBox((IGuiRect)new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(16, 16, 16, -32), 0), QuestTranslation.translate((String)"bq_standard.title.edit_advancement", (Object[])new Object[0])).setAlignment(1).setColor(PresetColor.TEXT_HEADER.getColor()));
        CanvasAdvancementSearch cvAdvList = new CanvasAdvancementSearch((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(16, 48, 24, 24), 0), this.field_146297_k.field_71439_g.field_71174_a.func_191982_f().func_194229_a()){
            private final List<PanelButtonStorage<Advancement>> btnList;
            {
                this.btnList = new ArrayList<PanelButtonStorage<Advancement>>();
            }

            public void refreshSearch() {
                super.refreshSearch();
                this.btnList.clear();
            }

            protected boolean addResult(Advancement entry, int index, int cachedWidth) {
                DisplayInfo disp = entry.func_192068_c();
                this.addPanel((IGuiPanel)new PanelGeneric((IGuiRect)new GuiRectangle(0, index * 24, 24, 24, 0), PresetTexture.ITEM_FRAME.getTexture()));
                if (disp != null) {
                    this.addPanel((IGuiPanel)new PanelGeneric((IGuiRect)new GuiRectangle(0, index * 24, 24, 24, -1), (IGuiTexture)new ItemTexture(new BigItemStack(disp.func_192298_b()))));
                }
                PanelButtonStorage btnAdv = new PanelButtonStorage((IGuiRect)new GuiRectangle(24, index * 24, cachedWidth - 24, 24, 0), -1, disp != null ? disp.func_192297_a().func_150254_d() : entry.func_192067_g().toString(), (Object)entry);
                btnAdv.setActive(!entry.func_192067_g().equals((Object)GuiEditTaskAdvancement.this.selected));
                btnAdv.setCallback(value -> {
                    GuiEditTaskAdvancement.this.selected = value.func_192067_g();
                    for (PanelButtonStorage<Advancement> b : this.btnList) {
                        b.setActive(!((Advancement)b.getStoredValue()).func_192067_g().equals((Object)GuiEditTaskAdvancement.this.selected));
                    }
                });
                if (disp != null) {
                    btnAdv.setTooltip(RenderUtils.splitString((String)disp.func_193222_b().func_150254_d(), (int)128, (FontRenderer)GuiEditTaskAdvancement.this.field_146297_k.field_71466_p));
                }
                this.addPanel((IGuiPanel)btnAdv);
                this.btnList.add((PanelButtonStorage<Advancement>)btnAdv);
                return true;
            }
        };
        cvBackground.addPanel((IGuiPanel)cvAdvList);
        PanelVScrollBar scAdv = new PanelVScrollBar((IGuiRect)new GuiTransform(GuiAlign.RIGHT_EDGE, new GuiPadding(-24, 48, 16, 24), 0));
        cvBackground.addPanel((IGuiPanel)scAdv);
        cvAdvList.setScrollDriverY((IValueIO)scAdv);
        PanelTextField tfSearch = new PanelTextField((IGuiRect)new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(16, 32, 16, -48), 0), "", (IFieldFilter)FieldFilterString.INSTANCE);
        tfSearch.setWatermark("Search...");
        cvBackground.addPanel((IGuiPanel)tfSearch);
        tfSearch.setCallback(arg_0 -> ((CanvasAdvancementSearch)cvAdvList).setSearchFilter(arg_0));
        cvBackground.addPanel((IGuiPanel)new PanelButton((IGuiRect)new GuiTransform(GuiAlign.BOTTOM_CENTER, -100, -16, 200, 16, 0), -1, QuestTranslation.translate((String)"gui.done", (Object[])new Object[0])){

            public void onButtonClick() {
                GuiEditTaskAdvancement.this.sendChanges();
                GuiEditTaskAdvancement.this.field_146297_k.func_147108_a(GuiEditTaskAdvancement.this.parent);
            }
        });
    }

    private void sendChanges() {
        this.task.advID = this.selected;
        NBTTagCompound base = new NBTTagCompound();
        base.func_74782_a("config", this.quest.writeToNBT((NBTBase)new NBTTagCompound()));
        base.func_74782_a("progress", this.quest.writeProgressToNBT((NBTBase)new NBTTagCompound(), null));
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74768_a("action", EnumPacketAction.EDIT.ordinal());
        tags.func_74768_a("questID", ((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).getID((Object)this.quest));
        tags.func_74782_a("data", (NBTBase)base);
        ((IPacketSender)QuestingAPI.getAPI((ApiKey)ApiReference.PACKET_SENDER)).sendToServer(new QuestingPacket(QUEST_EDIT, tags));
    }
}

