/*
 * Decompiled with CFR 0.152.
 */
package al132.alchemistry.recipes;

import al132.alchemistry.Alchemistry;
import al132.alchemistry.Reference;
import al132.alchemistry.recipes.AtomizerRecipe;
import al132.alchemistry.recipes.CombinerRecipe;
import al132.alchemistry.recipes.DissolverRecipe;
import al132.alchemistry.recipes.ElectrolyzerRecipe;
import al132.alchemistry.recipes.EvaporatorRecipe;
import al132.alchemistry.recipes.LiquifierRecipe;
import al132.alchemistry.recipes.ModRecipes;
import al132.alchemistry.recipes.ProbabilityGroup;
import al132.alchemistry.recipes.ProbabilitySet;
import al132.alchemistry.recipes.XMLRecipeParserKt;
import al132.alchemistry.utils.extensions.StringKt;
import al132.alib.utils.extensions.FluidKt;
import al132.alib.utils.extensions.ItemStackKt;
import al132.alib.utils.extensions.ListKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000f"}, d2={"Lal132/alchemistry/recipes/XMLRecipeParser;", "", "()V", "init", "", "path", "", "parseAtomizerRecipe", "element", "Lorg/w3c/dom/Element;", "parseCombinerRecipe", "parseDissolverRecipe", "parseElectrolyzerRecipe", "parseEvaporatorRecipe", "parseLiquifierRecipe", "alchemistry"})
public final class XMLRecipeParser {
    public final void init(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        try {
            Document doc;
            Document document = doc = docBuilder.parse(new File(Reference.INSTANCE.getConfigDir(), path));
            Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"doc");
            document.getDocumentElement().normalize();
            NodeList nodeList = doc.getElementsByTagName("recipe");
            Intrinsics.checkExpressionValueIsNotNull((Object)nodeList, (String)"doc.getElementsByTagName(\"recipe\")");
            NodeList nodes = nodeList;
            Iterable $receiver$iv = (Iterable)RangesKt.until((int)0, (int)nodes.getLength());
            Iterator iterator = $receiver$iv.iterator();
            while (iterator.hasNext()) {
                String recipeType;
                String string;
                int element$iv;
                int index = element$iv = ((IntIterator)iterator).nextInt();
                Node node = nodes.item(index);
                if (node == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.Element");
                }
                Element element = (Element)node;
                String string2 = element.getAttribute("type");
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"element.getAttribute(\"type\")");
                String string3 = string = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string3.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
                switch (recipeType) {
                    case "dissolver": {
                        this.parseDissolverRecipe(element);
                        break;
                    }
                    case "combiner": {
                        this.parseCombinerRecipe(element);
                        break;
                    }
                    case "evaporator": {
                        this.parseEvaporatorRecipe(element);
                        break;
                    }
                    case "electrolyzer": {
                        this.parseElectrolyzerRecipe(element);
                        break;
                    }
                    case "atomizer": {
                        this.parseAtomizerRecipe(element);
                        break;
                    }
                    case "liquifier": {
                        this.parseLiquifierRecipe(element);
                    }
                }
            }
        }
        catch (SAXParseException e) {
            Alchemistry.INSTANCE.getLogger().info(e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void parseElectrolyzerRecipe(@NotNull Element element) {
        block10: {
            ItemStack electrolyteStack;
            String actionType;
            int inputQuantity;
            Fluid inputFluid;
            block9: {
                ArrayList<ItemStack> outputs;
                int electrolyteConsumptionChance;
                block11: {
                    Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                    Object object = XMLRecipeParserKt.getFirst(element, "input");
                    if (object == null || (object = object.getTextContent()) == null) {
                        object = "";
                    }
                    inputFluid = FluidRegistry.getFluid((String)object);
                    Object object2 = XMLRecipeParserKt.getFirst(element, "input");
                    inputQuantity = object2 != null && (object2 = object2.getAttribute("quantity")) != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? (Integer)object2 : 100;
                    actionType = element.getAttribute("action");
                    Object object3 = XMLRecipeParserKt.getFirst(element, "electrolyte");
                    int n = electrolyteConsumptionChance = object3 != null && (object3 = object3.getAttribute("probability")) != null && (object3 = StringsKt.toIntOrNull((String)object3)) != null ? (Integer)object3 : 50;
                    Element electrolytesXML = XMLRecipeParserKt.getFirst(element, "electrolyte");
                    Object object4 = electrolytesXML;
                    if (object4 == null || (object4 = object4.getTextContent()) == null) {
                        object4 = "";
                    }
                    Object electrolyteString = object4;
                    electrolyteStack = XMLRecipeParserKt.tagToStack(electrolytesXML);
                    if (!(Intrinsics.areEqual((Object)actionType, (Object)"remove") ^ true)) break block9;
                    outputs = new ArrayList<ItemStack>();
                    Element outputXMLElement = XMLRecipeParserKt.getFirst(element, "output");
                    Iterable $receiver$iv = (Iterable)RangesKt.until((int)0, (int)2);
                    Iterator iterator = $receiver$iv.iterator();
                    while (iterator.hasNext()) {
                        ItemStack tempStack;
                        int outputQuantity;
                        int element$iv;
                        int index = element$iv = ((IntIterator)iterator).nextInt();
                        Object object5 = outputXMLElement;
                        int n2 = outputQuantity = object5 != null && (object5 = XMLRecipeParserKt.getNth((Element)object5, "item", index)) != null && (object5 = object5.getAttribute("quantity")) != null && (object5 = StringsKt.toIntOrNull((String)object5)) != null ? (Integer)object5 : 1;
                        Object object6 = outputXMLElement;
                        if (object6 == null || (object6 = XMLRecipeParserKt.getNth((Element)object6, "item", index)) == null || (object6 = object6.getTextContent()) == null) {
                            object6 = "";
                        }
                        if ((tempStack = StringKt.toStack$default((String)object6, outputQuantity, 0, 2, null)).func_190926_b()) continue;
                        outputs.add(tempStack);
                    }
                    if (inputFluid == null || ($receiver$iv = (Collection)outputs).size() <= 0) break block10;
                    if (!OreDictionary.doesOreNameExist((String)electrolyteString)) break block11;
                    ArrayList<ElectrolyzerRecipe> arrayList = ModRecipes.INSTANCE.getElectrolyzerRecipes();
                    FluidStack fluidStack = new FluidStack(inputFluid, inputQuantity);
                    NonNullList nonNullList = OreDictionary.getOres((String)electrolyteString);
                    Intrinsics.checkExpressionValueIsNotNull((Object)nonNullList, (String)"OreDictionary.getOres(electrolyteString)");
                    $receiver$iv = (Collection)nonNullList;
                    FluidStack fluidStack2 = fluidStack;
                    ArrayList<ElectrolyzerRecipe> arrayList2 = arrayList;
                    Iterable iterable = $receiver$iv;
                    if (iterable == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                    }
                    Iterable thisCollection$iv = iterable;
                    ItemStack[] itemStackArray = thisCollection$iv.toArray(new ItemStack[0]);
                    if (itemStackArray == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    ItemStack[] itemStackArray2 = itemStackArray;
                    Ingredient ingredient = Ingredient.func_193369_a((ItemStack[])Arrays.copyOf(itemStackArray2, itemStackArray2.length));
                    Intrinsics.checkExpressionValueIsNotNull((Object)ingredient, (String)"Ingredient.fromStacks(*O\u2026teString).toTypedArray())");
                    Object e = outputs.get(0);
                    Intrinsics.checkExpressionValueIsNotNull(e, (String)"outputs[0]");
                    ItemStack itemStack = (ItemStack)e;
                    Object e2 = outputs.get(1);
                    Intrinsics.checkExpressionValueIsNotNull(e2, (String)"outputs[1]");
                    DefaultConstructorMarker defaultConstructorMarker = null;
                    int n3 = 480;
                    int n4 = 0;
                    ItemStack itemStack2 = null;
                    int n5 = 0;
                    ItemStack itemStack3 = null;
                    ItemStack itemStack4 = (ItemStack)e2;
                    ItemStack itemStack5 = itemStack;
                    int n6 = electrolyteConsumptionChance;
                    Ingredient ingredient2 = ingredient;
                    FluidStack fluidStack3 = fluidStack2;
                    arrayList2.add(new ElectrolyzerRecipe(fluidStack3, ingredient2, n6, itemStack5, itemStack4, itemStack3, n5, itemStack2, n4, n3, defaultConstructorMarker));
                    Alchemistry.INSTANCE.getLogger().info("Added Electrolyzer recipe for [" + inputFluid.getName() + ',' + inputQuantity + ',' + (String)electrolyteString + ']');
                    break block10;
                }
                if (electrolyteStack.func_190926_b()) break block10;
                ArrayList<ElectrolyzerRecipe> arrayList = ModRecipes.INSTANCE.getElectrolyzerRecipes();
                FluidStack fluidStack = FluidKt.toStack((Fluid)inputFluid, (int)inputQuantity);
                Ingredient ingredient = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{electrolyteStack});
                Intrinsics.checkExpressionValueIsNotNull((Object)ingredient, (String)"Ingredient.fromStacks(electrolyteStack)");
                Object e = outputs.get(0);
                Intrinsics.checkExpressionValueIsNotNull(e, (String)"outputs[0]");
                ItemStack itemStack = (ItemStack)e;
                Object e3 = outputs.get(1);
                Intrinsics.checkExpressionValueIsNotNull(e3, (String)"outputs[1]");
                arrayList.add(new ElectrolyzerRecipe(fluidStack, ingredient, electrolyteConsumptionChance, itemStack, (ItemStack)e3, null, 0, null, 0, 480, null));
                Alchemistry.INSTANCE.getLogger().info("Added Electrolyzer recipe for [" + inputFluid.getName() + ',' + inputQuantity + ',' + electrolyteStack + ']');
                break block10;
            }
            if (Intrinsics.areEqual((Object)actionType, (Object)"remove")) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable outputs = ModRecipes.INSTANCE.getElectrolyzerRecipes();
                void outputXMLElement = $receiver$iv;
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    ElectrolyzerRecipe it = (ElectrolyzerRecipe)element$iv$iv;
                    if (!(Intrinsics.areEqual((Object)it.getInput().getFluid(), (Object)inputFluid) && it.getInput().amount == inputQuantity && it.matchesElectrolyte(electrolyteStack))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                for (Object element$iv : $receiver$iv) {
                    ElectrolyzerRecipe it = (ElectrolyzerRecipe)element$iv;
                    ModRecipes.INSTANCE.getElectrolyzerRecipes().remove(it);
                    Alchemistry.INSTANCE.getLogger().info("Removed Electrolyzer recipe: " + it);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void parseCombinerRecipe(@NotNull Element element) {
        int element$iv;
        NodeList itemsXML;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        String actionType = element.getAttribute("action");
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        HashMap<Object, ItemStack> ingredientMap = new HashMap<Object, ItemStack>();
        Element element2 = XMLRecipeParserKt.getFirst(element, "input");
        NodeList nodeList = itemsXML = element2 != null ? element2.getElementsByTagName("item") : null;
        Iterable $receiver$iv = (Iterable)RangesKt.until((int)0, (int)(nodeList != null ? nodeList.getLength() : 0));
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv2;
            int index = element$iv2 = ((IntIterator)iterator).nextInt();
            Object object = itemsXML;
            if (object == null || (object = XMLRecipeParserKt.getNth((NodeList)object, index)) == null || (object = object.getAttribute("key")) == null) {
                object = "";
            }
            Object key = object;
            NodeList nodeList2 = itemsXML;
            ItemStack stack = XMLRecipeParserKt.tagToStack(nodeList2 != null ? XMLRecipeParserKt.getNth(nodeList2, index) : null);
            if (((String)key).length() != 1) continue;
            ingredientMap.put(key, stack);
        }
        Element element3 = XMLRecipeParserKt.getFirst(element, "input");
        NodeList rowsXML = element3 != null ? element3.getElementsByTagName("row") : null;
        Iterable $receiver$iv2 = (Iterable)RangesKt.until((int)0, (int)3);
        Iterator element$iv2 = $receiver$iv2.iterator();
        while (element$iv2.hasNext()) {
            String rowText;
            int i = element$iv = ((IntIterator)element$iv2).nextInt();
            Object object = rowsXML;
            if (object == null || (object = object.item(i)) == null || (object = object.getTextContent()) == null) {
                object = "";
            }
            String string = rowText = StringsKt.padEnd$default((String)object, (int)3, (char)'\u0000', (int)2, null);
            int n = string.length();
            for (int j = 0; j < n; ++j) {
                char c = string.charAt(j);
                ItemStack itemStack = (ItemStack)ingredientMap.get(String.valueOf(c));
                if (itemStack == null) {
                    itemStack = ItemStack.field_190927_a;
                }
                inputs.add(itemStack);
            }
        }
        if (Intrinsics.areEqual((Object)actionType, (Object)"remove") ^ true) {
            Element element4 = XMLRecipeParserKt.getFirst(element, "output");
            Element outputXML = element4 != null ? XMLRecipeParserKt.getFirst(element4, "item") : null;
            ItemStack output = XMLRecipeParserKt.tagToStack(outputXML);
            Alchemistry.INSTANCE.getLogger().info("Added Combiner recipe: for " + inputs);
            ModRecipes.INSTANCE.getCombinerRecipes().add(new CombinerRecipe(output, inputs, null, 4, null));
        } else if (Intrinsics.areEqual((Object)actionType, (Object)"remove")) {
            block3: for (CombinerRecipe recipe : ModRecipes.INSTANCE.getCombinerRecipes()) {
                element$iv = 0;
                int n = ((Collection)recipe.getInputs()).size();
                while (element$iv < n) {
                    void i;
                    Object e = inputs.get((int)i);
                    Intrinsics.checkExpressionValueIsNotNull(e, (String)"inputs[i]");
                    if (!ItemStackKt.areItemStacksEqual((ItemStack)recipe.getInputs().get((int)i), (ItemStack)((ItemStack)e))) continue block3;
                    ++i;
                }
                ModRecipes.INSTANCE.getCombinerRecipes().remove(recipe);
                Alchemistry.INSTANCE.getLogger().info("Removed Combiner recipe: " + recipe);
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void parseEvaporatorRecipe(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Object object = XMLRecipeParserKt.getFirst(element, "input");
        if (object == null || (object = object.getTextContent()) == null) {
            object = "";
        }
        Fluid inputFluid = FluidRegistry.getFluid((String)object);
        String actionType = element.getAttribute("action");
        if (Intrinsics.areEqual((Object)actionType, (Object)"remove") ^ true) {
            Object object2 = XMLRecipeParserKt.getFirst(element, "input");
            int inputQuantity = object2 != null && (object2 = object2.getAttribute("quantity")) != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? (Integer)object2 : 100;
            ItemStack outputStack = XMLRecipeParserKt.tagToStack(XMLRecipeParserKt.getFirst(element, "output"));
            if (inputFluid != null && !outputStack.func_190926_b()) {
                ModRecipes.INSTANCE.getEvaporatorRecipes().add(new EvaporatorRecipe(inputFluid, inputQuantity, outputStack));
                Alchemistry.INSTANCE.getLogger().info("Added Evaporator recipe for [" + inputFluid.getName() + ',' + inputQuantity + ']');
            }
        } else if (Intrinsics.areEqual((Object)actionType, (Object)"remove")) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable inputQuantity = ModRecipes.INSTANCE.getEvaporatorRecipes();
            void outputStack = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                EvaporatorRecipe it = (EvaporatorRecipe)element$iv$iv;
                if (!Intrinsics.areEqual((Object)it.getInput().getFluid(), (Object)inputFluid)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                EvaporatorRecipe it = (EvaporatorRecipe)element$iv;
                ModRecipes.INSTANCE.getEvaporatorRecipes().remove(it);
                Alchemistry.INSTANCE.getLogger().info("Removed Evaporator recipe: " + it);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void parseDissolverRecipe(@NotNull Element element) {
        block20: {
            block21: {
                block19: {
                    Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                    v0 = XMLRecipeParserKt.getFirst(element, "input");
                    if (v0 == null || (v0 = v0.getTextContent()) == null) {
                        v0 = "";
                    }
                    inputStr = v0;
                    v1 = XMLRecipeParserKt.getFirst(element, "input");
                    inputMeta = v1 != null && (v1 = v1.getAttribute("meta")) != null && (v1 = StringsKt.toIntOrNull((String)v1)) != null ? v1.intValue() : 0;
                    v2 = XMLRecipeParserKt.getFirst(element, "input");
                    inputQuantity = v2 != null && (v2 = v2.getAttribute("quantity")) != null && (v2 = StringsKt.toIntOrNull((String)v2)) != null ? v2.intValue() : 1;
                    actionType = element.getAttribute("action");
                    var7_6 = inputQuantity;
                    var8_10 = inputMeta;
                    inputStack = StringKt.toStack((String)inputStr, var7_6, var8_10);
                    if (!(Intrinsics.areEqual((Object)actionType, (Object)"remove") ^ true)) break block19;
                    v3 = outputXMLElement = XMLRecipeParserKt.getFirst(element, "output");
                    outputType = v3 != null ? v3.getAttribute("type") : null;
                    v4 = outputXMLElement;
                    outputRolls = v4 != null && (v4 = v4.getAttribute("rolls")) != null && (v4 = StringsKt.toIntOrNull((String)v4)) != null ? v4.intValue() : 1;
                    groupsList = new ArrayList<ProbabilityGroup>();
                    v5 = outputXMLElement;
                    v6 = xmlGroups = v5 != null ? v5.getElementsByTagName("group") : null;
                    $receiver$iv = (Iterable)RangesKt.until((int)0, (int)(v6 != null ? v6.getLength() : 0));
                    var13_27 = $receiver$iv.iterator();
                    while (var13_27.hasNext()) {
                        groupIndex = element$iv = ((IntIterator)var13_27).nextInt();
                        v7 = xmlGroups;
                        currentXMLElement = v7 != null ? XMLRecipeParserKt.getNth(v7, groupIndex) : null;
                        v8 = currentXMLElement;
                        probability = v8 != null && (v8 = v8.getAttribute("probability")) != null && (v8 = StringsKt.toDoubleOrNull((String)v8)) != null ? v8.doubleValue() : 100.0;
                        v9 = currentXMLElement;
                        xmlItems = v9 != null ? v9.getElementsByTagName("item") : null;
                        itemStacks = new ArrayList<ItemStack>();
                        v10 = xmlItems;
                        var21_41 = (Iterable)RangesKt.until((int)0, (int)(v10 != null ? v10.getLength() : 0));
                        var22_42 = $receiver$iv.iterator();
                        while (var22_42.hasNext()) {
                            itemIndex = element$iv = ((IntIterator)var22_42).nextInt();
                            v11 = xmlItems;
                            itemStacks.add(XMLRecipeParserKt.tagToStack(v11 != null ? XMLRecipeParserKt.getNth(v11, itemIndex) : null));
                        }
                        groupsList.add(new ProbabilityGroup((List<ItemStack>)itemStacks, probability));
                    }
                    outputSet = new ProbabilitySet((List<ProbabilityGroup>)groupsList, Intrinsics.areEqual((Object)outputType, (Object)"absolute") ^ true, outputRolls);
                    if (inputStack.func_190926_b()) {
                        if (OreDictionary.doesOreNameExist((String)inputStr)) {
                            ModRecipes.INSTANCE.getDissolverRecipes().add(new DissolverRecipe((Ingredient)StringKt.toOre((String)inputStr), false, outputSet, 2, null));
                            Alchemistry.INSTANCE.getLogger().info("Added Chemical Dissolver recipe for " + (String)inputStr);
                        } else {
                            Alchemistry.INSTANCE.getLogger().info("Failed to add Chemical Dissolver recipe for " + (String)inputStr);
                        }
                    } else {
                        ModRecipes.INSTANCE.getDissolverRecipes().add(new DissolverRecipe(ItemStackKt.toIngredient((ItemStack)inputStack), false, outputSet, 2, null));
                        Alchemistry.INSTANCE.getLogger().info("Added Chemical Dissolver recipe for " + inputStack);
                    }
                    break block20;
                }
                if (!Intrinsics.areEqual((Object)actionType, (Object)"remove")) break block20;
                if (inputStack.func_190926_b()) break block21;
                outputXMLElement = ModRecipes.INSTANCE.getDissolverRecipes();
                outputType = $receiver$iv;
                destination$iv$iv = new ArrayList<E>();
                groupsList = $receiver$iv$iv.iterator();
                while (groupsList.hasNext()) {
                    element$iv$iv = groupsList.next();
                    it = (DissolverRecipe)element$iv$iv;
                    this_$iv = it;
                    temp$iv = new ArrayList<E>();
                    if (this_$iv.getInput() != null) {
                        v12 = temp$iv;
                        v13 = this_$iv.getInput();
                        if (v13 == null) {
                            Intrinsics.throwNpe();
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)v13.func_193365_a(), (String)"input!!.matchingStacks");
                        currentXMLElement = v12;
                        Intrinsics.checkExpressionValueIsNotNull((Object)Arrays.copyOf(groupIndex, groupIndex.length), (String)"java.util.Arrays.copyOf(this, size)");
                        CollectionsKt.addAll((Collection)currentXMLElement, (Object[])probability);
                    }
                    if ((this_$iv = (Collection)((List)ListKt.toImmutable((List)temp$iv))).size() != 1) ** GOTO lbl-1000
                    this_$iv = it;
                    temp$iv = new ArrayList<E>();
                    if (this_$iv.getInput() != null) {
                        v14 = temp$iv;
                        v15 = this_$iv.getInput();
                        if (v15 == null) {
                            Intrinsics.throwNpe();
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)v15.func_193365_a(), (String)"input!!.matchingStacks");
                        currentXMLElement = v14;
                        Intrinsics.checkExpressionValueIsNotNull((Object)Arrays.copyOf(groupIndex, groupIndex.length), (String)"java.util.Arrays.copyOf(this, size)");
                        CollectionsKt.addAll((Collection)currentXMLElement, (Object[])probability);
                    }
                    if (ItemStackKt.areItemStacksEqual((ItemStack)((ItemStack)((List)ListKt.toImmutable((List)temp$iv)).get(0)), (ItemStack)inputStack)) {
                        v16 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v16 = false;
                    }
                    if (!v16) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                for (T element$iv : $receiver$iv) {
                    it = (DissolverRecipe)element$iv;
                    ModRecipes.INSTANCE.getDissolverRecipes().remove(it);
                    Alchemistry.INSTANCE.getLogger().info("Removed Chemical Dissolver recipe: " + it);
                }
                break block20;
            }
            if (!OreDictionary.doesOreNameExist((String)inputStr)) break block20;
            $receiver$iv = ModRecipes.INSTANCE.getDissolverRecipes();
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList<E>();
            for (T element$iv$iv : $receiver$iv$iv) {
                it = (DissolverRecipe)element$iv$iv;
                v17 = it.getInput();
                if (v17 != null && (v17 = v17.func_193365_a()) != null) {
                    var13_29 = v17;
                    Intrinsics.checkExpressionValueIsNotNull((Object)OreDictionary.getOres((String)inputStr).toArray(), (String)"OreDictionary.getOres(inputStr).toArray()");
                    v18 = Arrays.equals(var13_29, var14_32);
                } else {
                    v18 = false;
                }
                if (!v18) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (T element$iv : $receiver$iv) {
                it = (DissolverRecipe)element$iv;
                ModRecipes.INSTANCE.getDissolverRecipes().remove(it);
                Alchemistry.INSTANCE.getLogger().info("Removed Chemical Dissolver recipe: " + it);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void parseAtomizerRecipe(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Object object = XMLRecipeParserKt.getFirst(element, "input");
        if (object == null || (object = object.getTextContent()) == null) {
            object = "";
        }
        Fluid inputFluid = FluidRegistry.getFluid((String)object);
        String actionType = element.getAttribute("action");
        if (Intrinsics.areEqual((Object)actionType, (Object)"remove") ^ true) {
            Object object2 = XMLRecipeParserKt.getFirst(element, "input");
            int inputQuantity = object2 != null && (object2 = object2.getAttribute("quantity")) != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? (Integer)object2 : 100;
            ItemStack outputStack = XMLRecipeParserKt.tagToStack(XMLRecipeParserKt.getFirst(element, "output"));
            if (inputFluid != null && !outputStack.func_190926_b()) {
                ModRecipes.INSTANCE.getAtomizerRecipes().add(new AtomizerRecipe(false, inputFluid, inputQuantity, outputStack, 1, null));
                Alchemistry.INSTANCE.getLogger().info("Added Atomizer recipe for [" + inputFluid.getName() + ',' + inputQuantity + ']');
            }
        } else if (Intrinsics.areEqual((Object)actionType, (Object)"remove")) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable inputQuantity = ModRecipes.INSTANCE.getAtomizerRecipes();
            void outputStack = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                AtomizerRecipe it = (AtomizerRecipe)element$iv$iv;
                if (!Intrinsics.areEqual((Object)it.getInput().getFluid(), (Object)inputFluid)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                AtomizerRecipe it = (AtomizerRecipe)element$iv;
                ModRecipes.INSTANCE.getAtomizerRecipes().remove(it);
                Alchemistry.INSTANCE.getLogger().info("Removed Atomizer recipe: " + it);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void parseLiquifierRecipe(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        String actionType = element.getAttribute("action");
        Element inputXML = XMLRecipeParserKt.getFirst(element, "input");
        Object object = inputXML;
        if (object == null || (object = object.getTextContent()) == null) {
            object = "";
        }
        Object inputString = object;
        ItemStack inputStack = XMLRecipeParserKt.tagToStack(inputXML);
        if (Intrinsics.areEqual((Object)actionType, (Object)"remove") ^ true) {
            int outputQuantity;
            Object object2 = XMLRecipeParserKt.getFirst(element, "output");
            if (object2 == null || (object2 = object2.getTextContent()) == null) {
                object2 = "";
            }
            Fluid outputFluid = FluidRegistry.getFluid((String)object2);
            Object object3 = XMLRecipeParserKt.getFirst(element, "output");
            int n = object3 != null && (object3 = object3.getAttribute("quantity")) != null && (object3 = StringsKt.toIntOrNull((String)object3)) != null ? (Integer)object3 : (outputQuantity = 100);
            if (outputFluid != null && !inputStack.func_190926_b()) {
                ModRecipes.INSTANCE.getLiquifierRecipes().add(new LiquifierRecipe(inputStack, new FluidStack(outputFluid, outputQuantity)));
            } else {
                Alchemistry.INSTANCE.getLogger().info("Failed to add Liquifier recipe for: " + (String)inputString);
            }
        } else if (Intrinsics.areEqual((Object)actionType, (Object)"remove")) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable outputFluid = ModRecipes.INSTANCE.getLiquifierRecipes();
            void outputQuantity = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                LiquifierRecipe it = (LiquifierRecipe)element$iv$iv;
                if (!ItemStackKt.areItemsEqual((ItemStack)it.getInput(), (ItemStack)inputStack)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                LiquifierRecipe it = (LiquifierRecipe)element$iv;
                ModRecipes.INSTANCE.getLiquifierRecipes().remove(it);
                Alchemistry.INSTANCE.getLogger().info("Removed Liquifier recipe: " + it);
            }
        }
    }
}

