/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.network;

import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.crafting.helper.CraftingAccessManager;
import hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.network.SerializeableRecipe;
import hellfirepvp.astralsorcery.common.util.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;

public class GrindstoneRecipeAdd
implements SerializeableRecipe {
    private ItemHandle in;
    private ItemStack out;
    private float doubleChance = 0.0f;

    GrindstoneRecipeAdd() {
    }

    public GrindstoneRecipeAdd(ItemHandle in, ItemStack out) {
        this(in, out, 0.0f);
    }

    public GrindstoneRecipeAdd(ItemHandle in, ItemStack out, float doubleChance) {
        this.in = in;
        this.out = out;
        this.doubleChance = doubleChance;
    }

    @Override
    public SerializeableRecipe.CraftingType getType() {
        return SerializeableRecipe.CraftingType.GRINDSTONE_ADD;
    }

    @Override
    public void read(ByteBuf buf) {
        this.in = ItemHandle.deserialize(buf);
        this.out = ByteBufUtils.readItemStack(buf);
        this.doubleChance = buf.readFloat();
    }

    @Override
    public void write(ByteBuf buf) {
        this.in.serialize(buf);
        ByteBufUtils.writeItemStack(buf, this.out);
        buf.writeFloat(this.doubleChance);
    }

    @Override
    public void applyRecipe() {
        CraftingAccessManager.addGrindstoneRecipe(this.in, this.out, 12, this.doubleChance);
    }
}

