/*
 * Decompiled with CFR 0.152.
 */
package mal.lootbags;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mal.lootbags.LootBags;
import mal.lootbags.LootbagsUtil;
import mal.lootbags.config.BagEntitySource;
import mal.lootbags.handler.BagHandler;
import mal.lootbags.loot.LootItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootEntryItemAccess;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Bag {
    private String bagName = "Default";
    private String bagNameColor = "";
    private int bagIndex = -1;
    private List<String> bagTextUnopened = new ArrayList<String>();
    private List<String> bagTextOpened = new ArrayList<String>();
    private List<String> bagTextShift = new ArrayList<String>();
    private int bagTextureColorBase = 0xFFFFFF;
    private int bagTextureColorString = 0xFFFFFF;
    private boolean useAltJsonFile = true;
    private int[] spawnChances = new int[4];
    private int maxItems = 5;
    private int minItems = 1;
    private int maxGeneralWeight = -1;
    private int minGeneralWeight = -1;
    private int bagInsertValue = -1;
    private int bagExtractValue = -1;
    private boolean entityExclusionToggle = false;
    private boolean useGeneralLootTable = false;
    private boolean isSecret = false;
    private boolean recyclerBlacklist = false;
    private int preventItemRepeats = 0;
    private int bagMapWeight = 0;
    private boolean bagIsEmpty = false;
    private HashMap<String, LootItem> map = new HashMap();
    private ArrayList<LootItem> BagWhitelist = new ArrayList();
    private ArrayList<LootItem> BagBlacklist = new ArrayList();
    private ArrayList<String> BagModBlacklist = new ArrayList();
    private ArrayList<BagEntitySource> EntityList = new ArrayList();

    public Bag(String name, int index) {
        this.bagName = name;
        this.bagIndex = index;
    }

    /*
     * WARNING - void declaration
     */
    public void populateBag() {
        String key;
        ArrayList<Object> list = this.useGeneralLootTable ? LootBags.LOOTMAP.getMapByWeight(this.minGeneralWeight, this.maxGeneralWeight) : new ArrayList();
        ArrayList<LootItem> nullClear = new ArrayList<LootItem>();
        for (LootItem lootItem : this.BagBlacklist) {
            if (lootItem.getContentItem() == null) {
                lootItem.reinitializeLootItem();
            }
            if (lootItem.getContentItem() != null) continue;
            LootbagsUtil.LogError("Blacklisted Content Item " + lootItem.getItemModID() + ":" + lootItem.getItemName() + " is NULL.  This is a major problem, probably caused by the item not being initilized and added to the Forge registry before the ServerStarted event when this code runs.");
            nullClear.add(lootItem);
        }
        this.BagBlacklist.removeAll(nullClear);
        for (LootItem lootItem : list) {
            if (LootbagsUtil.listContainsItem(this.BagBlacklist, lootItem) || this.BagModBlacklist.contains(lootItem.getItemModID())) continue;
            key = lootItem.getItemModID() + lootItem.getItemName() + lootItem.getContentItem().func_77952_i();
            this.map.put(key, lootItem);
        }
        for (LootItem lootItem : this.BagWhitelist) {
            if (lootItem.getContentItem() == null) {
                lootItem.reinitializeLootItem();
            }
            if (lootItem.getContentItem() != null) {
                key = lootItem.getItemModID() + lootItem.getItemName() + lootItem.getContentItem().func_77952_i();
                if (lootItem.getContentItem().func_77942_o()) {
                    key = key + lootItem.getContentItem().func_77978_p().toString();
                }
                if (this.getItemRepeats() == 3) {
                    key = key + this.BagWhitelist.indexOf(lootItem);
                }
                if (this.map.containsKey(key)) {
                    this.map.remove(key);
                }
                this.map.put(key, lootItem);
                if (LootBags.LOOTMAP.totalList.containsKey(key)) continue;
                LootBags.LOOTMAP.totalList.put(key, lootItem);
                continue;
            }
            LootbagsUtil.LogError("Whitelisted Content Item " + lootItem.getItemModID() + ":" + lootItem.getItemName() + " is NULL.  This is a major problem, probably caused by the item not being initilized and added to the Forge registry before the PostInit event when this code runs.");
        }
        int average = 0;
        boolean bl = false;
        for (LootItem item : this.map.values()) {
            void var4_11;
            if (item.getItemWeight() > average * 10 && average > 0 && item.getGeneral()) {
                item.setItemWeight(average * 10);
            }
            this.bagMapWeight += item.getItemWeight();
            average = this.bagMapWeight / ++var4_11;
        }
        if (this.bagMapWeight <= 0) {
            this.bagIsEmpty = true;
        }
        if (LootBags.DEBUGMODE) {
            LootbagsUtil.LogDebug("Bag ID: " + this.bagIndex);
            LootbagsUtil.LogDebug("Bag Weight: " + this.bagMapWeight);
            for (LootItem item : this.map.values()) {
                LootbagsUtil.LogDebug(item.toString());
            }
        }
    }

    public ItemStack getRandomItem() {
        ArrayList<LootItem> content = BagHandler.generateContent(this.map.values());
        if (content.size() > 0 && this.bagMapWeight > 0) {
            LootItem item = LootbagsUtil.getRandomItem(content, this.bagMapWeight);
            for (int r = 0; item == null && r < LootBags.MAXREROLLCOUNT; ++r) {
                LootbagsUtil.LogInfo("Rerolling null item: Reroll count " + r + ".");
                item = LootbagsUtil.getRandomItem(content, this.bagMapWeight);
            }
            if (item == null) {
                return null;
            }
            ItemStack[] stacks = LootbagsUtil.generateStacks(LootBags.getRandom(), item, item.getMinStack(), item.getMaxStack());
            return stacks.length > 0 ? stacks[0] : null;
        }
        LootbagsUtil.LogError("Failed to get random item: Bag loot table or total weight <= 0.  This probably means this bag's config information is messed up somehow.");
        return null;
    }

    public ItemStack getSpecificItem(int index) {
        if (index < this.map.values().size()) {
            return ((LootItem)this.map.values().toArray()[index]).getContentItem();
        }
        return null;
    }

    public void addWhitelistItem(LootItem item) {
        this.BagWhitelist.add(item);
    }

    public void addWhitelistItem(String modid, String itemname, ArrayList<Integer> damage, int minstack, int maxstack, int weight) {
        for (Integer dam : damage) {
            LootItem item = new LootItem(null, modid, itemname, dam, minstack, maxstack, weight, false);
            this.BagWhitelist.add(item);
        }
    }

    public void addWhitelistItem(String modid, String itemname, ArrayList<Integer> damage, int minstack, int maxstack, int weight, byte[] nbt) {
        for (Integer dam : damage) {
            LootItem item = new LootItem(null, modid, itemname, dam, minstack, maxstack, weight, nbt, false);
            this.BagWhitelist.add(item);
        }
    }

    public void addWhitelistCategory(ResourceLocation category) {
        try {
            String entryname;
            String poolname;
            LootTable table = LootbagsUtil.getLootManager(null).func_186521_a(category);
            if (((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue()) {
                poolname = "pools";
                entryname = "lootEntries";
            } else {
                poolname = "field_186466_c";
                entryname = "field_186453_a";
            }
            Field poolListField = LootTable.class.getDeclaredField(poolname);
            poolListField.setAccessible(true);
            Field lootListField = LootPool.class.getDeclaredField(entryname);
            lootListField.setAccessible(true);
            this.processLootTable(table, 0, poolListField, lootListField);
        }
        catch (Exception e) {
            LootbagsUtil.LogError("Issue with parsing Bag Whitelist of category: " + category.toString());
        }
    }

    private void processLootTable(LootTable table, int count, Field poolListField, Field lootListField) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        if (count > 10) {
            return;
        }
        List poolList = (List)poolListField.get(table);
        for (LootPool pool : poolList) {
            List lootList = (List)lootListField.get(pool);
            RandomValueRange prange = pool.getRolls();
            float average = (prange.func_186509_a() + prange.func_186512_b()) / 2.0f;
            for (LootEntry loot : lootList) {
                if (loot instanceof LootEntryItem) {
                    int maxstack;
                    int minstack;
                    LootEntryItem lloot = (LootEntryItem)loot;
                    ItemStack stack = LootEntryItemAccess.getLootEntryItemStack(lloot);
                    int weight = (int)Math.floor((float)LootEntryItemAccess.getLootEntryItemWeight((LootEntry)lloot) * average);
                    RandomValueRange range = LootEntryItemAccess.getStackSizes(lloot);
                    if (range != null) {
                        minstack = (int)range.func_186509_a();
                        maxstack = (int)range.func_186512_b();
                    } else {
                        minstack = 1;
                        maxstack = 1;
                    }
                    LootItem item = null;
                    boolean skip = false;
                    if (stack == null || stack.func_77973_b() == null) {
                        skip = true;
                        LootbagsUtil.LogInfo("Found a null item in the loot table, skipping it.");
                    } else {
                        item = new LootItem(lloot, stack, minstack, maxstack, weight, true);
                    }
                    if (item != null && item.getItemWeight() < 1) {
                        LootbagsUtil.LogError("Item " + item.getContentItem().toString() + " has a weighting of " + item.getItemWeight() + ".  This is not a Lootbags error but an error in a different mod!  This item will be excluded from the Lootbags loot table.");
                    } else if (!skip) {
                        for (String modid : LootBags.LOOTMAP.getGeneralModBlacklist()) {
                            if (!ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item.getContentItem().func_77973_b()).func_110624_b().equalsIgnoreCase(modid)) continue;
                            skip = true;
                            LootbagsUtil.LogInfo("Found item to skip from Blacklisted mod: " + item.toString());
                        }
                        for (LootItem entry : LootBags.LOOTMAP.getGeneralBlacklist()) {
                            if (!item.getContentItem().func_77973_b().equals(entry.getContentItem().func_77973_b()) || entry.getMetadata() != -1 && item.getContentItem().func_77960_j() != entry.getMetadata()) continue;
                            skip = true;
                            LootbagsUtil.LogInfo("Found Blacklisted item to skip: " + item.toString());
                        }
                        if (!skip) {
                            this.BagWhitelist.add(item);
                            LootbagsUtil.LogDebug("Added new Category Item: " + item.toString());
                        }
                    }
                }
                if (!(loot instanceof LootEntryTable)) continue;
                LootEntryTable tloot = (LootEntryTable)loot;
                LootTable ltable = LootEntryItemAccess.getLootTable(tloot, LootBags.LOOTMAP.getContext());
                this.processLootTable(ltable, count + 1, poolListField, lootListField);
            }
        }
    }

    public void addBlacklistItem(LootItem item) {
        this.BagBlacklist.add(item);
    }

    public void addBlacklistItem(String modid, String itemname, ArrayList<Integer> damage) {
        for (Integer dam : damage) {
            LootItem item = new LootItem(null, modid, itemname, dam, 1, 1, 1, false);
            this.BagBlacklist.add(item);
        }
    }

    public void addBlacklistItem(String modid) {
        if (!this.BagModBlacklist.contains(modid)) {
            this.BagModBlacklist.add(modid);
        }
    }

    public void setSpawnChancePlayer(int spawnchance) {
        this.spawnChances[0] = spawnchance;
    }

    public void setSpawnChancePassive(int spawnchance) {
        this.spawnChances[1] = spawnchance;
    }

    public void setSpawnChanceMonster(int spawnchance) {
        this.spawnChances[2] = spawnchance;
    }

    public void setSpawnChanceBoss(int spawnchance) {
        this.spawnChances[3] = spawnchance;
    }

    public void setBagNameColor(String code) {
        this.bagNameColor = code;
    }

    public void addUnopenedText(String text) {
        if (this.bagTextUnopened == null) {
            this.bagTextUnopened = new ArrayList<String>();
        }
        this.bagTextUnopened.add(text);
    }

    public void addOpenedText(String text) {
        if (this.bagTextOpened == null) {
            this.bagTextOpened = new ArrayList<String>();
        }
        text = text.replace("$", "");
        this.bagTextOpened.add(text);
    }

    public void addShiftText(String text) {
        if (this.bagTextShift == null) {
            this.bagTextShift = new ArrayList<String>();
        }
        text = text.replace("$", "");
        this.bagTextShift.add(text);
    }

    public void setBagColor(int baseColor, int stringColor) {
        this.bagTextureColorBase = baseColor;
        this.bagTextureColorString = stringColor;
        this.useAltJsonFile = false;
    }

    public String getBagName() {
        return this.bagName;
    }

    public String getBagNameColor() {
        return this.bagNameColor;
    }

    public String getDefaultName() {
        return "lootbag";
    }

    public int[] getChances() {
        return this.spawnChances;
    }

    public int getBagMapWeight() {
        return this.bagMapWeight;
    }

    public boolean isBagEmpty() {
        return this.bagIsEmpty;
    }

    public int[] getBagValue() {
        return new int[]{this.bagInsertValue, this.bagExtractValue};
    }

    public StorageStates isStorable() {
        if (this.bagInsertValue > 0 && this.bagExtractValue > 0) {
            return StorageStates.BOTH;
        }
        if (this.bagInsertValue > 0) {
            return StorageStates.INPUTONLY;
        }
        if (this.bagExtractValue > 0) {
            return StorageStates.OUTPUTONLY;
        }
        return StorageStates.NONE;
    }

    public void setBagValue(int lowerweight, int upperweight) {
        this.bagInsertValue = lowerweight;
        this.bagExtractValue = upperweight;
    }

    public String getMonsterDropChance() {
        float chance = (float)this.spawnChances[2] * 100.0f / (float)LootBags.DROPRESOLUTION;
        return String.format("%.2f", Float.valueOf(chance));
    }

    public String getPassiveDropChance() {
        float chance = (float)this.spawnChances[1] * 100.0f / (float)LootBags.DROPRESOLUTION;
        return String.format("%.2f", Float.valueOf(chance));
    }

    public String getPlayerDropChance() {
        float chance = (float)this.spawnChances[0] * 100.0f / (float)LootBags.DROPRESOLUTION;
        return String.format("%.2f", Float.valueOf(chance));
    }

    public String getBossDropChance() {
        float chance = (float)this.spawnChances[3] * 100.0f / (float)LootBags.DROPRESOLUTION;
        return String.format("%.2f", Float.valueOf(chance));
    }

    public int getBossDropWeight() {
        return this.spawnChances[3];
    }

    public int getPlayerDropWeight() {
        return this.spawnChances[0];
    }

    public int getPassiveDropWeight() {
        return this.spawnChances[1];
    }

    public int getMonsterDropWeight() {
        return this.spawnChances[2];
    }

    public ItemStack getBagItem() {
        return new ItemStack((Item)LootBags.lootbagItem, 1, this.bagIndex);
    }

    public Bag setSecret(boolean secret) {
        this.isSecret = secret;
        return this;
    }

    public void setGeneralSources(boolean state) {
        this.useGeneralLootTable = state;
    }

    public boolean getSecret() {
        return this.isSecret;
    }

    public int getBagIndex() {
        return this.bagIndex;
    }

    public List<String> getBagTextUnopened() {
        return this.bagTextUnopened;
    }

    public List<String> getBagTextOpened() {
        return this.bagTextOpened;
    }

    public List<String> getBagTextShift() {
        return this.bagTextShift;
    }

    public int[] getBagTextureColor() {
        int[] color = new int[]{this.bagTextureColorBase, this.bagTextureColorString};
        return color;
    }

    public boolean getUseAltJson() {
        return this.useAltJsonFile;
    }

    public HashMap<String, LootItem> getMap() {
        return this.map;
    }

    private boolean addItemToMap(LootItem content) {
        String key = content.getItemModID() + content.getItemName() + content.getContentItem().func_77952_i();
        if (!this.map.containsKey(key)) {
            this.map.put(key, content);
            return true;
        }
        return false;
    }

    public void setMaximumItemsDropped(int weight) {
        this.maxItems = weight;
    }

    public void setMinimumItemsDropped(int weight) {
        this.minItems = weight;
    }

    public void setMaximumGeneralWeight(int weight) {
        this.maxGeneralWeight = weight;
    }

    public void setMinimumGeneralWeight(int weight) {
        this.minGeneralWeight = weight;
    }

    public void setItemRepeats(int state) {
        this.preventItemRepeats = state;
    }

    public void setEntityExclusion(boolean state) {
        this.entityExclusionToggle = state;
    }

    public boolean getEntityExlusion() {
        return this.entityExclusionToggle;
    }

    public void addEntityToList(String name, boolean isVisibleName) {
        BagEntitySource bs = new BagEntitySource(name, isVisibleName);
        this.EntityList.add(bs);
    }

    public ArrayList<BagEntitySource> getEntityList() {
        return this.EntityList;
    }

    public int getMinItems() {
        return this.minItems;
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    public int getItemRepeats() {
        return this.preventItemRepeats;
    }

    public void setRecyclerBlacklist(boolean b) {
        this.recyclerBlacklist = b;
    }

    public boolean getRecyclerBlacklist() {
        return this.recyclerBlacklist;
    }

    public static enum StorageStates {
        INPUTONLY(true, false),
        OUTPUTONLY(false, true),
        BOTH(true, true),
        NONE(false, false);

        private boolean canInput;
        private boolean canOutput;

        private StorageStates(boolean canInput, boolean canOutput) {
            this.canInput = canInput;
            this.canOutput = canOutput;
        }

        public boolean canInput() {
            return this.canInput;
        }

        public boolean canOutput() {
            return this.canOutput;
        }
    }
}

