/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import javax.annotation.Nonnull;
import mekanism.api.EnumColor;
import mekanism.api.IConfigCardAccess;
import mekanism.api.TileNetworkList;
import mekanism.api.infuse.InfuseObject;
import mekanism.api.infuse.InfuseRegistry;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.InfuseStorage;
import mekanism.common.MekanismBlocks;
import mekanism.common.MekanismItems;
import mekanism.common.PacketHandler;
import mekanism.common.SideData;
import mekanism.common.Upgrade;
import mekanism.common.base.IFactory;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ITierUpgradeable;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.integration.computer.IComputerIntegration;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.InfusionInput;
import mekanism.common.recipe.machines.MetallurgicInfuserRecipe;
import mekanism.common.tier.BaseTier;
import mekanism.common.tile.TileEntityFactory;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.prefab.TileEntityOperationalMachine;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Contract;

public class TileEntityMetallurgicInfuser
extends TileEntityOperationalMachine
implements IComputerIntegration,
ISideConfiguration,
IConfigCardAccess,
ITierUpgradeable,
ISustainedData {
    private static final String[] methods = new String[]{"getEnergy", "getProgress", "facing", "canOperate", "getMaxEnergy", "getEnergyNeeded", "getInfuse", "getInfuseNeeded"};
    public int MAX_INFUSE = 1000;
    public InfuseStorage infuseStored = new InfuseStorage();
    public TileComponentEjector ejectorComponent;
    public TileComponentConfig configComponent = new TileComponentConfig(this, TransmissionType.ITEM);

    public TileEntityMetallurgicInfuser() {
        super("machine.metalinfuser", BlockStateMachine.MachineType.METALLURGIC_INFUSER, 0, 200);
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("None", EnumColor.GREY, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Input", EnumColor.DARK_RED, new int[]{2}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Output", EnumColor.DARK_BLUE, new int[]{3}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Energy", EnumColor.DARK_GREEN, new int[]{4}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Infuse", EnumColor.PURPLE, new int[]{1}));
        this.configComponent.setConfig(TransmissionType.ITEM, new byte[]{4, 0, 0, 3, 1, 2});
        this.inventory = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(TransmissionType.ITEM, this.configComponent.getOutputs(TransmissionType.ITEM).get(2));
        this.securityComponent = new TileComponentSecurity(this);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            MetallurgicInfuserRecipe recipe;
            InfuseObject pendingInfuseInput;
            ChargeUtils.discharge(4, this);
            ItemStack infuseInput = (ItemStack)this.inventory.get(1);
            if (!(infuseInput.func_190926_b() || (pendingInfuseInput = InfuseRegistry.getObject(infuseInput)) == null || this.infuseStored.getType() != null && this.infuseStored.getType() != pendingInfuseInput.type || this.infuseStored.getAmount() + pendingInfuseInput.stored > this.MAX_INFUSE)) {
                this.infuseStored.increase(pendingInfuseInput);
                infuseInput.func_190918_g(1);
            }
            if (this.canOperate(recipe = RecipeHandler.getMetallurgicInfuserRecipe(this.getInput())) && MekanismUtils.canFunction(this) && this.getEnergy() >= this.energyPerTick) {
                this.setActive(true);
                this.setEnergy(this.getEnergy() - this.energyPerTick);
                if (this.operatingTicks + 1 < this.ticksRequired) {
                    ++this.operatingTicks;
                } else {
                    this.operate(recipe);
                    this.operatingTicks = 0;
                }
            } else if (this.prevEnergy >= this.getEnergy()) {
                this.setActive(false);
            }
            if (!this.canOperate(recipe)) {
                this.operatingTicks = 0;
            }
            this.prevEnergy = this.getEnergy();
        }
    }

    @Override
    public boolean upgrade(BaseTier upgradeTier) {
        if (upgradeTier != BaseTier.BASIC) {
            return false;
        }
        this.field_145850_b.func_175698_g(this.func_174877_v());
        this.field_145850_b.func_180501_a(this.func_174877_v(), MekanismBlocks.MachineBlock.func_176203_a(5), 3);
        TileEntityFactory factory = Objects.requireNonNull((TileEntityFactory)this.field_145850_b.func_175625_s(this.func_174877_v()));
        IFactory.RecipeType type = IFactory.RecipeType.INFUSING;
        factory.facing = this.facing;
        factory.clientFacing = this.clientFacing;
        factory.ticker = this.ticker;
        factory.redstone = this.redstone;
        factory.redstoneLastTick = this.redstoneLastTick;
        factory.doAutoSync = this.doAutoSync;
        factory.electricityStored = this.electricityStored;
        factory.progress[0] = this.operatingTicks;
        factory.setActive(this.isActive);
        factory.setControlType(this.getControlType());
        factory.prevEnergy = this.prevEnergy;
        factory.upgradeComponent.readFrom(this.upgradeComponent);
        factory.upgradeComponent.setUpgradeSlot(0);
        factory.ejectorComponent.readFrom(this.ejectorComponent);
        factory.ejectorComponent.setOutputData(TransmissionType.ITEM, factory.configComponent.getOutputs(TransmissionType.ITEM).get(2));
        factory.setRecipeType(type);
        factory.upgradeComponent.setSupported(Upgrade.GAS, type.fuelEnergyUpgrades());
        factory.securityComponent.readFrom(this.securityComponent);
        for (TransmissionType transmission : this.configComponent.getTransmissions()) {
            factory.configComponent.setConfig(transmission, this.configComponent.getConfig(transmission).asByteArray());
            factory.configComponent.setEjecting(transmission, this.configComponent.isEjecting(transmission));
        }
        factory.infuseStored.copyFrom(this.infuseStored);
        factory.inventory.set(5, this.inventory.get(2));
        factory.inventory.set(1, this.inventory.get(4));
        factory.inventory.set(8, this.inventory.get(3));
        factory.inventory.set(0, this.inventory.get(0));
        factory.inventory.set(4, this.inventory.get(1));
        for (Upgrade upgrade : factory.upgradeComponent.getSupportedTypes()) {
            factory.recalculateUpgradables(upgrade);
        }
        factory.upgraded = true;
        factory.func_70296_d();
        return true;
    }

    @Override
    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        if (slotID == 4) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return slotID == 3;
    }

    @Override
    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        if (slotID == 3) {
            return false;
        }
        if (slotID == 1) {
            InfuseObject infuseObject = InfuseRegistry.getObject(itemstack);
            return infuseObject != null && (this.infuseStored.getType() == null || this.infuseStored.getType() == infuseObject.type);
        }
        if (slotID == 0) {
            return itemstack.func_77973_b() == MekanismItems.SpeedUpgrade || itemstack.func_77973_b() == MekanismItems.EnergyUpgrade;
        }
        if (slotID == 2) {
            if (this.infuseStored.getType() != null) {
                return RecipeHandler.getMetallurgicInfuserRecipe(new InfusionInput(this.infuseStored, itemstack)) != null;
            }
            for (InfusionInput input : RecipeHandler.Recipe.METALLURGIC_INFUSER.get().keySet()) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)input.inputStack, (ItemStack)itemstack)) continue;
                return true;
            }
        } else if (slotID == 4) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return false;
    }

    public InfusionInput getInput() {
        return new InfusionInput(this.infuseStored, (ItemStack)this.inventory.get(2));
    }

    public void operate(MetallurgicInfuserRecipe recipe) {
        recipe.output((NonNullList<ItemStack>)this.inventory, 2, 3, this.infuseStored);
        this.func_70296_d();
        this.ejectorComponent.outputItems();
    }

    @Contract(value="null -> false")
    public boolean canOperate(MetallurgicInfuserRecipe recipe) {
        return recipe != null && recipe.canOperate((NonNullList<ItemStack>)this.inventory, 2, 3, this.infuseStored);
    }

    public int getScaledInfuseLevel(int i) {
        return this.infuseStored.getAmount() * i / this.MAX_INFUSE;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        int amount = nbtTags.func_74762_e("infuseStored");
        if (amount != 0) {
            this.infuseStored.setAmount(amount);
            this.infuseStored.setType(InfuseRegistry.get(nbtTags.func_74779_i("type")));
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        if (this.infuseStored.getType() != null) {
            nbtTags.func_74778_a("type", this.infuseStored.getType().name);
            nbtTags.func_74768_a("infuseStored", this.infuseStored.getAmount());
        } else {
            nbtTags.func_74778_a("type", "null");
        }
        nbtTags.func_74757_a("sideDataStored", true);
        return nbtTags;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            int amount = dataStream.readInt();
            if (amount == 0) {
                this.infuseStored.setEmpty();
            } else {
                this.infuseStored.setAmount(amount);
            }
            return;
        }
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            int amount = dataStream.readInt();
            if (amount > 0) {
                this.infuseStored.setAmount(amount);
                this.infuseStored.setType(InfuseRegistry.get(PacketHandler.readString(dataStream)));
            } else {
                this.infuseStored.setEmpty();
            }
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.infuseStored.getAmount());
        if (this.infuseStored.getAmount() > 0) {
            data.add(this.infuseStored.getType().name);
        }
        return data;
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws NoSuchMethodException {
        switch (method) {
            case 0: {
                return new Object[]{this.getEnergy()};
            }
            case 1: {
                return new Object[]{this.operatingTicks};
            }
            case 2: {
                return new Object[]{this.facing};
            }
            case 3: {
                return new Object[]{this.canOperate(RecipeHandler.getMetallurgicInfuserRecipe(this.getInput()))};
            }
            case 4: {
                return new Object[]{this.getMaxEnergy()};
            }
            case 5: {
                return new Object[]{this.getMaxEnergy() - this.getEnergy()};
            }
            case 6: {
                return new Object[]{this.infuseStored};
            }
            case 7: {
                return new Object[]{this.MAX_INFUSE - this.infuseStored.getAmount()};
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return this.configComponent.getOutput((TransmissionType)TransmissionType.ITEM, (EnumFacing)side, (EnumFacing)this.facing).availableSlots;
    }

    @Override
    public boolean canSetFacing(int side) {
        return side != 0 && side != 1;
    }

    @Override
    public TileComponentConfig getConfig() {
        return this.configComponent;
    }

    @Override
    public EnumFacing getOrientation() {
        return this.facing;
    }

    @Override
    public TileComponentEjector getEjector() {
        return this.ejectorComponent;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return false;
        }
        return capability == Capabilities.CONFIG_CARD_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return null;
        }
        if (capability == Capabilities.CONFIG_CARD_CAPABILITY) {
            return (T)Capabilities.CONFIG_CARD_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        return this.configComponent.isCapabilityDisabled(capability, side, this.facing) || super.isCapabilityDisabled(capability, side);
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        this.infuseStored.writeSustainedData(itemStack);
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.infuseStored.readSustainedData(itemStack);
    }
}

