/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.wrenches;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import mekanism.api.IMekWrench;
import mekanism.common.integration.wrenches.BuildCraftProxy;
import mekanism.common.integration.wrenches.CofhProxy;
import mekanism.common.integration.wrenches.IC2Proxy;
import mekanism.common.integration.wrenches.MekPassthrough;
import mekanism.common.integration.wrenches.MekWrenchProxy;
import net.minecraft.item.ItemStack;

public enum Wrenches {
    MEKANISM_PASSTHROUGH(IMekWrench.class.getName(), MekPassthrough::new),
    BUILDCRAFT("buildcraft.api.tools.IToolWrench", BuildCraftProxy::new),
    COFH("cofh.api.item.IToolHammer", CofhProxy::new),
    IC2("ic2.core.item.tool.ItemToolWrench", IC2Proxy::new);

    private final String classname;
    private final Supplier<MekWrenchProxy> mekProxy;
    private Class<?> itemClass;
    private boolean enabled;
    private MekWrenchProxy provider;

    private Wrenches(String clazz, Supplier<MekWrenchProxy> mekProxy) {
        this.classname = clazz;
        this.mekProxy = mekProxy;
    }

    public static void initialise() {
        for (Wrenches w : Wrenches.values()) {
            try {
                w.itemClass = Class.forName(w.classname);
            }
            catch (ClassNotFoundException e) {
                w.enabled = false;
                w.provider = null;
                w.itemClass = null;
                continue;
            }
            try {
                w.provider = w.mekProxy.get();
            }
            catch (Exception e) {
                w.enabled = false;
                w.provider = null;
            }
            w.enabled = w.provider != null;
        }
    }

    @Nullable
    public static IMekWrench getHandler(ItemStack it) {
        for (Wrenches w : Wrenches.values()) {
            if (!w.canHandle(it)) continue;
            return w.provider.get(it);
        }
        return null;
    }

    private boolean canHandle(ItemStack it) {
        return this.enabled && this.provider != null && this.itemClass != null && this.itemClass.isInstance(it.func_77973_b());
    }
}

