/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.botanicadds.items;

import com.zeitheron.botanicadds.net.PacketLC;
import com.zeitheron.hammercore.net.HCNet;
import com.zeitheron.hammercore.net.IPacket;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.ILensEffect;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class ItemManaStealerSword
extends ItemSword
implements ILensEffect,
IManaUsingItem {
    public static final Item.ToolMaterial MANA_STEALING = EnumHelper.addToolMaterial((String)"BA_MANA_STEALING", (int)0, (int)3000, (float)1.0f, (float)11.0f, (int)60);
    private static final String TAG_ATTACKER_USERNAME = "attackerUsername";
    private static final int MANA_PER_DAMAGE = 200;

    public ItemManaStealerSword() {
        super(MANA_STEALING);
        this.func_77655_b("mana_stealer_sword");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void leftClick(PlayerInteractEvent.LeftClickEmpty evt) {
        if (!evt.getItemStack().func_190926_b() && evt.getItemStack().func_77973_b() == this) {
            HCNet.INSTANCE.sendToServer((IPacket)new PacketLC());
        }
    }

    @SubscribeEvent
    public void attackEntity(AttackEntityEvent evt) {
        if (!evt.getEntityPlayer().field_70170_p.field_72995_K) {
            this.trySpawnBurst(evt.getEntityPlayer());
        }
    }

    public void trySpawnBurst(EntityPlayer player) {
        if (!player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() == this && player.func_184825_o(0.0f) == 1.0f) {
            IManaBurst burst = this.getBurst(player, player.func_184614_ca());
            player.field_70170_p.func_72838_d((Entity)burst);
            ToolCommons.damageItem((ItemStack)player.func_184614_ca(), (int)1, (EntityLivingBase)player, (int)200);
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, ModSounds.terraBlade, SoundCategory.PLAYERS, 0.4f, 1.4f);
        }
    }

    public IManaBurst getBurst(EntityPlayer player, ItemStack stack) {
        IManaBurst burst = null;
        try {
            burst = (IManaBurst)Class.forName("vazkii.botania.common.entity.EntityManaBurst").getDeclaredConstructor(EntityPlayer.class, EnumHand.class).newInstance(player, EnumHand.MAIN_HAND);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
        float motionModifier = 7.0f;
        burst.setColor(10499383);
        burst.setMana(200);
        burst.setStartingMana(200);
        burst.setMinManaLoss(50);
        burst.setManaLossPerTick(1.0f);
        burst.setGravity(0.0f);
        burst.setMotion(((Entity)burst).field_70159_w * (double)motionModifier, ((Entity)burst).field_70181_x * (double)motionModifier, ((Entity)burst).field_70179_y * (double)motionModifier);
        ItemStack lens = stack.func_77946_l();
        ItemNBTHelper.setString((ItemStack)lens, (String)TAG_ATTACKER_USERNAME, (String)player.func_70005_c_());
        burst.setSourceLens(lens);
        return burst;
    }

    public int getManaPerDamage() {
        return 200;
    }

    public void apply(ItemStack stack, BurstProperties props) {
    }

    public boolean collideBurst(IManaBurst burst, RayTraceResult pos, boolean isManaBlock, boolean dead, ItemStack stack) {
        if (pos != null && pos.field_72313_a == RayTraceResult.Type.ENTITY) {
            String attacker = ItemNBTHelper.getString((ItemStack)burst.getSourceLens(), (String)TAG_ATTACKER_USERNAME, (String)"");
            EntityPlayer owner = ((Entity)burst).field_70170_p.func_72924_a(attacker);
            if (pos.field_72308_g instanceof EntityPlayer) {
                EntityPlayer victim = (EntityPlayer)pos.field_72308_g;
                int extracted = ManaItemHandler.requestMana((ItemStack)stack, (EntityPlayer)victim, (int)(1000 + (int)Math.round(Math.random() * 1000.0)), (boolean)false);
                ManaItemHandler.requestMana((ItemStack)stack, (EntityPlayer)victim, (int)ManaItemHandler.dispatchMana((ItemStack)stack, (EntityPlayer)owner, (int)extracted, (boolean)true), (boolean)true);
                victim.field_70170_p.func_184148_a(null, victim.field_70165_t, victim.field_70163_u, victim.field_70161_v, ModSounds.enchanterFade, SoundCategory.PLAYERS, 0.4f, 1.4f);
            }
            if (owner != null) {
                owner.field_70170_p.func_184148_a(null, owner.field_70165_t, owner.field_70163_u, owner.field_70161_v, ModSounds.enchanterForm, SoundCategory.PLAYERS, 0.4f, 1.4f);
            }
        }
        return dead;
    }

    public void updateBurst(IManaBurst burst, ItemStack stack) {
        EntityThrowable entity = (EntityThrowable)burst;
        AxisAlignedBB axis = new AxisAlignedBB(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70142_S, entity.field_70137_T, entity.field_70136_U).func_186662_g(1.0);
        List entities = entity.field_70170_p.func_72872_a(EntityLivingBase.class, axis);
        String attacker = ItemNBTHelper.getString((ItemStack)burst.getSourceLens(), (String)TAG_ATTACKER_USERNAME, (String)"");
        for (EntityLivingBase living : entities) {
            if (living instanceof EntityPlayer && (living.func_70005_c_().equals(attacker) || FMLCommonHandler.instance().getMinecraftServerInstance() != null && !FMLCommonHandler.instance().getMinecraftServerInstance().func_71219_W()) || living.field_70737_aN != 0) continue;
            int cost = 66;
            int mana = burst.getMana();
            if (mana < cost) continue;
            burst.setMana(mana - cost);
            float damage = 4.0f + MANA_STEALING.func_78000_c();
            if (burst.isFake() || entity.field_70170_p.field_72995_K) continue;
            EntityPlayer player = living.field_70170_p.func_72924_a(attacker);
            living.func_70097_a(player == null ? DamageSource.field_76376_m : DamageSource.func_76365_a((EntityPlayer)player), damage);
            this.collideBurst(burst, new RayTraceResult((Entity)living), false, true, stack);
            entity.func_70106_y();
            break;
        }
    }

    public boolean doParticles(IManaBurst burst, ItemStack stack) {
        return true;
    }

    public boolean func_82789_a(ItemStack par1ItemStack, @Nonnull ItemStack par2ItemStack) {
        return par2ItemStack.func_77973_b() == ModItems.manaResource && par2ItemStack.func_77952_i() == 4 ? true : super.func_82789_a(par1ItemStack, par2ItemStack);
    }

    public boolean func_77644_a(ItemStack par1ItemStack, EntityLivingBase par2EntityLivingBase, @Nonnull EntityLivingBase par3EntityLivingBase) {
        if (this.usesMana(par1ItemStack)) {
            ToolCommons.damageItem((ItemStack)par1ItemStack, (int)1, (EntityLivingBase)par3EntityLivingBase, (int)this.getManaPerDamage());
        }
        return true;
    }

    public boolean func_179218_a(@Nonnull ItemStack stack, @Nonnull World world, IBlockState state, @Nonnull BlockPos pos, @Nonnull EntityLivingBase entity) {
        if (this.usesMana(stack) && state.func_185887_b(world, pos) != 0.0f) {
            ToolCommons.damageItem((ItemStack)stack, (int)1, (EntityLivingBase)entity, (int)this.getManaPerDamage());
        }
        return true;
    }

    public void func_77663_a(ItemStack stack, World world, Entity player, int par4, boolean par5) {
        if (!world.field_72995_K && player instanceof EntityPlayer && stack.func_77952_i() > 0 && ManaItemHandler.requestManaExactForTool((ItemStack)stack, (EntityPlayer)((EntityPlayer)player), (int)(this.getManaPerDamage() * 2), (boolean)true)) {
            stack.func_77964_b(stack.func_77952_i() - 1);
        }
    }

    public boolean usesMana(ItemStack stack) {
        return true;
    }
}

