/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.primitivemobs.entity.ai;

import net.daveyx0.primitivemobs.config.PrimitiveMobsConfigSpecial;
import net.daveyx0.primitivemobs.entity.monster.EntityTrollager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityMob;

public class EntityAITrollagerAttacks<T extends EntityMob>
extends EntityAIBase {
    private final EntityTrollager entity;
    private final double moveSpeedAmp;
    private final float maxAttackDistance;
    private final float meleeAttackDistance;
    private int attackTime = -1;
    private int animTime = -1;
    private int attackDelay = -1;
    private int seeTime;
    private boolean isAttacking;

    public EntityAITrollagerAttacks(EntityTrollager entity, double moveSpeed, float meleeAttackDistance, float maxAttackDistance) {
        this.entity = entity;
        this.moveSpeedAmp = moveSpeed;
        this.maxAttackDistance = maxAttackDistance * maxAttackDistance;
        this.meleeAttackDistance = meleeAttackDistance * meleeAttackDistance;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        return this.entity.func_70638_az() != null && !this.entity.isStone();
    }

    public boolean func_75253_b() {
        return this.func_75250_a();
    }

    public void func_75249_e() {
        super.func_75249_e();
        this.seeTime = 0;
        this.attackTime = -1;
        this.animTime = -1;
        this.isAttacking = false;
        this.determineAttackAndPerform();
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.entity.setAnimationState(0);
        this.seeTime = 0;
        this.attackTime = -1;
        this.animTime = -1;
        this.isAttacking = false;
    }

    public boolean checkCanThrow() {
        EntityLivingBase entitylivingbase = this.entity.func_70638_az();
        EntityTrollager troll = this.entity;
        if (entitylivingbase != null && troll != null) {
            return troll.canBlockAreaSeeEntity((Entity)entitylivingbase);
        }
        return false;
    }

    public void func_75246_d() {
        this.determineAttackAndPerform();
    }

    public void determineAttackAndPerform() {
        EntityLivingBase entitylivingbase = this.entity.func_70638_az();
        if (entitylivingbase != null) {
            boolean canPerformThrowAttack;
            double distanceToEnemy = this.entity.func_70092_e(entitylivingbase.field_70165_t, entitylivingbase.func_174813_aQ().field_72338_b, entitylivingbase.field_70161_v);
            boolean canSeeEnemy = this.entity.func_70635_at().func_75522_a((Entity)entitylivingbase);
            boolean canNavigateToEnemy = this.entity.func_70661_as().func_75497_a((Entity)entitylivingbase, this.moveSpeedAmp);
            boolean isWithinMeleeRange = distanceToEnemy <= (double)this.meleeAttackDistance * (double)this.meleeAttackDistance;
            boolean isWithinAttackRange = distanceToEnemy <= (double)this.maxAttackDistance * (double)this.maxAttackDistance;
            boolean canThrowBlock = this.checkCanThrow();
            boolean canPerformMeleeAttack = isWithinMeleeRange && canSeeEnemy;
            boolean canPerformSmashAttack = PrimitiveMobsConfigSpecial.getTrollDestruction() && (isWithinAttackRange && (!canSeeEnemy || !canThrowBlock) || this.entity.field_70170_p.field_73012_v.nextInt(4) == 0) && !this.entity.func_184207_aI();
            boolean bl = canPerformThrowAttack = canSeeEnemy && canThrowBlock && !this.entity.func_184207_aI();
            if (--this.attackTime <= 0 && this.isAttacking) {
                if (this.entity.getAnimationState() == 3) {
                    this.entity.performAction(entitylivingbase, 1);
                    this.entity.setAnimationState(4);
                    this.animTime = 20;
                } else if (this.entity.getAnimationState() == 0) {
                    this.entity.performAction(entitylivingbase, 2);
                    this.entity.setAnimationState(6);
                    this.animTime = 7;
                } else {
                    this.entity.performAction(entitylivingbase, 0);
                    this.entity.setAnimationState(2);
                    this.animTime = 20;
                }
                this.attackTime = Integer.MAX_VALUE;
            }
            if (this.animTime >= 0 && --this.animTime == 0) {
                if (this.entity.getAnimationState() == 4) {
                    this.entity.setAnimationState(5);
                    this.animTime = 10;
                } else if (this.entity.getAnimationState() == 6) {
                    this.entity.setAnimationState(7);
                    this.animTime = 7;
                } else {
                    this.animTime = -1;
                    this.isAttacking = false;
                }
            }
            if (!this.isAttacking) {
                if (canPerformMeleeAttack) {
                    this.entity.setAnimationState(0);
                    this.attackTime = 10;
                    this.isAttacking = true;
                } else if (canPerformSmashAttack) {
                    this.entity.setAnimationState(3);
                    this.attackTime = 40;
                    this.isAttacking = true;
                } else if (canPerformThrowAttack) {
                    this.entity.setAnimationState(1);
                    this.attackTime = 30;
                    this.isAttacking = true;
                } else {
                    this.entity.setAnimationState(0);
                    this.attackTime = Integer.MAX_VALUE;
                }
            }
            this.entity.func_70661_as().func_75497_a((Entity)entitylivingbase, this.moveSpeedAmp);
            this.entity.func_70671_ap().func_75651_a((Entity)entitylivingbase, 30.0f, 30.0f);
        }
    }
}

