/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.transformer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Comparator;

public class TransformerNames {
    public static boolean obfuscated = false;
    private static ArrayList<ClassName> classes = new ArrayList();
    private static ArrayList<MethodName> methods = new ArrayList();
    private static ArrayList<FieldName> fields = new ArrayList();

    public static void emptyLists() {
        classes.clear();
        fields.clear();
        methods.clear();
    }

    public static String patchDESC(String desc) {
        if (obfuscated) {
            for (int i = 0; i < classes.size(); ++i) {
                desc = desc.replace(TransformerNames.classes.get((int)i).name, TransformerNames.classes.get((int)i).obfname);
            }
        }
        return desc;
    }

    public static String patchClassName(String className) {
        if (obfuscated) {
            for (int i = 0; i < classes.size(); ++i) {
                if (!className.equals(TransformerNames.classes.get((int)i).name)) continue;
                return TransformerNames.classes.get((int)i).obfname;
            }
        }
        return className;
    }

    public static String patchFieldName(String fieldName, Class parent) {
        return TransformerNames.patchFieldName(fieldName, TransformerNames.patchClassName(parent.getName()));
    }

    public static String patchFieldName(String fieldName, String parentName) {
        if (obfuscated) {
            for (int i = 0; i < fields.size(); ++i) {
                if (!fieldName.equals(TransformerNames.fields.get((int)i).name) || !parentName.equals(TransformerNames.fields.get((int)i).parent)) continue;
                return TransformerNames.fields.get((int)i).obfname;
            }
        }
        return fieldName;
    }

    public static String patchMethodName(String methodName, String desc, Class parent) {
        return TransformerNames.patchMethodName(methodName, desc, TransformerNames.patchClassName(parent.getName()));
    }

    public static String patchMethodName(String methodName, String desc, String parentName) {
        if (obfuscated) {
            String obfdesc = TransformerNames.patchDESC(desc);
            for (int i = 0; i < methods.size(); ++i) {
                if (!methodName.equals(TransformerNames.methods.get((int)i).name) || !parentName.equals(TransformerNames.methods.get((int)i).parent) || !TransformerNames.methods.get((int)i).desc.equals(obfdesc)) continue;
                return TransformerNames.methods.get((int)i).obfname;
            }
        }
        return methodName;
    }

    static {
        try {
            InputStreamReader reader = new InputStreamReader(TransformerNames.class.getResourceAsStream("notch-mcp.srg"));
            BufferedReader bf = new BufferedReader(reader);
            String line = null;
            while ((line = bf.readLine()) != null) {
                String name;
                String[] splitted;
                String[] parts = line.split(" ");
                if (line.startsWith("CL:")) {
                    if (parts.length != 3) continue;
                    classes.add(new ClassName(parts[2], parts[1]));
                    continue;
                }
                if (line.startsWith("FD:")) {
                    if (parts.length != 3) continue;
                    splitted = parts[2].split("/");
                    name = splitted[splitted.length - 1];
                    splitted = parts[1].split("/");
                    fields.add(new FieldName(name, splitted[1], splitted[0]));
                    continue;
                }
                if (!line.startsWith("MD:") || parts.length != 5) continue;
                splitted = parts[3].split("/");
                name = splitted[splitted.length - 1];
                splitted = parts[1].split("/");
                methods.add(new MethodName(name, splitted[1], splitted[0], parts[2]));
            }
            classes.sort(new Comparator<ClassName>(){

                @Override
                public int compare(ClassName arg0, ClassName arg1) {
                    if (arg0.name.length() > arg1.name.length()) {
                        return -1;
                    }
                    if (arg0.name.length() == arg1.name.length()) {
                        return 0;
                    }
                    return 1;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class MethodName
    extends FieldName {
        public final String desc;

        public MethodName(String name, String obfname, String parent, String desc) {
            super(name, obfname, parent);
            this.desc = desc;
        }
    }

    private static class FieldName
    extends ClassName {
        public final String parent;

        public FieldName(String name, String obfname, String parent) {
            super(name, obfname);
            this.parent = parent;
        }
    }

    private static class ClassName {
        public final String name;
        public final String obfname;

        public ClassName(String name, String obfname) {
            this.name = name;
            this.obfname = obfname;
        }
    }
}

