/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.math;

import com.creativemd.creativecore.common.utils.math.BooleanUtils;
import com.creativemd.creativecore.common.utils.math.IVecOrigin;
import java.util.HashMap;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class MatrixUtils {
    public static Matrix3d createIdentityMatrix() {
        Matrix3d matrix = new Matrix3d();
        matrix.setIdentity();
        return matrix;
    }

    public static Matrix3d createRotationMatrix(double rotX, double rotY, double rotZ) {
        Matrix3d matrix = MatrixUtils.createRotationMatrixZ(rotZ);
        matrix.mul(MatrixUtils.createRotationMatrixY(rotY));
        matrix.mul(MatrixUtils.createRotationMatrixX(rotX));
        return matrix;
    }

    public static void mul(Matrix4d matrix, Matrix3d matrix2) {
        double m00 = matrix.m00 * matrix2.m00 + matrix.m01 * matrix2.m10 + matrix.m02 * matrix2.m20;
        double m01 = matrix.m00 * matrix2.m01 + matrix.m01 * matrix2.m11 + matrix.m02 * matrix2.m21;
        double m02 = matrix.m00 * matrix2.m02 + matrix.m01 * matrix2.m12 + matrix.m02 * matrix2.m22;
        double m10 = matrix.m10 * matrix2.m00 + matrix.m11 * matrix2.m10 + matrix.m12 * matrix2.m20;
        double m11 = matrix.m10 * matrix2.m01 + matrix.m11 * matrix2.m11 + matrix.m12 * matrix2.m21;
        double m12 = matrix.m10 * matrix2.m02 + matrix.m11 * matrix2.m12 + matrix.m12 * matrix2.m22;
        double m20 = matrix.m20 * matrix2.m00 + matrix.m21 * matrix2.m10 + matrix.m22 * matrix2.m20;
        double m21 = matrix.m20 * matrix2.m01 + matrix.m21 * matrix2.m11 + matrix.m22 * matrix2.m21;
        double m22 = matrix.m20 * matrix2.m02 + matrix.m21 * matrix2.m12 + matrix.m22 * matrix2.m22;
        matrix.m00 = m00;
        matrix.m01 = m01;
        matrix.m02 = m02;
        matrix.m10 = m10;
        matrix.m11 = m11;
        matrix.m12 = m12;
        matrix.m20 = m20;
        matrix.m21 = m21;
        matrix.m22 = m22;
    }

    private static Matrix4d createRotationMatrixAndTranslationRadians(double x, double y, double z, double rotX, double rotY, double rotZ) {
        Matrix4d matrix = new Matrix4d();
        if (rotZ != 0.0) {
            matrix.rotZ(rotZ);
        } else {
            matrix.setIdentity();
        }
        if (rotY != 0.0) {
            MatrixUtils.mul(matrix, MatrixUtils.createRotationMatrixYRadians(rotY));
        }
        if (rotX != 0.0) {
            MatrixUtils.mul(matrix, MatrixUtils.createRotationMatrixXRadians(rotX));
        }
        matrix.m03 = x;
        matrix.m13 = y;
        matrix.m23 = z;
        return matrix;
    }

    public static Matrix4d createRotationMatrixAndTranslation(double x, double y, double z, double rotX, double rotY, double rotZ) {
        Matrix4d matrix = new Matrix4d();
        if (rotZ != 0.0) {
            matrix.rotZ(Math.toRadians(rotZ));
        } else {
            matrix.setIdentity();
        }
        if (rotY != 0.0) {
            MatrixUtils.mul(matrix, MatrixUtils.createRotationMatrixY(rotY));
        }
        if (rotX != 0.0) {
            MatrixUtils.mul(matrix, MatrixUtils.createRotationMatrixX(rotX));
        }
        matrix.m03 = x;
        matrix.m13 = y;
        matrix.m23 = z;
        return matrix;
    }

    public static Matrix3d createRotationMatrixX(double angle) {
        Matrix3d matrix = new Matrix3d();
        matrix.rotX(Math.toRadians(angle));
        return matrix;
    }

    private static Matrix3d createRotationMatrixXRadians(double radians) {
        Matrix3d matrix = new Matrix3d();
        matrix.rotX(radians);
        return matrix;
    }

    public static Matrix3d createRotationMatrixY(double angle) {
        Matrix3d matrix = new Matrix3d();
        matrix.rotY(Math.toRadians(angle));
        return matrix;
    }

    private static Matrix3d createRotationMatrixYRadians(double radians) {
        Matrix3d matrix = new Matrix3d();
        matrix.rotY(radians);
        return matrix;
    }

    public static Matrix3d createRotationMatrixZ(double angle) {
        Matrix3d matrix = new Matrix3d();
        matrix.rotZ(Math.toRadians(angle));
        return matrix;
    }

    private static Matrix3d createRotationMatrixZRadians(double radians) {
        Matrix3d matrix = new Matrix3d();
        matrix.rotZ(radians);
        return matrix;
    }

    public static class MatrixLookupTable {
        private HashMap<Double, Matrix4d> table = new HashMap();
        private HashMap<Double, Matrix4d> invertedTable = new HashMap();
        private final double rotXRadians;
        private final double rotYRadians;
        private final double rotZRadians;
        public final double rotX;
        public final double rotY;
        public final double rotZ;
        public final double x;
        public final double y;
        public final double z;
        public final boolean hasRotX;
        public final boolean hasRotY;
        public final boolean hasRotZ;
        public final boolean hasX;
        public final boolean hasY;
        public final boolean hasZ;
        public final boolean hasTranslation;
        public final boolean hasOneRotation;
        public final boolean isSimple;
        public final Vector3d rotationCenter;
        public final IVecOrigin origin;

        public MatrixLookupTable(double x, double y, double z, double rotX, double rotY, double rotZ, Vector3d rotationCenter, IVecOrigin origin) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.rotX = rotX;
            this.rotY = rotY;
            this.rotZ = rotZ;
            this.rotXRadians = Math.toRadians(rotX);
            this.rotYRadians = Math.toRadians(rotY);
            this.rotZRadians = Math.toRadians(rotZ);
            this.hasRotX = rotX != 0.0;
            this.hasRotY = rotY != 0.0;
            this.hasRotZ = rotZ != 0.0;
            this.hasX = x != 0.0;
            this.hasY = y != 0.0;
            this.hasZ = z != 0.0;
            this.hasTranslation = this.hasX || this.hasY || this.hasZ;
            this.hasOneRotation = BooleanUtils.oneTrue(this.hasRotX, this.hasRotY, this.hasRotZ);
            this.isSimple = this.isSimple();
            this.rotationCenter = rotationCenter;
            this.origin = origin;
        }

        private boolean isSimple() {
            if (BooleanUtils.oneTrue(this.hasRotX, this.hasRotY, this.hasRotZ, this.hasTranslation)) {
                if (this.hasRotX) {
                    return Math.abs(this.rotX) <= 180.0;
                }
                if (this.hasRotY) {
                    return Math.abs(this.rotY) <= 180.0;
                }
                if (this.hasRotZ) {
                    return Math.abs(this.rotZ) <= 180.0;
                }
                return true;
            }
            return false;
        }

        public int getNumberOfHalfRotations() {
            int halfRotations = 0;
            if (this.hasRotX) {
                halfRotations += (int)Math.ceil(Math.abs(this.rotX) / 180.0);
            }
            if (this.hasRotY) {
                halfRotations += (int)Math.ceil(Math.abs(this.rotY) / 180.0);
            }
            if (this.hasRotZ) {
                halfRotations += (int)Math.ceil(Math.abs(this.rotZ) / 180.0);
            }
            return halfRotations;
        }

        public Matrix4d getInverted(Double delta) {
            Matrix4d matrix = this.invertedTable.get(delta);
            if (matrix != null) {
                return matrix;
            }
            matrix = this.table.get(delta);
            if (matrix != null) {
                matrix = new Matrix4d(matrix);
                matrix.invert();
            } else {
                matrix = MatrixUtils.createRotationMatrixAndTranslationRadians(-this.x * delta, -this.y * delta, -this.z * delta, -this.rotXRadians * delta, -this.rotYRadians * delta, -this.rotZRadians * delta);
            }
            this.invertedTable.put(delta, matrix);
            return matrix;
        }

        public Matrix4d get(Double delta) {
            Matrix4d matrix = this.table.get(delta);
            if (matrix != null) {
                return matrix;
            }
            matrix = this.invertedTable.get(delta);
            if (matrix != null) {
                matrix = new Matrix4d(matrix);
                matrix.invert();
            } else {
                matrix = MatrixUtils.createRotationMatrixAndTranslationRadians(this.x * delta, this.y * delta, this.z * delta, this.rotXRadians * delta, this.rotYRadians * delta, this.rotZRadians * delta);
            }
            this.table.put(delta, matrix);
            return matrix;
        }

        public void transform(Vector3d vec, Double delta) {
            if (delta <= 0.0) {
                return;
            }
            vec.sub((Tuple3d)this.rotationCenter);
            Matrix4d matrix = this.get(delta);
            double x = matrix.m00 * vec.x + matrix.m01 * vec.y + matrix.m02 * vec.z + matrix.m03;
            double y = matrix.m10 * vec.x + matrix.m11 * vec.y + matrix.m12 * vec.z + matrix.m13;
            vec.z = matrix.m20 * vec.x + matrix.m21 * vec.y + matrix.m22 * vec.z + matrix.m23;
            vec.x = x;
            vec.y = y;
            vec.add((Tuple3d)this.rotationCenter);
        }

        public void transformInverted(Vector3d vec, Double delta) {
            if (delta <= 0.0) {
                return;
            }
            vec.sub((Tuple3d)this.rotationCenter);
            Matrix4d matrix = this.getInverted(delta);
            double x = matrix.m00 * vec.x + matrix.m01 * vec.y + matrix.m02 * vec.z + matrix.m03;
            double y = matrix.m10 * vec.x + matrix.m11 * vec.y + matrix.m12 * vec.z + matrix.m13;
            vec.z = matrix.m20 * vec.x + matrix.m21 * vec.y + matrix.m22 * vec.z + matrix.m23;
            vec.x = x;
            vec.y = y;
            vec.add((Tuple3d)this.rotationCenter);
        }

        public static void transform(Matrix4d matrix, Vector3d rotationCenter, Vector3d vec) {
            vec.sub((Tuple3d)rotationCenter);
            double x = matrix.m00 * vec.x + matrix.m01 * vec.y + matrix.m02 * vec.z + matrix.m03;
            double y = matrix.m10 * vec.x + matrix.m11 * vec.y + matrix.m12 * vec.z + matrix.m13;
            vec.z = matrix.m20 * vec.x + matrix.m21 * vec.y + matrix.m22 * vec.z + matrix.m23;
            vec.x = x;
            vec.y = y;
            vec.add((Tuple3d)rotationCenter);
        }
    }
}

