/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.gui.controls.gui.custom;

import com.creativemd.creativecore.common.gui.controls.gui.custom.GuiStackSelector;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.utils.type.HashMapList;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class GuiStackSelectorAll
extends GuiStackSelector {
    public StackCollector collector;

    public GuiStackSelectorAll(String name, int x, int y, int width, EntityPlayer player, StackCollector collector, boolean searchBar) {
        super(name, x, y, width, player, searchBar);
        this.collector = collector;
        this.updateCollectedStacks();
        this.selectFirst();
    }

    public GuiStackSelectorAll(String name, int x, int y, int width, EntityPlayer player, StackCollector collector) {
        this(name, x, y, width, player, collector, false);
    }

    @Override
    protected HashMapList<String, ItemStack> collectItems() {
        if (this.collector != null) {
            return this.collector.collect(this.getPlayer());
        }
        return null;
    }

    public void setSelectedForce(ItemStack stack) {
        if (!this.setSelected(stack)) {
            String display;
            try {
                display = stack.func_82833_r();
            }
            catch (Exception e) {
                display = ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)stack.func_77973_b())).toString();
            }
            this.caption = display;
            this.selected = stack;
            this.raiseEvent(new GuiControlChangedEvent(this));
        }
    }

    public static StackCollector getCollectorFromPlayer(EntityPlayer player, StackSelector selector) {
        if (player.func_184812_l_()) {
            return new CreativeCollector(selector);
        }
        return new InventoryCollector(selector);
    }

    public static boolean contains(String search, ItemStack stack) {
        if (search.equals("")) {
            return true;
        }
        if (GuiStackSelectorAll.getItemName(stack).toLowerCase().contains(search)) {
            return true;
        }
        for (String line : stack.func_82840_a(null, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL)) {
            if (!line.toLowerCase().contains(search)) continue;
            return true;
        }
        return false;
    }

    public static String getItemName(ItemStack stack) {
        String itemName = "";
        try {
            itemName = stack.func_82833_r();
        }
        catch (Exception e) {
            itemName = Block.func_149634_a((Item)stack.func_77973_b()) != null ? ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)Block.func_149634_a((Item)stack.func_77973_b()))).toString() : ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)stack.func_77973_b())).toString();
        }
        return itemName;
    }

    public static class BlockSelector
    extends SearchSelector {
        @Override
        public boolean allow(ItemStack stack) {
            if (super.allow(stack)) {
                return Block.func_149634_a((Item)stack.func_77973_b()) != null && !(Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockAir);
            }
            return false;
        }
    }

    public static class SearchSelector
    extends StackSelector {
        public String search = "";

        @Override
        public boolean allow(ItemStack stack) {
            return GuiStackSelectorAll.contains(this.search, stack);
        }
    }

    public static abstract class StackSelector {
        public abstract boolean allow(ItemStack var1);
    }

    public static class CreativeCollector
    extends InventoryCollector {
        public CreativeCollector(StackSelector selector) {
            super(selector);
        }

        @Override
        public HashMapList<String, ItemStack> collect(EntityPlayer player) {
            HashMapList<String, ItemStack> stacks = super.collect(player);
            NonNullList tempStacks = NonNullList.func_191196_a();
            for (Item item : Item.field_150901_e) {
                if (item == null || item.func_77640_w() == null) continue;
                item.func_150895_a(CreativeTabs.field_78027_g, tempStacks);
            }
            ArrayList<ItemStack> newStacks = new ArrayList<ItemStack>();
            for (ItemStack stack : tempStacks) {
                if (stack.func_190926_b() || !this.selector.allow(stack)) continue;
                newStacks.add(stack);
            }
            stacks.add("selector.all", (ItemStack)newStacks);
            return stacks;
        }
    }

    public static class InventoryCollector
    extends StackCollector {
        public InventoryCollector(StackSelector selector) {
            super(selector);
        }

        @Override
        public HashMapList<String, ItemStack> collect(EntityPlayer player) {
            HashMapList<String, ItemStack> stacks = new HashMapList<String, ItemStack>();
            ArrayList<ItemStack> tempStacks = new ArrayList<ItemStack>();
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                if (stack.func_190926_b() || !this.selector.allow(stack)) continue;
                tempStacks.add(stack.func_77946_l());
            }
            stacks.add("selector.inventory", (ItemStack)tempStacks);
            return stacks;
        }
    }

    public static abstract class StackCollector {
        public StackSelector selector;

        public StackCollector(StackSelector selector) {
            this.selector = selector;
        }

        public abstract HashMapList<String, ItemStack> collect(EntityPlayer var1);
    }
}

