/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.util;

import com.codetaylor.mc.athenaeum.recipe.IRecipeSingleFluidOutput;
import com.codetaylor.mc.athenaeum.recipe.IRecipeSingleOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryModifiable;

public final class RecipeHelper {
    public static <R extends IForgeRegistryEntry<R>> void removeAllRecipes(IForgeRegistryModifiable<R> registry) {
        registry.clear();
    }

    public static <R extends IForgeRegistryEntry<R> & IRecipeSingleOutput> boolean removeRecipesByOutput(IForgeRegistryModifiable<R> registry, Ingredient output) {
        Iterator iterator = registry.iterator();
        ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>(1);
        while (iterator.hasNext()) {
            IForgeRegistryEntry recipe = (IForgeRegistryEntry)iterator.next();
            if (!output.apply(((IRecipeSingleOutput)recipe).getOutput())) continue;
            toRemove.add(recipe.getRegistryName());
        }
        for (ResourceLocation resourceLocation : toRemove) {
            registry.remove(resourceLocation);
        }
        return !toRemove.isEmpty();
    }

    public static <R extends IForgeRegistryEntry<R> & IRecipeSingleFluidOutput> boolean removeRecipesByOutput(IForgeRegistryModifiable<R> registry, FluidStack output) {
        Iterator iterator = registry.iterator();
        ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>(1);
        while (iterator.hasNext()) {
            IForgeRegistryEntry recipe = (IForgeRegistryEntry)iterator.next();
            if (!output.isFluidEqual(((IRecipeSingleFluidOutput)recipe).getOutput())) continue;
            toRemove.add(recipe.getRegistryName());
        }
        for (ResourceLocation resourceLocation : toRemove) {
            registry.remove(resourceLocation);
        }
        return !toRemove.isEmpty();
    }

    public static boolean hasFurnaceFoodRecipe(ItemStack furnaceInput) {
        FurnaceRecipes furnaceRecipes = FurnaceRecipes.func_77602_a();
        ItemStack smeltingResult = furnaceRecipes.func_151395_a(furnaceInput);
        return !smeltingResult.func_190926_b() && smeltingResult.func_77973_b() instanceof ItemFood;
    }

    public static <E extends IForgeRegistryEntry<E>, F extends IForgeRegistryEntry<F>> void inherit(String parentPath, IForgeRegistryModifiable<E> inheritFrom, IForgeRegistryModifiable<F> inheritTo, Function<E, F> transformer) {
        RecipeHelper.inherit(parentPath, inheritFrom, inheritTo, transformer, null);
    }

    public static <E extends IForgeRegistryEntry<E>, F extends IForgeRegistryEntry<F>> void inherit(String parentPath, IForgeRegistryModifiable<E> inheritFrom, IForgeRegistryModifiable<F> inheritTo, Function<E, F> transformer, @Nullable Predicate<E> filter) {
        Collection valuesCollection = inheritFrom.getValuesCollection();
        ArrayList snapshot = new ArrayList(valuesCollection);
        for (IForgeRegistryEntry recipe : snapshot) {
            ResourceLocation registryName;
            if (filter != null && !filter.test(recipe) || (registryName = recipe.getRegistryName()) == null) continue;
            ResourceLocation resourceLocation = new ResourceLocation(registryName.func_110624_b(), parentPath + "/" + registryName.func_110623_a());
            inheritTo.register((IForgeRegistryEntry)((IForgeRegistryEntry)transformer.apply(recipe)).setRegistryName(resourceLocation));
        }
    }

    private RecipeHelper() {
    }
}

