/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft.worldgen;

import com.pam.harvestcraft.HarvestCraft;
import com.pam.harvestcraft.blocks.BlockRegistry;
import com.pam.harvestcraft.blocks.blocks.BlockBaseGarden;
import com.pam.harvestcraft.worldgen.WorldGenHelper;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;

public class BushWorldGen
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        Biome biome = world.getBiomeForCoordsBody(new BlockPos(x, 0, z));
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DEAD)) {
            return;
        }
        if (HarvestCraft.config.enablearidgardenGeneration && (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MESA))) {
            this.generateGarden(BlockRegistry.getGarden("aridGarden"), world, random, x, z);
        }
        if (HarvestCraft.config.enablefrostgardenGeneration && (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN))) {
            this.generateGarden(BlockRegistry.getGarden("frostGarden"), world, random, x, z);
        }
        if (HarvestCraft.config.enableshadedgardenGeneration && (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY))) {
            this.generateGarden(BlockRegistry.getGarden("shadedGarden"), world, random, x, z);
        }
        if (HarvestCraft.config.enablesoggygardenGeneration && (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.RIVER))) {
            this.generateGarden(BlockRegistry.getGarden("soggyGarden"), world, random, x, z);
        }
        if (HarvestCraft.config.enabletropicalgardenGeneration && (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN))) {
            this.generateGarden(BlockRegistry.getGarden("tropicalGarden"), world, random, x, z);
        }
        if (HarvestCraft.config.enablewindygardenGeneration && (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA))) {
            this.generateGarden(BlockRegistry.getGarden("windyGarden"), world, random, x, z);
        }
    }

    private void generateGarden(BlockBaseGarden gardenBlock, World world, Random random, int x, int z) {
        int posZ;
        int posX;
        BlockPos newPos;
        if (random.nextFloat() < (float)HarvestCraft.config.gardenRarity / 8.0f && (newPos = WorldGenHelper.getGroundPos(world, posX = x + world.field_73012_v.nextInt(16), posZ = z + world.field_73012_v.nextInt(16))) != null && gardenBlock.func_176196_c(world, newPos)) {
            world.func_180501_a(newPos, gardenBlock.func_176223_P(), 2);
        }
    }
}

