/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.world;

import com.globbypotato.rockhounding_chemistry.ModBlocks;
import com.globbypotato.rockhounding_chemistry.handlers.ModConfig;
import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;

public class ChemOresGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (ModConfig.dimensions.length > 0) {
            for (int x = 0; x < ModConfig.dimensions.length; ++x) {
                if (world.field_73011_w.getDimension() != ModConfig.dimensions[x]) continue;
                this.generateMineral(world, random, new BlockPos(chunkX * 16, 64, chunkZ * 16));
            }
        }
    }

    public void generateMineral(World world, Random random, BlockPos pos) {
        if (ModConfig.mineralFrequency > 0) {
            this.addNewMineral(ModBlocks.UNINSPECTED_MINERAL, 0, world, random, pos, 16, 16, ModConfig.mineralMinVein, ModConfig.mineralMaxVein, ModConfig.mineralFrequency, ModConfig.mineralMinLevel, ModConfig.mineralMaxLevel, Blocks.field_150348_b);
        }
    }

    public void addNewMineral(Block block, int metadata, World world, Random random, BlockPos pos, int maxX, int maxZ, int minVeinSize, int maxVeinSize, int chanceToSpawn, int minY, int maxY, Block generateIn) {
        if (minY < 0 || maxY > 256 || minY > maxY) {
            throw new IllegalArgumentException("Illegal Height Arguments for WorldGenerator");
        }
        int oreVeinSize = minVeinSize + random.nextInt(1 + (maxVeinSize - minVeinSize));
        for (int i = 0; i < chanceToSpawn; ++i) {
            int x = pos.func_177958_n() + random.nextInt(maxX);
            int y = minY + random.nextInt(1 + (maxY - minY));
            int z = pos.func_177952_p() + random.nextInt(maxZ);
            IBlockState state = block.func_176203_a(metadata);
            WorldGenMinable mine = new WorldGenMinable(state, oreVeinSize, (Predicate)BlockMatcher.func_177642_a((Block)generateIn));
            mine.func_180709_b(world, random, new BlockPos(x, y, z));
        }
    }
}

