/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.utils;

import com.globbypotato.rockhounding_chemistry.ModItems;
import com.globbypotato.rockhounding_chemistry.enums.EnumFluid;
import com.globbypotato.rockhounding_chemistry.handlers.ModConfig;
import com.globbypotato.rockhounding_chemistry.utils.BaseRecipes;
import com.globbypotato.rockhounding_core.enums.EnumFluidNbt;
import com.globbypotato.rockhounding_core.utils.CoreUtils;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;

public class ModUtils {
    public static final int HEIGHT = 200;
    public static String immersive_id = "immersiveengineering";
    public static String mekanism_id = "mekanism";
    public static String forestry_id = "forestry";
    public static String thermal_f_id = "thermalfoundation";
    public static String actually_id = "actuallyadditions";
    public static String openblocks_id = "openblocks";
    public static String gcplanet_id = "galacticraftplanets";
    public static String wawla_id = "wawla";
    public static String creosote = "creosote";
    public static String liquidXP = "xpjuice";
    public static String forestry_biomass = "biomass";
    public static String mek_liquid_oxygen = "liquidoxygen";
    public static String mek_brine = "brine";
    public static String mek_steam = "steam";
    public static String mek_sulfuric_acid = "sulfuricacid";
    public static String gc_sulphuric_acid = "sulphuricacid";

    public static boolean isValidSpeedUpgrade(ItemStack insertingStack) {
        return insertingStack != null && insertingStack.func_77973_b() == ModItems.SPEED_ITEMS && insertingStack.func_77952_i() > 0;
    }

    public static int speedUpgrade(ItemStack insertingStack) {
        return ModUtils.isValidSpeedUpgrade(insertingStack) ? insertingStack.func_77952_i() + 1 : 1;
    }

    public static boolean isValidFilterUpgrade(ItemStack insertingStack) {
        return insertingStack != null && insertingStack.func_77973_b() == ModItems.FILTER_ITEMS && insertingStack.func_77952_i() > 0;
    }

    public static int filterUpgrade(ItemStack insertingStack) {
        return ModUtils.isValidFilterUpgrade(insertingStack) ? insertingStack.func_77952_i() : 0;
    }

    public static float stepDivision(int meta) {
        if (meta == 1) {
            return 1.0f;
        }
        if (meta == 2) {
            return 0.8f;
        }
        if (meta == 3) {
            return 0.6f;
        }
        if (meta == 4) {
            return 0.4f;
        }
        if (meta == 5) {
            return 0.2f;
        }
        return 1.0f;
    }

    public static boolean isOrbiterProbe(ItemStack insertingStack) {
        return insertingStack != null && insertingStack.func_77973_b() == ModItems.PROBE_ITEMS;
    }

    public static void setFluidFilter(ItemStack heldItem, NBTTagCompound gas) {
        heldItem.func_77978_p().func_74782_a(EnumFluidNbt.FLUID.nameTag(), (NBTBase)gas);
        if (heldItem.func_77978_p().func_74764_b(EnumFluidNbt.GAS.nameTag())) {
            heldItem.func_77978_p().func_82580_o(EnumFluidNbt.GAS.nameTag());
        }
    }

    public static void setGasFilter(ItemStack heldItem, NBTTagCompound gas) {
        heldItem.func_77978_p().func_74782_a(EnumFluidNbt.GAS.nameTag(), (NBTBase)gas);
        if (heldItem.func_77978_p().func_74764_b(EnumFluidNbt.FLUID.nameTag())) {
            heldItem.func_77978_p().func_82580_o(EnumFluidNbt.FLUID.nameTag());
        }
    }

    public static ItemStack handleFilterStack(ItemStack heldItem) {
        ItemStack filtersample = ItemStack.field_190927_a;
        if (!heldItem.func_190926_b()) {
            filtersample = new ItemStack(heldItem.func_77973_b(), 1, heldItem.func_77952_i());
            return filtersample;
        }
        return ItemStack.field_190927_a;
    }

    public static FluidStack handleAmpoule(ItemStack heldItem, boolean acceptFluid, boolean acceptGas) {
        FluidStack filterSample = null;
        if (!heldItem.func_190926_b() && heldItem.func_77969_a(BaseRecipes.sampling_ampoule)) {
            NBTTagCompound tag;
            if (acceptFluid) {
                if (!heldItem.func_77942_o()) {
                    heldItem.func_77982_d(new NBTTagCompound());
                }
                if (heldItem.func_77942_o() && (tag = heldItem.func_77978_p()).func_74764_b(EnumFluidNbt.FLUID.nameTag()) && (filterSample = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l(EnumFluidNbt.FLUID.nameTag()))) != null && filterSample.getFluid() != null && !filterSample.getFluid().isGaseous()) {
                    return filterSample;
                }
            }
            if (acceptGas) {
                if (!heldItem.func_77942_o()) {
                    heldItem.func_77982_d(new NBTTagCompound());
                }
                if (heldItem.func_77942_o() && (tag = heldItem.func_77978_p()).func_74764_b(EnumFluidNbt.GAS.nameTag()) && (filterSample = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l(EnumFluidNbt.GAS.nameTag()))) != null && filterSample.getFluid() != null && filterSample.getFluid().isGaseous()) {
                    return filterSample;
                }
            }
        }
        return null;
    }

    public static boolean hasMekanism() {
        return Loader.isModLoaded((String)mekanism_id);
    }

    public static boolean hasImmersiveEng() {
        return Loader.isModLoaded((String)immersive_id);
    }

    public static boolean hasOpenBlocks() {
        return Loader.isModLoaded((String)openblocks_id);
    }

    public static boolean hasForestry() {
        return Loader.isModLoaded((String)forestry_id);
    }

    public static boolean hasTFoundation() {
        return Loader.isModLoaded((String)thermal_f_id);
    }

    public static boolean hasActuallyAdd() {
        return Loader.isModLoaded((String)actually_id);
    }

    public static boolean hasGCPlanets() {
        return Loader.isModLoaded((String)gcplanet_id);
    }

    public static boolean hasWawla() {
        return Loader.isModLoaded((String)wawla_id);
    }

    public static FluidStack creosoteFix() {
        if (ModUtils.hasImmersiveEng() && CoreUtils.fluidExists((String)creosote)) {
            return CoreUtils.getFluid((String)creosote, (int)50);
        }
        return BaseRecipes.getFluid(EnumFluid.TOXIC_WASTE, 50);
    }

    public static FluidStack liquidXP() {
        if (ModUtils.hasOpenBlocks() && CoreUtils.fluidExists((String)liquidXP)) {
            return CoreUtils.getFluid((String)liquidXP, (int)20);
        }
        return null;
    }

    public static ItemStack mekanism_biofuel() {
        Item material;
        ItemStack temp;
        if (ModUtils.hasMekanism() && !(temp = CoreUtils.getModdedStack((Item)(material = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(mekanism_id + ":biofuel"))), (int)1, (int)0)).func_190926_b()) {
            return temp;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack forestry_compost() {
        Item material;
        ItemStack temp;
        if (ModUtils.hasForestry() && !(temp = CoreUtils.getModdedStack((Item)(material = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(forestry_id + ":fertilizer_bio"))), (int)1, (int)0)).func_190926_b()) {
            return temp;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack forestry_charcoal() {
        Item material;
        ItemStack temp;
        if (ModUtils.hasForestry() && !(temp = CoreUtils.getModdedStack((Item)(material = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(forestry_id + ":charcoal"))), (int)1, (int)0)).func_190926_b()) {
            return temp;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack thermal_f_tar() {
        Item material;
        ItemStack temp;
        if (ModUtils.hasTFoundation() && !(temp = CoreUtils.getModdedStack((Item)(material = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(thermal_f_id + ":material"))), (int)1, (int)833)).func_190926_b()) {
            return temp;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack thermal_f_wrench() {
        Item material;
        ItemStack temp;
        if (ModUtils.hasTFoundation() && !(temp = CoreUtils.getModdedStack((Item)(material = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(thermal_f_id + ":wrench"))), (int)1, (int)0)).func_190926_b()) {
            return temp;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack actually_biomass() {
        Item material;
        ItemStack temp;
        if (ModUtils.hasActuallyAdd() && !(temp = CoreUtils.getModdedStack((Item)(material = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(actually_id + ":item_misc"))), (int)1, (int)21)).func_190926_b()) {
            return temp;
        }
        return ItemStack.field_190927_a;
    }

    public static int substanceCoeff(Fluid fluid) {
        return fluid != null ? (fluid.getDensity() + fluid.getViscosity()) / 2 : 0;
    }

    public static double kinematicCoeff(Fluid fluid) {
        return fluid != null ? (double)fluid.getViscosity() / (double)fluid.getDensity() : 0.0;
    }

    public static String doubleTranslate(double amount) {
        DecimalFormat decForm = new DecimalFormat("0.00", new DecimalFormatSymbols());
        decForm.setRoundingMode(RoundingMode.CEILING);
        return decForm.format(amount);
    }

    public static boolean isLightFluid(Fluid fluid) {
        return ModUtils.substanceCoeff(fluid) <= ModConfig.tankSubstance && ModUtils.kinematicCoeff(fluid) <= ModConfig.kinematicPar;
    }

    public static boolean isHeavyFluid(Fluid fluid) {
        return ModUtils.substanceCoeff(fluid) > ModConfig.tankSubstance || ModUtils.kinematicCoeff(fluid) > ModConfig.kinematicPar;
    }
}

