/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.handlers.ModConfig;
import com.globbypotato.rockhounding_chemistry.machines.recipe.SeasoningRackRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.SeasoningRackRecipe;
import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.machines.tileentity.WrappedItemHandler;
import com.globbypotato.rockhounding_core.utils.CoreUtils;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.oredict.OreDictionary;

public class TESeasoningRack
extends TileEntityInv {
    public static int inputSlots = 1;
    public static int outputSlots = 1;

    public TESeasoningRack() {
        super(inputSlots, outputSlots, 0, 0);
        this.input = new MachineStackHandler(inputSlots, this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == 0 && TESeasoningRack.this.isValidInput(insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationInput = new WrappedItemHandler((IItemHandlerModifiable)this.input, WrappedItemHandler.WriteMode.IN);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        return compound;
    }

    public ItemStack inputSlot() {
        return this.input.getStackInSlot(0);
    }

    public ItemStack outputSlot() {
        return this.output.getStackInSlot(0);
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "seasoning_rack";
    }

    public int getCooktimeMax() {
        return ModConfig.speedSeasoning;
    }

    public ArrayList<SeasoningRackRecipe> recipeList() {
        return SeasoningRackRecipes.seasoning_rack_recipes;
    }

    public SeasoningRackRecipe getRecipeList(int x) {
        return this.recipeList().get(x);
    }

    boolean isValidInput(ItemStack stack) {
        if (!stack.func_190926_b()) {
            for (SeasoningRackRecipe recipe : this.recipeList()) {
                ArrayList inputOreIDs;
                if (!(recipe.getType() ? !(inputOreIDs = CoreUtils.intArrayToList((int[])OreDictionary.getOreIDs((ItemStack)stack))).isEmpty() && inputOreIDs.contains(OreDictionary.getOreID((String)recipe.getOredict())) : recipe.getInput().func_77969_a(stack))) continue;
                return true;
            }
        }
        return false;
    }

    public SeasoningRackRecipe getCurrentRecipe() {
        if (!this.inputSlot().func_190926_b()) {
            for (int x = 0; x < this.recipeList().size(); ++x) {
                ArrayList inputOreIDs = CoreUtils.intArrayToList((int[])OreDictionary.getOreIDs((ItemStack)this.inputSlot()));
                if (!(this.getRecipeList(x).getType() ? inputOreIDs.contains(OreDictionary.getOreID((String)this.getRecipeList(x).getOredict())) : this.getRecipeList(x).getInput().func_77969_a(this.inputSlot()))) continue;
                return this.getRecipeList(x);
            }
        }
        return null;
    }

    public boolean isValidRecipe() {
        return this.getCurrentRecipe() != null;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (!this.inputSlot().func_190926_b()) {
                if (this.canProcess()) {
                    ++this.cooktime;
                    if (this.getCooktime() >= this.getCooktimeMax()) {
                        this.cooktime = 0;
                        this.process();
                    }
                    this.markDirtyClient();
                } else {
                    this.tickOff();
                }
            } else {
                this.tickOff();
            }
        }
    }

    private boolean canProcess() {
        return this.isValidRecipe() && this.output.canSetOrStack(this.outputSlot(), this.getCurrentRecipe().getOutput());
    }

    public void process() {
        this.output.setOrStack(0, this.getCurrentRecipe().getOutput());
        this.input.decrementSlot(0);
    }
}

