/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.machines.recipe.GasReformerRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.GasReformerRecipe;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEReformerController;
import com.globbypotato.rockhounding_chemistry.utils.BaseRecipes;
import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.machines.tileentity.WrappedItemHandler;
import com.globbypotato.rockhounding_core.utils.CoreUtils;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TEReformerReactor
extends TileEntityInv {
    public static final int[] SLOT_SYSTEM_CAT = new int[]{0, 1, 2, 3, 4, 5};
    public static final int[] SLOT_RECIPE_CAT = new int[]{6, 7, 8, 9};
    public static final int SLOT_PURGE = 0;
    public static int totCatalysts = SLOT_SYSTEM_CAT.length + SLOT_RECIPE_CAT.length;
    public static int outputSlots = 1;
    public int tierS1 = 0;
    public int tierS2 = 0;
    public int tierS3 = 0;
    public int tierR1 = 0;
    public int tierR2 = 0;
    private int countCat;

    public TEReformerReactor() {
        super(totCatalysts, outputSlots, 0, 0);
        this.input = new MachineStackHandler(totCatalysts, this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot >= SLOT_SYSTEM_CAT[0] && slot <= SLOT_SYSTEM_CAT[SLOT_SYSTEM_CAT.length - 1] && TEReformerReactor.this.isSystemCatalyst(insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                if (slot >= SLOT_RECIPE_CAT[0] && slot <= SLOT_RECIPE_CAT[SLOT_RECIPE_CAT.length - 1] && TEReformerReactor.this.isRecipeCatalyst(insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationInput = new WrappedItemHandler((IItemHandlerModifiable)this.input, WrappedItemHandler.WriteMode.IN);
    }

    public ItemStack inputSlot(int x) {
        return this.input.getStackInSlot(x);
    }

    public ItemStack purgeSlot() {
        return this.output.getStackInSlot(0);
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "reformer_reactor";
    }

    public ArrayList<GasReformerRecipe> recipeList() {
        return GasReformerRecipes.gas_reformer_recipes;
    }

    public GasReformerRecipe getRecipeList(int x) {
        return this.recipeList().get(x);
    }

    public int getRecipeIndex() {
        return this.hasReformer() ? this.getReformer().getRecipeIndex() : -1;
    }

    public GasReformerRecipe getCurrentRecipe() {
        return this.hasReformer() ? this.getReformer().getDummyRecipe() : null;
    }

    public boolean isValidPreset() {
        return this.hasReformer() ? this.getReformer().isValidPreset() : false;
    }

    public boolean isValidRecipe() {
        return this.getCurrentRecipe() != null;
    }

    public ItemStack getRecipeCatalyst() {
        return this.isValidPreset() ? this.recipeList().get(this.getRecipeIndex()).getCatalyst() : ItemStack.field_190927_a;
    }

    public ItemStack catalystA() {
        return BaseRecipes.nl_catalyst.func_77946_l();
    }

    public ItemStack catalystB() {
        return BaseRecipes.gr_catalyst.func_77946_l();
    }

    public ItemStack catalystC() {
        return BaseRecipes.wg_catalyst.func_77946_l();
    }

    public ItemStack catalystD() {
        return BaseRecipes.au_catalyst.func_77946_l();
    }

    public boolean isSystemCatalyst(ItemStack insertingStack) {
        return CoreUtils.hasConsumable((ItemStack)this.catalystA(), (ItemStack)insertingStack) || CoreUtils.hasConsumable((ItemStack)this.catalystB(), (ItemStack)insertingStack) || CoreUtils.hasConsumable((ItemStack)this.catalystC(), (ItemStack)insertingStack);
    }

    public boolean isRecipeCatalyst(ItemStack insertingStack) {
        return insertingStack.func_185136_b(this.getRecipeCatalyst()) || insertingStack.func_185136_b(this.catalystD());
    }

    public TEReformerController getReformer() {
        TEReformerController reactor;
        BlockPos reactorPos = this.field_174879_c.func_177967_a(EnumFacing.DOWN, 1);
        TileEntity te = this.field_145850_b.func_175625_s(reactorPos);
        if (this.field_145850_b.func_180495_p(reactorPos) != null && te instanceof TEReformerController && (reactor = (TEReformerController)te).getFacing() == this.getFacing()) {
            return reactor;
        }
        return null;
    }

    public boolean hasReformer() {
        return this.getReformer() != null;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.handlePurge();
        }
    }

    private void handlePurge() {
        if (!this.isValidPreset() || !this.isValidRecipe()) {
            if (this.countCat < SLOT_RECIPE_CAT.length) {
                int inp = SLOT_RECIPE_CAT[this.countCat];
                if (!this.inputSlot(inp).func_190926_b() && !this.getRecipeCatalyst().func_190926_b() && !this.isRecipeCatalyst(this.inputSlot(inp)) && this.output.canSetOrStack(this.purgeSlot(), this.inputSlot(inp))) {
                    this.output.setOrStack(0, this.inputSlot(inp));
                    this.input.setStackInSlot(inp, ItemStack.field_190927_a);
                    ++this.countCat;
                }
            } else {
                this.countCat = 0;
            }
        }
    }
}

