/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.handlers.ModConfig;
import com.globbypotato.rockhounding_chemistry.machines.recipe.MaterialCabinetRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.MaterialCabinetRecipe;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEExtractorBalance;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEMaterialCabinetTop;
import com.globbypotato.rockhounding_chemistry.utils.BaseRecipes;
import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.utils.CoreUtils;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.oredict.OreDictionary;

public class TEMaterialCabinetBase
extends TileEntityInv {
    public int[] elementList = new int[63];
    private int currentElement;

    public TEMaterialCabinetBase() {
        super(0, 0, 0, 0);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("ElementsList")) {
            NBTTagCompound elements = compound.func_74775_l("ElementsList");
            for (int i = 0; i < this.elementList.length; ++i) {
                this.elementList[i] = elements.func_74762_e("element" + i);
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagCompound elements = new NBTTagCompound();
        for (int i = 0; i < this.elementList.length; ++i) {
            elements.func_74768_a("element" + i, this.elementList[i]);
        }
        compound.func_74782_a("ElementsList", (NBTBase)elements);
        return compound;
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "material_cabinet_base";
    }

    public int getExtractingFactor() {
        return ModConfig.extractorFactor;
    }

    public TEMaterialCabinetTop getInjector() {
        TEMaterialCabinetTop injector;
        BlockPos injectorPos = this.field_174879_c.func_177967_a(EnumFacing.UP, 1);
        TileEntity te = this.field_145850_b.func_175625_s(injectorPos);
        if (this.field_145850_b.func_180495_p(injectorPos) != null && te instanceof TEMaterialCabinetTop && (injector = (TEMaterialCabinetTop)te).getFacing() == this.getFacing()) {
            return injector;
        }
        return null;
    }

    public boolean hasInjector() {
        return this.getInjector() != null;
    }

    private boolean hasCylinder() {
        return this.hasInjector() && CoreUtils.hasConsumable((ItemStack)BaseRecipes.graduated_cylinder, (ItemStack)this.getInjector().getInput().getStackInSlot(1));
    }

    public TEExtractorBalance getBalance() {
        TEExtractorBalance balance;
        BlockPos injectorPos = this.field_174879_c.func_177967_a(this.isFacingAt(90), 1);
        TileEntity te = this.field_145850_b.func_175625_s(injectorPos);
        if (this.field_145850_b.func_180495_p(injectorPos) != null && te instanceof TEExtractorBalance && (balance = (TEExtractorBalance)te).getFacing() == this.isFacingAt(90).func_176734_d()) {
            return balance;
        }
        return null;
    }

    public boolean hasBalance() {
        return this.getBalance() != null;
    }

    public ArrayList<MaterialCabinetRecipe> recipeList() {
        return MaterialCabinetRecipes.material_cabinet_recipes;
    }

    public MaterialCabinetRecipe getRecipeList(int x) {
        return this.recipeList().get(x);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.hasBalance()) {
            if (this.getCooktime() >= ModConfig.cabinetTiming) {
                NonNullList oredictedList = OreDictionary.getOres((String)this.getRecipeList(this.currentElement).getOredict());
                if (!oredictedList.isEmpty() && oredictedList.size() > 0) {
                    ItemStack elementStack = ((ItemStack)oredictedList.get(0)).func_77946_l();
                    if (!((ItemStack)oredictedList.get(0)).func_190926_b()) {
                        while (this.hasCylinder() && this.elementList[this.currentElement] >= this.getExtractingFactor() && this.canBalance(elementStack)) {
                            int n = this.currentElement;
                            this.elementList[n] = this.elementList[n] - this.getExtractingFactor();
                            ((MachineStackHandler)this.getBalance().getOutput()).setOrIncrement(0, elementStack);
                            ((MachineStackHandler)this.getInjector().getInput()).damageSlot(1);
                        }
                        this.currentElement = this.currentElement < this.recipeList().size() - 1 ? ++this.currentElement : 0;
                        this.cooktime = 0;
                        this.markDirtyClient();
                    }
                } else {
                    this.currentElement = 0;
                    this.cooktime = 0;
                    this.func_70296_d();
                }
            } else {
                ++this.cooktime;
                this.func_70296_d();
            }
        }
    }

    private boolean canBalance(ItemStack elementStack) {
        return ((MachineStackHandler)this.getBalance().getOutput()).canSetOrStack(this.getBalance().getOutput().getStackInSlot(0), elementStack);
    }
}

