/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.machines.recipe.GasifierPlantRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.GasifierPlantRecipe;
import com.globbypotato.rockhounding_chemistry.machines.tile.IToxic;
import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityTank;
import com.globbypotato.rockhounding_core.machines.tileentity.WrappedItemHandler;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerConcatenate;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TEGasifierTank
extends TileEntityTank
implements IToxic {
    public FluidTank inputTank = new FluidTank(this.getTankCapacity()){

        public boolean canFillFluidType(FluidStack fluid) {
            return TEGasifierTank.this.canFillFiltered(fluid);
        }

        public boolean canDrain() {
            return true;
        }
    };
    public static int FILL_BUCKET = 0;
    public static int inputSlots = 1;
    public static int templateSlots = 2;
    public FluidStack filter = null;

    public TEGasifierTank() {
        super(inputSlots, 0, templateSlots, 0);
        this.inputTank.setTileEntity((TileEntity)this);
        this.input = new MachineStackHandler(inputSlots, (TileEntityInv)this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == FILL_BUCKET && TEGasifierTank.isValidSlurry(FluidUtil.getFluidContained((ItemStack)insertingStack))) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationInput = new WrappedItemHandler((IItemHandlerModifiable)this.input, WrappedItemHandler.WriteMode.IN);
        this.markDirtyClient();
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inputTank.readFromNBT(compound.func_74775_l("InputTank"));
        this.filter = FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound.func_74775_l("Filter"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagCompound inputTankNBT = new NBTTagCompound();
        this.inputTank.writeToNBT(inputTankNBT);
        compound.func_74782_a("InputTank", (NBTBase)inputTankNBT);
        if (this.getFilter() != null) {
            NBTTagCompound filterNBT = new NBTTagCompound();
            this.filter.writeToNBT(filterNBT);
            compound.func_74782_a("Filter", (NBTBase)filterNBT);
        }
        return compound;
    }

    public FluidHandlerConcatenate getCombinedTank() {
        return new FluidHandlerConcatenate(new IFluidHandler[]{this.inputTank});
    }

    public ItemStack fillSlot() {
        return this.input.getStackInSlot(FILL_BUCKET);
    }

    public static ArrayList<GasifierPlantRecipe> recipeList() {
        return GasifierPlantRecipes.gasifier_plant_recipes;
    }

    public static GasifierPlantRecipe getRecipeList(int x) {
        return TEGasifierTank.recipeList().get(x);
    }

    public static boolean isValidSlurry(FluidStack fluid) {
        return TEGasifierTank.recipeList().stream().anyMatch(recipe -> fluid != null && recipe.getInput() != null && fluid.isFluidEqual(recipe.getInput()));
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "gasifier_tank";
    }

    @Override
    public ArrayList<FluidTank> hazardList() {
        ArrayList<FluidTank> tanks = new ArrayList<FluidTank>();
        tanks.add(this.inputTank);
        return tanks;
    }

    public FluidStack getFilter() {
        return this.filter;
    }

    public boolean hasFilter() {
        return this.getFilter() != null;
    }

    public boolean canFillFiltered(FluidStack fluid) {
        return this.hasFilter() ? this.getFilter().isFluidEqual(fluid) : TEGasifierTank.isValidSlurry(fluid);
    }

    public int getTankCapacity() {
        return 20000;
    }

    public boolean hasInputFluid() {
        return this.inputTank.getFluid() != null;
    }

    public FluidStack getInputFluid() {
        return this.hasInputFluid() ? this.inputTank.getFluid() : null;
    }

    public int getInputAmount() {
        return this.hasInputFluid() ? this.inputTank.getFluidAmount() : 0;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.emptyContainer(FILL_BUCKET, this.inputTank);
            this.handleToxic(this.field_145850_b, this.field_174879_c);
            this.markDirtyClient();
        }
    }
}

