/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.machines.tile.IToxic;
import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityTank;
import com.globbypotato.rockhounding_core.machines.tileentity.WrappedItemHandler;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerConcatenate;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TEFluidInputTank
extends TileEntityTank
implements IToxic {
    public static int inputSlots = 2;
    public static int templateSlots = 4;
    public boolean isFiltered;
    public FluidTank solventTank = new FluidTank(this.getTankCapacity()){

        public boolean canFillFluidType(FluidStack fluid) {
            return TEFluidInputTank.this.canFillSolvent(fluid) || TEFluidInputTank.this.canForceSolvent(fluid);
        }

        public boolean canDrain() {
            return TEFluidInputTank.this.canDrainFilteredSolvent(TEFluidInputTank.this.getSolventFluid());
        }
    };
    public FluidTank reagentTank;
    public static int SOLVENT_SLOT = 0;
    public static int REAGENT_SLOT = 1;
    public FluidStack filterSolvent = null;
    public FluidStack filterReagent = null;
    public FluidStack filterManualSolvent = null;
    public FluidStack filterManualReagent = null;

    public TEFluidInputTank() {
        super(inputSlots, 0, templateSlots, 0);
        this.solventTank.setTileEntity((TileEntity)this);
        this.reagentTank = new FluidTank(this.getTankCapacity()){

            public boolean canFillFluidType(FluidStack fluid) {
                return TEFluidInputTank.this.canFillReagent(fluid) || TEFluidInputTank.this.canForceReagent(fluid);
            }

            public boolean canDrain() {
                return TEFluidInputTank.this.canDrainFilteredReagent(TEFluidInputTank.this.getReagentFluid());
            }
        };
        this.reagentTank.setTileEntity((TileEntity)this);
        this.input = new MachineStackHandler(inputSlots, (TileEntityInv)this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == SOLVENT_SLOT && (TEFluidInputTank.this.canForceSolvent(FluidUtil.getFluidContained((ItemStack)insertingStack)) || TEFluidInputTank.this.canFillSolvent(FluidUtil.getFluidContained((ItemStack)insertingStack)))) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                if (slot == REAGENT_SLOT && TEFluidInputTank.this.canForceReagent(FluidUtil.getFluidContained((ItemStack)insertingStack)) || TEFluidInputTank.this.canFillReagent(FluidUtil.getFluidContained((ItemStack)insertingStack))) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationInput = new WrappedItemHandler((IItemHandlerModifiable)this.input, WrappedItemHandler.WriteMode.IN);
        this.markDirtyClient();
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.isFiltered = compound.func_74767_n("Filtered");
        this.solventTank.readFromNBT(compound.func_74775_l("SolventTank"));
        this.reagentTank.readFromNBT(compound.func_74775_l("ReagentTank"));
        this.filterSolvent = FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound.func_74775_l("FilterSolvent"));
        this.filterReagent = FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound.func_74775_l("FilterReagent"));
        this.filterManualSolvent = FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound.func_74775_l("ManualSolvent"));
        this.filterManualReagent = FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound.func_74775_l("ManualReagent"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("Filtered", this.isFiltered());
        NBTTagCompound solventTankNBT = new NBTTagCompound();
        this.solventTank.writeToNBT(solventTankNBT);
        compound.func_74782_a("SolventTank", (NBTBase)solventTankNBT);
        NBTTagCompound reagentTankNBT = new NBTTagCompound();
        this.reagentTank.writeToNBT(reagentTankNBT);
        compound.func_74782_a("ReagentTank", (NBTBase)reagentTankNBT);
        if (this.getFilterSolvent() != null) {
            NBTTagCompound filterSolventNBT = new NBTTagCompound();
            this.filterSolvent.writeToNBT(filterSolventNBT);
            compound.func_74782_a("FilterSolvent", (NBTBase)filterSolventNBT);
        }
        if (this.getFilterReagent() != null) {
            NBTTagCompound filterReagentNBT = new NBTTagCompound();
            this.filterReagent.writeToNBT(filterReagentNBT);
            compound.func_74782_a("FilterReagent", (NBTBase)filterReagentNBT);
        }
        if (this.getManualSolvent() != null) {
            NBTTagCompound manualSolventNBT = new NBTTagCompound();
            this.filterManualSolvent.writeToNBT(manualSolventNBT);
            compound.func_74782_a("ManualSolvent", (NBTBase)manualSolventNBT);
        }
        if (this.getManualReagent() != null) {
            NBTTagCompound manualReagentNBT = new NBTTagCompound();
            this.filterManualReagent.writeToNBT(manualReagentNBT);
            compound.func_74782_a("ManualReagent", (NBTBase)manualReagentNBT);
        }
        return compound;
    }

    public FluidHandlerConcatenate getCombinedTank() {
        return new FluidHandlerConcatenate(new IFluidHandler[]{this.solventTank, this.reagentTank});
    }

    public ItemStack fillSolvent() {
        return this.input.getStackInSlot(SOLVENT_SLOT);
    }

    public ItemStack fillReagent() {
        return this.input.getStackInSlot(REAGENT_SLOT);
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "lab_oven_intank";
    }

    @Override
    public ArrayList<FluidTank> hazardList() {
        ArrayList<FluidTank> tanks = new ArrayList<FluidTank>();
        tanks.add(this.solventTank);
        tanks.add(this.reagentTank);
        return tanks;
    }

    public FluidStack getFilterSolvent() {
        return this.filterSolvent;
    }

    public boolean hasFilterSolvent() {
        return this.filterSolvent != null;
    }

    public FluidStack getFilterReagent() {
        return this.filterReagent;
    }

    public boolean hasFilterReagent() {
        return this.filterReagent != null;
    }

    public FluidStack getManualSolvent() {
        return this.filterManualSolvent;
    }

    public boolean hasManualSolvent() {
        return this.filterManualSolvent != null;
    }

    public FluidStack getManualReagent() {
        return this.filterManualReagent;
    }

    public boolean hasManualReagent() {
        return this.filterManualReagent != null;
    }

    public boolean isFiltered() {
        return this.isFiltered;
    }

    public int getTankCapacity() {
        return 5000;
    }

    public boolean hasSolventFluid() {
        return this.solventTank.getFluid() != null;
    }

    public FluidStack getSolventFluid() {
        return this.hasSolventFluid() ? this.solventTank.getFluid() : null;
    }

    public int getSolventAmount() {
        return this.hasSolventFluid() ? this.solventTank.getFluidAmount() : 0;
    }

    public boolean hasReagentFluid() {
        return this.reagentTank.getFluid() != null;
    }

    public FluidStack getReagentFluid() {
        return this.hasReagentFluid() ? this.reagentTank.getFluid() : null;
    }

    public int getReagentAmount() {
        return this.hasReagentFluid() ? this.reagentTank.getFluidAmount() : 0;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.emptyContainer(SOLVENT_SLOT, this.solventTank);
            this.emptyContainer(REAGENT_SLOT, this.reagentTank);
            this.markDirtyClient();
        }
    }

    public boolean canForceSolvent(FluidStack fluid) {
        return this.input.canSetOrFillFluid(this.solventTank, this.getSolventFluid(), fluid) && this.isFiltered() && this.hasFilterSolvent() && fluid.isFluidEqual(this.getFilterSolvent());
    }

    public boolean canForceReagent(FluidStack fluid) {
        return this.input.canSetOrFillFluid(this.reagentTank, this.getReagentFluid(), fluid) && this.isFiltered() && this.hasFilterReagent() && fluid.isFluidEqual(this.getFilterReagent());
    }

    boolean canDrainFilteredSolvent(FluidStack fluid) {
        return this.isFiltered() && (!this.hasFilterSolvent() || this.hasFilterSolvent() && !fluid.isFluidEqual(this.getFilterSolvent()));
    }

    boolean canDrainFilteredReagent(FluidStack fluid) {
        return this.isFiltered() && (!this.hasFilterReagent() || this.hasFilterReagent() && !fluid.isFluidEqual(this.getFilterReagent()));
    }

    public boolean canFillSolvent(FluidStack fluid) {
        return this.input.canSetOrFillFluid(this.solventTank, this.getSolventFluid(), fluid) && this.isManualFilteredSolvent(fluid);
    }

    private boolean isManualFilteredSolvent(FluidStack fluid) {
        return !this.isFiltered() ? !this.hasManualSolvent() || this.hasManualSolvent() && this.getManualSolvent().isFluidEqual(fluid) : false;
    }

    public boolean canFillReagent(FluidStack fluid) {
        return this.input.canSetOrFillFluid(this.reagentTank, this.getReagentFluid(), fluid) && this.isManualFilteredReagent(fluid);
    }

    private boolean isManualFilteredReagent(FluidStack fluid) {
        return !this.isFiltered() ? !this.hasManualReagent() || this.hasManualReagent() && this.getManualReagent().isFluidEqual(fluid) : false;
    }
}

